/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/designers/DesignerUtils;", "", "()V", "getEditorComposites", "", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "renameDefaultEditor", "", "tryOpenEditor", "provider", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "tryOpenTab", "", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "editorProviderId", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDesignerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerUtils.kt\ncom/jetbrains/rider/designers/DesignerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1747#2,3:76\n800#2,11:79\n1549#2:90\n1620#2,3:91\n*S KotlinDebug\n*F\n+ 1 DesignerUtils.kt\ncom/jetbrains/rider/designers/DesignerUtils\n*L\n19#1:76,3\n35#1:79,11\n36#1:90\n36#1:91,3\n*E\n"})
public final class DesignerUtils {
    @NotNull
    public static final DesignerUtils INSTANCE = new DesignerUtils();

    private DesignerUtils() {
    }

    public final void tryOpenEditor(@NotNull VirtualFile file2, @NotNull Project project, @Nullable FileEditorProvider provider2) {
        boolean bl;
        EditorComposite editorComposite;
        block7: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            EditorComposite editorComposite2 = (EditorComposite)CollectionsKt.firstOrNull(this.getEditorComposites(file2, project));
            if (editorComposite2 == null) {
                return;
            }
            editorComposite = editorComposite2;
            Iterable iterable = editorComposite.getAllEditors();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    FileEditor fileEditor = (FileEditor)t;
                    boolean bl3 = false;
                    if (!(fileEditor instanceof WinFormsEditor)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            if (provider2 != null) {
                FileEditor fileEditor = provider2.createEditor(project, file2);
                Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"createEditor(...)");
                editorComposite.addEditor(fileEditor, provider2);
            } else {
                ApplicationKt.getApplication().invokeLater(() -> DesignerUtils.j(project, file2));
            }
        }
        this.renameDefaultEditor(file2, project);
    }

    public static /* synthetic */ void tryOpenEditor$default(DesignerUtils designerUtils, VirtualFile virtualFile2, Project project, FileEditorProvider fileEditorProvider, int n2, Object object) {
        if ((n2 & 4) != 0) {
            fileEditorProvider = null;
        }
        designerUtils.tryOpenEditor(virtualFile2, project, fileEditorProvider);
    }

    public final void renameDefaultEditor(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        for (EditorComposite editorComposite : this.getEditorComposites(file2, project)) {
            Iterable iterable = editorComposite.getAllEditors();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t : iterable2) {
                if (!(t instanceof TextEditor)) continue;
                collection.add(t);
            }
            iterable = (List)collection;
            bl = false;
            iterable2 = iterable;
            collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            bl2 = false;
            for (Object t : iterable2) {
                TextEditor textEditor = (TextEditor)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                editorComposite.setDisplayName((FileEditor)textEditor, RiderDesignersBundle.Companion.message("DesignerUtils.tab.title.code", new Object[0]));
                collection2.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)collection;
        }
    }

    public final boolean tryOpenTab(@NotNull DesignerEditorBase $this$tryOpenTab, @NotNull String editorProviderId) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$tryOpenTab), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)editorProviderId, (String)"editorProviderId");
        FileEditorManager fileEditorManager2 = FileEditorManager.getInstance((Project)$this$tryOpenTab.getProject());
        if (!(fileEditorManager2 instanceof FileEditorManagerEx)) {
            return false;
        }
        for (EditorWindow editorWindow : ((FileEditorManagerEx)fileEditorManager2).getWindows()) {
            for (EditorComposite editorComposite : editorWindow.getAllComposites()) {
                for (FileEditor fileEditor : editorComposite.getAllEditors()) {
                    if (!Intrinsics.areEqual((Object)fileEditor, (Object)((Object)$this$tryOpenTab))) continue;
                    editorWindow.setAsCurrentWindow(true);
                    editorWindow.setSelectedComposite(editorComposite, true);
                    fileEditorManager2.setSelectedEditor(editorComposite.getFile(), editorProviderId);
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    public final List<EditorComposite> getEditorComposites(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList arrayList = new ArrayList();
        FileEditorManager fileEditorManager2 = FileEditorManager.getInstance((Project)project);
        Object object = fileEditorManager2 instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager2 : null;
        if (object == null || (object = object.getAllSplitters()) == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = object;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            fileEditorManager2 = (EditorsSplitters)iterator2.next();
            arrayList.addAll(fileEditorManager2.getAllComposites(file2));
        }
        return arrayList;
    }

    private static final void j(Project project, VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$file");
        FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
    }
}

