/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.DesignerUtils;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001d\u0010\u000e\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H&R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/designers/DesignerEditorProviderBase;", "T", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "()V", "openedDesignerEditors", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "j", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createDesignerEditor", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/rider/designers/DesignerEditorBase;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "disposeEditor", "", "editor", "isDesignerNode", "isDesignerNodeDescriptor", "descriptor", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDesignerEditorProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerEditorProviderBase.kt\ncom/jetbrains/rider/designers/DesignerEditorProviderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n1747#2,3:72\n766#2:75\n857#2,2:76\n1855#2,2:89\n4098#3,11:78\n*S KotlinDebug\n*F\n+ 1 DesignerEditorProviderBase.kt\ncom/jetbrains/rider/designers/DesignerEditorProviderBase\n*L\n47#1:72,3\n58#1:75\n58#1:76,2\n65#1:89,2\n63#1:78,11\n*E\n"})
public abstract class DesignerEditorProviderBase<T extends DesignerEditorBase>
implements FileEditorProvider {
    @NotNull
    private final HashSet<T> openedDesignerEditors = new HashSet();

    public DesignerEditorProviderBase() {
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                openedDesignerEditors.removeIf(arg_0 -> 1.j((Function1)new Function1<T, Boolean>(project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull T editor2) {
                        Intrinsics.checkNotNullParameter(editor2, (String)"editor");
                        return Intrinsics.areEqual((Object)((DesignerEditorBase)((Object)editor2)).getProject(), (Object)this.$project);
                    }
                }, arg_0));
            }

            private static final boolean j(Function1 function1, Object object) {
                Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
                return (Boolean)function1.invoke(object);
            }
        });
    }

    @NotNull
    public abstract T createDesignerEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    public abstract boolean isDesignerNodeDescriptor(@NotNull RdProjectFileDescriptor var1);

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        T t = this.createDesignerEditor(project, file2);
        CollectionExKt.addUnique((Collection)this.openedDesignerEditors, (Lifetime)((DesignerEditorBase)((Object)t)).getLifetime(), t);
        SwingUtilities.invokeLater(() -> DesignerEditorProviderBase.j(file2, project));
        return (FileEditor)t;
    }

    public void disposeEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TypeIntrinsics.asMutableCollection((Object)this.openedDesignerEditors).remove(editor2);
    }

    protected final boolean isDesignerNode(@NotNull Project project, @NotNull VirtualFile file2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)file2, (Project)project);
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                    boolean bl3 = false;
                    RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity.getDescriptor();
                    boolean bl4 = rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? this.isDesignerNodeDescriptor((RdProjectFileDescriptor)rdProjectModelItemDescriptor) && this.j(project, file2) : false;
                    if (!bl4) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean j(Project project, VirtualFile virtualFile2) {
        Object[] objectArray = (Object[])this.openedDesignerEditors;
        boolean bl = false;
        Object object = objectArray;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            Object t = object2.next();
            DesignerEditorBase designerEditorBase = (DesignerEditorBase)((Object)t);
            int n2 = 0;
            if (!Intrinsics.areEqual((Object)designerEditorBase.getFile(), (Object)virtualFile2)) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        if (list2.isEmpty()) {
            return true;
        }
        objectArray = FileEditorManagerEx.Companion.getInstanceEx(project);
        FileEditor[] fileEditorArray = objectArray.getEditors(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        object = fileEditorArray;
        boolean bl3 = false;
        Object object3 = object;
        object2 = new ArrayList();
        boolean bl4 = false;
        for (Object object4 : object3) {
            if (!(object4 instanceof DesignerEditorBase)) continue;
            object2.add(object4);
        }
        List list3 = (List)object2;
        if (list3.isEmpty()) {
            object = list2;
            bl3 = false;
            object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                DesignerEditorBase designerEditorBase = (DesignerEditorBase)((Object)object2);
                int n3 = 0;
                this.disposeEditor(designerEditorBase);
            }
            return true;
        }
        return false;
    }

    private static final void j(VirtualFile virtualFile2, Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
        DesignerUtils.INSTANCE.renameDefaultEditor(virtualFile2, project);
    }
}

