/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.wasm.splash;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.wasm.splash.BuiltInSplashScreenInfo;
import com.jetbrains.rider.debugger.wasm.splash.BuiltInSplashScreenManager;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.debugger.wasm.util.UriUtilKt;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\f0\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager;", "Lcom/jetbrains/rider/debugger/wasm/splash/SplashScreenPageManager;", "()V", "builtInServerManager", "Lorg/jetbrains/ide/BuiltInServerManager;", "j", "()Lorg/jetbrains/ide/BuiltInServerManager;", "builtInServerManager$delegate", "Lkotlin/Lazy;", "ourSplashPattern", "Lkotlin/text/Regex;", "createSplashScreenUrl", "", "realUrl", "Ljava/net/URI;", "j", "kotlin.jvm.PlatformType", "N", "extractRealUrl", "splashScreenUrl", "isSplashScreenUrl", "", "splashUrl", "isSplashScreenUrlFor", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nBuiltInSplashScreenManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInSplashScreenManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class BuiltInSplashScreenManager
implements SplashScreenPageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy builtInServerManager$delegate = LazyKt.lazy((Function0)builtInServerManager.2.INSTANCE);
    @NotNull
    private final Regex ourSplashPattern = new Regex("^.+" + BuiltInSplashScreenInfo.INSTANCE.getEndpoint() + "\\?oncomplete=(?<realUrl>.+)$");
    @NotNull
    private static final String OnCompleteUrlParam = "oncomplete";

    private final BuiltInServerManager j() {
        Lazy lazy = this.builtInServerManager$delegate;
        return (BuiltInServerManager)lazy.getValue();
    }

    @Override
    @NotNull
    public String createSplashScreenUrl(@NotNull URI realUrl) {
        Intrinsics.checkNotNullParameter((Object)realUrl, (String)"realUrl");
        URI uRI = new URI("http", "localhost:" + this.j().getPort(), BuiltInSplashScreenInfo.INSTANCE.getEndpoint(), null, null);
        String string = realUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return uRI + "?oncomplete=" + this.N(string);
    }

    @Override
    public boolean isSplashScreenUrl(@NotNull String splashUrl) {
        Intrinsics.checkNotNullParameter((Object)splashUrl, (String)"splashUrl");
        return this.ourSplashPattern.matches((CharSequence)splashUrl);
    }

    @Override
    public boolean isSplashScreenUrlFor(@NotNull String splashUrl, @NotNull URI realUrl) {
        Intrinsics.checkNotNullParameter((Object)splashUrl, (String)"splashUrl");
        Intrinsics.checkNotNullParameter((Object)realUrl, (String)"realUrl");
        URI uRI = this.extractRealUrl(splashUrl);
        if (uRI == null) {
            return false;
        }
        URI uRI2 = uRI;
        return Intrinsics.areEqual((Object)UriUtilKt.toUriTrailingSlashAware(uRI2), (Object)UriUtilKt.toUriTrailingSlashAware(realUrl));
    }

    @Override
    @Nullable
    public URI extractRealUrl(@NotNull String splashScreenUrl) {
        Intrinsics.checkNotNullParameter((Object)splashScreenUrl, (String)"splashScreenUrl");
        MatchResult matchResult = this.ourSplashPattern.matchEntire((CharSequence)splashScreenUrl);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null || (matchResult = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult, (String)"realUrl")) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String string = matchResult2.getValue();
        String string2 = this.j(string);
        return URI.create(string2);
    }

    private final String N(String string) {
        String string2 = string;
        boolean bl = false;
        String string3 = URLEncoder.encode(string2, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"let(...)");
        return StringsKt.replace$default((String)string3, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    private final String j(String string) {
        String string2 = string;
        boolean bl = false;
        return URLDecoder.decode(string2, StandardCharsets.UTF_8);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager$Companion;", "", "()V", "OnCompleteUrlParam", "", "getInstance", "Lcom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nBuiltInSplashScreenManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInSplashScreenManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n31#2,2:59\n*S KotlinDebug\n*F\n+ 1 BuiltInSplashScreenManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/BuiltInSplashScreenManager$Companion\n*L\n21#1:59,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuiltInSplashScreenManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<BuiltInSplashScreenManager> clazz = BuiltInSplashScreenManager.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (BuiltInSplashScreenManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

