/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.wasm.splash;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.debugger.wasm.util.UriUtilKt;
import java.net.URI;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager;", "Lcom/jetbrains/rider/debugger/wasm/splash/SplashScreenPageManager;", "()V", "PLACEHOLDER_PATTERN", "Lkotlin/text/Regex;", "createSplashScreenUrl", "", "realUrl", "Ljava/net/URI;", "extractRealUrl", "splashScreenUrl", "isSplashScreenUrl", "", "isSplashScreenUrlFor", "j", "data", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAboutBlankSplashPageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutBlankSplashPageManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class AboutBlankSplashPageManager
implements SplashScreenPageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex PLACEHOLDER_PATTERN = new Regex("^about:blank\\?realUrl=(?<realUrl>.+)$");
    @NotNull
    private static final String REAL_URL_PARAM = "realUrl";

    @Override
    @NotNull
    public String createSplashScreenUrl(@NotNull URI realUrl) {
        Intrinsics.checkNotNullParameter((Object)realUrl, (String)REAL_URL_PARAM);
        String string = realUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "data:text/html;charset=UTF-8," + this.j("<script language='javascript'>window.location='about:blank?realUrl=" + UriUtilKt.toUriTrailingSlashAware(string) + "'</script>");
    }

    @Override
    public boolean isSplashScreenUrl(@NotNull String splashScreenUrl) {
        Intrinsics.checkNotNullParameter((Object)splashScreenUrl, (String)"splashScreenUrl");
        return this.PLACEHOLDER_PATTERN.matches((CharSequence)splashScreenUrl);
    }

    @Override
    public boolean isSplashScreenUrlFor(@NotNull String splashScreenUrl, @NotNull URI realUrl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)splashScreenUrl, (String)"splashScreenUrl");
        Intrinsics.checkNotNullParameter((Object)realUrl, (String)REAL_URL_PARAM);
        URI uRI = this.extractRealUrl(splashScreenUrl);
        if (uRI != null) {
            URI uRI2 = uRI;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)uRI2, (Object)realUrl);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public URI extractRealUrl(@NotNull String splashScreenUrl) {
        Intrinsics.checkNotNullParameter((Object)splashScreenUrl, (String)"splashScreenUrl");
        MatchResult matchResult = Regex.find$default((Regex)this.PLACEHOLDER_PATTERN, (CharSequence)splashScreenUrl, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2, (String)REAL_URL_PARAM);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object object2 = object;
        return URI.create((String)object2);
    }

    private final String j(String string) {
        String string2 = URLEncoder.encode(string, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(...)");
        return StringsKt.replace$default((String)string2, (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager$Companion;", "", "()V", "REAL_URL_PARAM", "", "getInstance", "Lcom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nAboutBlankSplashPageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutBlankSplashPageManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,51:1\n31#2,2:52\n*S KotlinDebug\n*F\n+ 1 AboutBlankSplashPageManager.kt\ncom/jetbrains/rider/debugger/wasm/splash/AboutBlankSplashPageManager$Companion\n*L\n21#1:52,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AboutBlankSplashPageManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<AboutBlankSplashPageManager> clazz = AboutBlankSplashPageManager.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (AboutBlankSplashPageManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

