/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.wasm.browser;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.debugger.wasm.ProcessHandlerExtensionsKt;
import com.jetbrains.rider.debugger.wasm.browser.ChromiumDebuggableBrowser;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.run.FormatPreservingCommandLine;
import com.jetbrains.rider.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser;", "", "webBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "evaluatedUserDataFolder", "Ljava/io/File;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/intellij/ide/browsers/WebBrowser;Ljava/io/File;Lcom/intellij/execution/process/ProcessHandler;)V", "getEvaluatedUserDataFolder", "()Ljava/io/File;", "getHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "getWebBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "Companion", "intellij.rider"})
public final class ChromiumDebuggableBrowser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebBrowser webBrowser;
    @NotNull
    private final File evaluatedUserDataFolder;
    @NotNull
    private final ProcessHandler handler;
    @NotNull
    private static final Lazy<Logger> logger$delegate = LazyKt.lazy((Function0)Companion.logger.2.INSTANCE);

    private ChromiumDebuggableBrowser(WebBrowser webBrowser, File evaluatedUserDataFolder, ProcessHandler handler2) {
        this.webBrowser = webBrowser;
        this.evaluatedUserDataFolder = evaluatedUserDataFolder;
        this.handler = handler2;
    }

    @NotNull
    public final WebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    @NotNull
    public final File getEvaluatedUserDataFolder() {
        return this.evaluatedUserDataFolder;
    }

    @NotNull
    public final ProcessHandler getHandler() {
        return this.handler;
    }

    public /* synthetic */ ChromiumDebuggableBrowser(WebBrowser webBrowser, File evaluatedUserDataFolder, ProcessHandler handler2, DefaultConstructorMarker $constructor_marker) {
        this(webBrowser, evaluatedUserDataFolder, handler2);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J1\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ(\u0010\u0018\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010#\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010$R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "j", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "j", "", "evaluatedUserDataFolder", "Ljava/io/File;", "j", "T", "webBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "block", "Lkotlin/Function1;", "Lcom/intellij/ide/browsers/chrome/ChromeSettings;", "(Lcom/intellij/ide/browsers/WebBrowser;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "j", "", "", "launch", "Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser;", "url", "Ljava/net/URI;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/ide/browsers/WebBrowser;Ljava/net/URI;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/intellij/execution/process/ProcessHandler;", "appUrl", "j", "", "j", "(Lcom/intellij/ide/browsers/WebBrowser;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nChromiumDebuggableBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumDebuggableBrowser.kt\ncom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger j() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object launch(@NotNull WebBrowser var1_1, @NotNull URI var2_2, @NotNull Project var3_3, @NotNull Continuation<? super ChromiumDebuggableBrowser> var4_4) {
            if (!(var4_4 instanceof launch.1)) ** GOTO lbl-1000
            var8_5 = var4_4;
            if ((var8_5.label & -2147483648) != 0) {
                var8_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                var8_5 = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.launch(null, null, null, (Continuation<? super ChromiumDebuggableBrowser>)((Continuation)this));
                    }
                };
            }
            var7_6 = var8_5.result;
            var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch (var8_5.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)var7_6);
                    if (webBrowser.getFamily() != BrowserFamily.CHROME) {
                        throw new CantRunException("Chromium debugging supports only " + BrowserFamily.CHROME + " family");
                    }
                    var8_5.L$0 = this;
                    var8_5.L$1 = webBrowser;
                    var8_5.L$2 = url;
                    var8_5.L$3 = project;
                    var8_5.label = 1;
                    v0 = this.j(webBrowser, (Continuation<? super File>)var8_5);
                    if (v0 == var9_7) {
                        return var9_7;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    project = (Project)var8_5.L$3;
                    url = (URI)var8_5.L$2;
                    webBrowser = (WebBrowser)var8_5.L$1;
                    this = (Companion)var8_5.L$0;
                    ResultKt.throwOnFailure((Object)var7_6);
                    v0 = var7_6;
lbl30:
                    // 2 sources

                    var5_8 = (File)v0;
                    var6_9 = this.j(url, var5_8, webBrowser, project);
                    return new ChromiumDebuggableBrowser(webBrowser, var5_8, var6_9, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object j(WebBrowser webBrowser, Continuation<? super File> continuation) {
            File file2;
            boolean bl = DotNetDebuggerSettings.Companion.getInstance().getEnableDefaultCliOptions();
            if (bl) {
                Object object = RdCoroutinesUtilKt.withIOBackgroundContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(null){
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                File file2 = FileUtil.createTempDirectory((String)"blazor_debug_user_data", null, (boolean)true);
                                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(...)");
                                return file2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), continuation, (int)1, null);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                file2 = (File)object;
            } else {
                file2 = (Boolean)this.j(webBrowser, obtainUserDataDir.3.INSTANCE) != false ? new File(ChromeSettingsConfigurable.getDefaultUserDataPath()) : (File)this.j(webBrowser, obtainUserDataDir.4.INSTANCE);
            }
            return file2;
        }

        private final ProcessHandler j(URI uRI, File file2, WebBrowser webBrowser, Project project) {
            this.j().info("Evaluated browser info:");
            this.j().info("\tName: " + webBrowser.getName());
            this.j().info("\tFamily: " + webBrowser.getFamily().getName());
            this.j().info("\tPath: " + webBrowser.getPath());
            this.j().info("\tUser data folder: " + file2);
            this.j().info("Starting browser...");
            this.j(file2);
            String string = SplashScreenPageManager.Companion.getInstance(project).createSplashScreenUrl(uRI);
            this.j().warn("Generated page placeholder for '" + uRI + "': '" + string + "'");
            List<String> list2 = this.j(webBrowser);
            Object object = new String[]{string};
            GeneralCommandLine generalCommandLine = new FormatPreservingCommandLine().withExePath((String)CollectionsKt.first(list2)).withParameters(CollectionsKt.drop((Iterable)list2, (int)1)).withParameters(object);
            object = new String[]{"--args"};
            GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(object);
            object = new String[]{"--remote-debugging-port=0"};
            GeneralCommandLine generalCommandLine3 = generalCommandLine2.withParameters(object);
            object = new String[]{"--user-data-dir=" + file2.getAbsolutePath()};
            GeneralCommandLine generalCommandLine4 = generalCommandLine3.withParameters(object);
            object = new String[]{"--no-first-run"};
            GeneralCommandLine generalCommandLine5 = generalCommandLine4.withParameters(object);
            object = new String[]{"--disable-fre"};
            GeneralCommandLine generalCommandLine6 = generalCommandLine5.withParameters(object);
            object = new String[]{"--no-default-browser-check"};
            GeneralCommandLine generalCommandLine7 = generalCommandLine6.withParameters(object);
            object = new String[]{"--disable-background-networking"};
            GeneralCommandLine generalCommandLine8 = generalCommandLine7.withParameters(object);
            object = new String[]{"--disable-background-timer-throttling"};
            GeneralCommandLine generalCommandLine9 = generalCommandLine8.withParameters(object);
            object = new String[]{"--disable-backgrounding-occluded-windows"};
            GeneralCommandLine generalCommandLine10 = generalCommandLine9.withParameters(object);
            object = new String[]{"--disable-breakpad"};
            GeneralCommandLine generalCommandLine11 = generalCommandLine10.withParameters(object);
            object = new String[]{"--disable-client-side-phishing-detection"};
            GeneralCommandLine generalCommandLine12 = generalCommandLine11.withParameters(object);
            object = new String[]{"--disable-default-apps"};
            GeneralCommandLine generalCommandLine13 = generalCommandLine12.withParameters(object);
            object = new String[]{"--disable-dev-shm-usage"};
            GeneralCommandLine generalCommandLine14 = generalCommandLine13.withParameters(object);
            object = new String[]{"--disable-renderer-backgrounding"};
            GeneralCommandLine generalCommandLine15 = generalCommandLine14.withParameters(object);
            object = new String[]{"--disable-sync"};
            GeneralCommandLine generalCommandLine16 = generalCommandLine15.withParameters(object);
            object = new String[]{"--metrics-recording-only"};
            GeneralCommandLine generalCommandLine17 = generalCommandLine16.withParameters(object);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine17, (String)"withParameters(...)");
            GeneralCommandLine generalCommandLine18 = generalCommandLine17;
            this.j().info("Executing launch browser command: " + generalCommandLine18.getCommandLineString());
            KillableProcessHandler killableProcessHandler = new KillableProcessHandler(generalCommandLine18){

                protected BaseOutputReader.Options readerOptions() {
                    return BaseOutputReader.Options.forMostlySilentProcess();
                }
            };
            object = killableProcessHandler;
            boolean bl = false;
            ProcessHandlerExtensionsKt.attachOutputMonitoring((ProcessHandler)object, "Chromium Browser");
            object.startNotify();
            return (ProcessHandler)killableProcessHandler;
        }

        private final void j(File file2) {
            if (!this.j(file2)) {
                File file3 = FilesKt.resolve((File)file2, (String)"DevToolsActivePort");
                this.j().info("No lock file at user data folder, deleting port file located at '" + file3 + "'");
                file3.delete();
            }
        }

        private final boolean j(File file2) {
            boolean bl;
            if (SystemInfo.isWindows) {
                bl = FilesKt.resolve((File)file2, (String)"lockfile").exists();
            } else if (SystemInfo.isUnix) {
                Object[] objectArray = file2.list(Companion::j);
                bl = objectArray != null ? ArraysKt.any((Object[])objectArray) : false;
            } else {
                this.j().warn("trying to check chrome lockfile on unsupported platform: " + SystemInfo.OS_NAME + ", " + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH);
                return false;
            }
            return bl;
        }

        private final List<String> j(WebBrowser webBrowser) {
            String string = webBrowser.getPath();
            List list2 = BrowserUtil.getOpenBrowserCommand((String)PathUtil.toSystemDependentName((String)string), null, (List)CollectionsKt.emptyList(), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOpenBrowserCommand(...)");
            List list3 = CollectionsKt.toMutableList((Collection)list2);
            if (Intrinsics.areEqual((Object)CollectionsKt.first((List)list3), (Object)ExecUtil.getWindowsShellName())) {
                try {
                    WinReg.HKEY hKEY = WinReg.HKEY_LOCAL_MACHINE;
                    Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_LOCAL_MACHINE");
                    String string2 = new RegistryRoot(hKEY, Lifetime.Companion.getEternal()).fromKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + string + ".exe").getStringValue("Path");
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2;
                    File file2 = new File(string3);
                    File file3 = new File(file2, string + ".exe");
                    list3 = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)file3.getAbsolutePath()));
                }
                catch (Exception exception) {
                    this.j().info("Cannot find registry key", (Throwable)exception);
                }
            }
            return list3;
        }

        private final <T> T j(WebBrowser webBrowser, Function1<? super ChromeSettings, ? extends T> function1) {
            Object object;
            block3: {
                block2: {
                    ChromeSettingsConfigurable chromeSettingsConfigurable;
                    object = webBrowser.getSpecificSettings();
                    if (object == null) break block2;
                    BrowserSpecificSettings browserSpecificSettings = object;
                    boolean bl = false;
                    BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = (ChromeSettings)browserSpecificSettings;
                    boolean bl2 = false;
                    ChromeSettingsConfigurable chromeSettingsConfigurable2 = chromeSettingsConfigurable = browserSpecificSettings2.createConfigurable();
                    boolean bl3 = false;
                    chromeSettingsConfigurable2.reset();
                    chromeSettingsConfigurable2.apply();
                    browserSpecificSettings2 = browserSpecificSettings;
                    object = function1.invoke((Object)browserSpecificSettings2);
                    if (object != null) break block3;
                }
                throw new CantRunException(RiderDebuggerBundle.Companion.message("dialog.message.no.chrome.settings", new Object[0]));
            }
            return (T)object;
        }

        private static final boolean j(File file2, String string) {
            String string2 = string;
            return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"SingletonLock", (boolean)false, (int)2, null) : false;
        }

        public static final /* synthetic */ Object access$obtainUserDataDir(Companion $this, WebBrowser webBrowser, Continuation $completion) {
            return $this.j(webBrowser, (Continuation<? super File>)$completion);
        }

        public static final /* synthetic */ Logger access$getLogger(Companion $this) {
            return $this.j();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

