/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.visualizers;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetDebuggerVisualizersKt;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerPresenterTab;
import com.jetbrains.rider.debugger.visualizers.RiderDebuggerValuePresenter;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesProxy;
import com.jetbrains.rider.model.debuggerWorker.ValueFlags;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u001a\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerStringPresenter;", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerValuePresenter;", "()V", "createTabs", "", "Lcom/jetbrains/rider/debugger/visualizers/RiderDebuggerPresenterTab;", "value", "Lcom/jetbrains/rider/debugger/IDotNetValue;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "properties", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesBase;", "stringPresentation", "", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLinkName", "getPriority", "", "isApplicable", "", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesProxy;", "shouldIgnorePropertiesReevaluation", "intellij.rider"})
public final class RiderDebuggerStringPresenter
implements RiderDebuggerValuePresenter {
    @Override
    public boolean isApplicable(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return properties.getValueFlags().contains(ValueFlags.EllipsizedValue) || properties.getValueFlags().contains(ValueFlags.IsString) && !properties.getValueFlags().contains(ValueFlags.IsNull);
    }

    @Override
    @NotNull
    public List<RiderDebuggerPresenterTab> createTabs(@NotNull IDotNetValue value, @NotNull XValueNode node, @NotNull ObjectPropertiesBase properties, @Nullable String stringPresentation, @NotNull XValuePlace place, @NotNull XDebugSession session, @NotNull Lifetime lifetime2) {
        List list2;
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Project project = session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (properties.getValueFlags().contains(ValueFlags.IsNull)) {
            string = null;
        } else {
            string = stringPresentation;
            if (string == null) {
                string = DotNetValueUtilsKt.getSimplePresentation(properties.getValue());
            }
        }
        if ((list2 = DotNetDebuggerVisualizersKt.createDebuggerVisualizer(project, string)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    public boolean shouldIgnorePropertiesReevaluation(@NotNull XValueNode node, @NotNull ObjectPropertiesProxy properties, @NotNull XValuePlace place, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return properties.getValueFlags().contains(ValueFlags.IsString) && !properties.getValueFlags().contains(ValueFlags.EllipsizedValue);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getLinkName() {
        return RiderDebuggerBundle.Companion.message("debugger.action.link.view", new Object[0]);
    }
}

