/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.model.debuggerWorker.TextRangeProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"canJumpToStatement", "", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "dotNetExecutionStack", "Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "line", "", "intellij.rider"})
public final class JumpToStatementUtilKt {
    public static final boolean canJumpToStatement(int line, @NotNull DotNetExecutionStack dotNetExecutionStack) {
        Intrinsics.checkNotNullParameter((Object)((Object)dotNetExecutionStack), (String)"dotNetExecutionStack");
        TextRangeProxy textRangeProxy = dotNetExecutionStack.getTopFrameMethodRange();
        if (textRangeProxy == null) {
            return false;
        }
        int n2 = line + 1;
        TextRangeProxy textRangeProxy2 = textRangeProxy;
        return n2 >= textRangeProxy2.getStartLine() && n2 < textRangeProxy2.getEndLine();
    }

    public static final boolean canJumpToStatement(@NotNull XSourcePosition sourcePosition, @NotNull DotNetExecutionStack dotNetExecutionStack) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        Intrinsics.checkNotNullParameter((Object)((Object)dotNetExecutionStack), (String)"dotNetExecutionStack");
        TextRangeProxy textRangeProxy = dotNetExecutionStack.getTopFrameMethodRange();
        if (textRangeProxy == null) {
            return false;
        }
        TextRangeProxy textRangeProxy2 = textRangeProxy;
        int n2 = sourcePosition.getLine() + 1;
        DotNetStackFrame dotNetStackFrame = dotNetExecutionStack.getTopFrame();
        if (!Intrinsics.areEqual((Object)(dotNetStackFrame != null && (dotNetStackFrame = dotNetStackFrame.getSourcePosition()) != null ? dotNetStackFrame.getFile() : null), (Object)sourcePosition.getFile())) {
            return false;
        }
        return n2 >= textRangeProxy2.getStartLine() && n2 <= textRangeProxy2.getEndLine();
    }
}

