/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.model.DebugPausedContextInfoProxy;
import com.jetbrains.rider.model.MethodRangeProxy;
import com.jetbrains.rider.model.SourcePosition;
import com.jetbrains.rider.model.debuggerWorker.TextRangeProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0010"}, d2={"createDebugPausedContextInfo", "Lcom/jetbrains/rider/model/DebugPausedContextInfoProxy;", "dotNetDebugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "j", "", "line", "column", "document", "Lcom/intellij/openapi/editor/Document;", "(IILcom/intellij/openapi/editor/Document;)Ljava/lang/Integer;", "j", "Lcom/jetbrains/rider/model/MethodRangeProxy;", "Lcom/jetbrains/rider/model/debuggerWorker/TextRangeProxy;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider"})
public final class ContextActionsUtilKt {
    @Nullable
    public static final DebugPausedContextInfoProxy createDebugPausedContextInfo(@NotNull DotNetDebugProcess dotNetDebugProcess) {
        MethodRangeProxy methodRangeProxy;
        DotNetExecutionStack dotNetExecutionStack;
        SourcePosition sourcePosition;
        XSourcePosition xSourcePosition;
        Intrinsics.checkNotNullParameter((Object)((Object)dotNetDebugProcess), (String)"dotNetDebugProcess");
        XDebugSession xDebugSession = dotNetDebugProcess.getSession();
        if (xDebugSession.getSuspendContext() == null) {
            return null;
        }
        boolean bl = DotNetDebugProcessUtilKt.canFetchHeapValues(dotNetDebugProcess);
        boolean bl2 = DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess);
        XDebugSessionImpl xDebugSessionImpl = xDebugSession instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession : null;
        Object object = xDebugSessionImpl != null ? xDebugSessionImpl.getCurrentExecutionStack() : null;
        XExecutionStack xExecutionStack = object;
        XSourcePosition xSourcePosition2 = xExecutionStack != null && (xExecutionStack = xExecutionStack.getTopFrame()) != null ? xExecutionStack.getSourcePosition() : (xSourcePosition = null);
        if (xSourcePosition != null) {
            String string = xSourcePosition.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            v4 = new SourcePosition(string, xSourcePosition.getOffset());
        } else {
            v4 = sourcePosition = null;
        }
        if ((dotNetExecutionStack = object instanceof DotNetExecutionStack ? (DotNetExecutionStack)((Object)object) : null) != null && (dotNetExecutionStack = dotNetExecutionStack.getTopFrameMethodRange()) != null) {
            XSourcePosition xSourcePosition3 = xSourcePosition;
            methodRangeProxy = ContextActionsUtilKt.j((TextRangeProxy)dotNetExecutionStack, (VirtualFile)(xSourcePosition3 != null ? xSourcePosition3.getFile() : null));
        } else {
            methodRangeProxy = null;
        }
        return new DebugPausedContextInfoProxy(bl, bl2, sourcePosition, methodRangeProxy);
    }

    private static final MethodRangeProxy j(TextRangeProxy textRangeProxy, VirtualFile virtualFile2) {
        if (textRangeProxy == null) {
            return null;
        }
        if (virtualFile2 == null) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        Integer n2 = ContextActionsUtilKt.j(textRangeProxy.getStartLine(), textRangeProxy.getStartColumn(), document3);
        if (n2 == null) {
            return null;
        }
        int n3 = n2;
        Integer n4 = ContextActionsUtilKt.j(textRangeProxy.getEndLine(), textRangeProxy.getEndColumn(), document3);
        int n5 = n4 != null ? n4 : n3;
        return new MethodRangeProxy(n3, n5);
    }

    private static final Integer j(int n2, int n3, Document document2) {
        if (n2 - 1 >= document2.getLineCount()) {
            return null;
        }
        int n4 = document2.getLineStartOffset(n2 - 1) + n3 - 1;
        if (n4 > document2.getTextLength()) {
            n4 = document2.getTextLength() - 1;
        }
        return n4;
    }
}

