/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.table.view.renderers;

import com.intellij.ui.ColoredTextContainer;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.tasksView.shared.NodePresenter;
import com.jetbrains.rider.debugger.tasksView.shared.TasksTableCellRenderer;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.nodes.ParallelTasksFrameNode;
import com.jetbrains.rider.model.debuggerWorker.RdTasksViewNodeStatus;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001e\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/table/view/renderers/NodeLocationRenderer;", "Lcom/jetbrains/rider/debugger/tasksView/shared/TasksTableCellRenderer;", "presenter", "Lcom/jetbrains/rider/debugger/tasksView/shared/NodePresenter;", "showIfScheduled", "", "frameNodeProvider", "Lkotlin/Function1;", "", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/nodes/ParallelTasksFrameNode;", "(Lcom/jetbrains/rider/debugger/tasksView/shared/NodePresenter;ZLkotlin/jvm/functions/Function1;)V", "customize", "", "value", "isSelected", "row", "", "intellij.rider"})
public final class NodeLocationRenderer
extends TasksTableCellRenderer {
    @NotNull
    private final NodePresenter presenter;
    private final boolean showIfScheduled;
    @NotNull
    private final Function1<Object, ParallelTasksFrameNode> frameNodeProvider;

    public NodeLocationRenderer(@NotNull NodePresenter presenter, boolean showIfScheduled, @NotNull Function1<Object, ? extends ParallelTasksFrameNode> frameNodeProvider) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
        Intrinsics.checkNotNullParameter(frameNodeProvider, (String)"frameNodeProvider");
        this.presenter = presenter;
        this.showIfScheduled = showIfScheduled;
        this.frameNodeProvider = frameNodeProvider;
    }

    @Override
    protected void customize(@Nullable Object value, boolean isSelected, int row) {
        ParallelTasksFrameNode parallelTasksFrameNode = (ParallelTasksFrameNode)this.frameNodeProvider.invoke(value);
        if (parallelTasksFrameNode == null) {
            return;
        }
        ParallelTasksFrameNode parallelTasksFrameNode2 = parallelTasksFrameNode;
        if (parallelTasksFrameNode2.getNode().getStatus() == RdTasksViewNodeStatus.Scheduled && !this.showIfScheduled) {
            this.append(RiderDebuggerBundle.Companion.message("scheduled.and.waiting.to.run", new Object[0]));
        } else {
            this.presenter.present(parallelTasksFrameNode2, (ColoredTextContainer)this, Integer.MAX_VALUE);
        }
    }
}

