/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.table.view.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.NlsActions;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.tasksView.shared.graph.TaskNode;
import com.jetbrains.rider.debugger.tasksView.table.view.TasksTable;
import com.jetbrains.rider.debugger.tasksView.table.view.actions.NavigationLocation;
import com.jetbrains.rider.debugger.tasksView.table.view.actions.TasksTableAction;
import com.jetbrains.rider.model.debuggerWorker.RdTasksViewNodeStatus;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigateToTaskLocationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/TasksTableAction;", "location", "Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigationLocation;", "(Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigationLocation;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "j", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.rider"})
public final class NavigateToTaskLocationAction
extends AnAction
implements TasksTableAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NavigationLocation location;

    public NavigateToTaskLocationAction(@NotNull NavigationLocation location) {
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        super(NavigateToTaskLocationAction.Companion.j(location));
        this.location = location;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TasksTable tasksTable = this.getTasksTable(e);
        if (tasksTable == null) {
            return;
        }
        TasksTable tasksTable2 = tasksTable;
        TaskNode taskNode = tasksTable2.getSelectedTask();
        if (taskNode == null) {
            return;
        }
        TaskNode taskNode2 = taskNode;
        tasksTable2.navigateTo(taskNode2, this.location);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.j(e));
    }

    private final boolean j(AnActionEvent anActionEvent) {
        TasksTable tasksTable = this.getTasksTable(anActionEvent);
        if (tasksTable == null) {
            return false;
        }
        TasksTable tasksTable2 = tasksTable;
        TaskNode taskNode = tasksTable2.getSelectedTask();
        if (taskNode == null) {
            return false;
        }
        TaskNode taskNode2 = taskNode;
        if (taskNode2.getStatus() == RdTasksViewNodeStatus.Scheduled && this.location == NavigationLocation.Current) {
            return false;
        }
        return tasksTable2.canNavigateTo(taskNode2, this.location);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigateToTaskLocationAction$Companion;", "", "()V", "j", "", "location", "Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigationLocation;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NlsActions.ActionText
        private final String j(NavigationLocation navigationLocation) {
            return switch (WhenMappings.$EnumSwitchMapping$0[navigationLocation.ordinal()]) {
                case 1 -> RiderDebuggerBundle.Companion.message("action.navigate.current.location.text", new Object[0]);
                case 2 -> RiderDebuggerBundle.Companion.message("action.navigate.initial.location.text", new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[NavigationLocation.values().length];
                try {
                    nArray[NavigationLocation.Current.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[NavigationLocation.Initial.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

