/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.table.view;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.StatusText;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.tasksView.TasksView;
import com.jetbrains.rider.debugger.tasksView.shared.TasksViewManager;
import com.jetbrains.rider.debugger.tasksView.shared.graph.ParallelTasksNode;
import com.jetbrains.rider.debugger.tasksView.shared.graph.TaskNode;
import com.jetbrains.rider.debugger.tasksView.table.view.TaskTableModel;
import com.jetbrains.rider.debugger.tasksView.table.view.actions.NavigationLocation;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.CurrentLocationColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.IdColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.InitialLocationColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.ParentColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.StatusColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.TasksViewColumn;
import com.jetbrains.rider.debugger.tasksView.table.view.columns.ThreadColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\"B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002J\u001a\u0010\u001c\u001a\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0014\u0010\u001f\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/table/view/TasksTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TaskNode;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "tasksViewManager", "Lcom/jetbrains/rider/debugger/tasksView/shared/TasksViewManager;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/debugger/tasksView/shared/TasksViewManager;)V", "model", "Lcom/jetbrains/rider/debugger/tasksView/table/view/TaskTableModel;", "canNavigateTo", "", "node", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/ParallelTasksNode;", "navigationLocation", "Lcom/jetbrains/rider/debugger/tasksView/table/view/actions/NavigationLocation;", "clear", "", "text", "", "j", "getData", "", "dataId", "getEmptyText", "Lcom/intellij/util/ui/StatusText;", "getSelectedTask", "navigateTo", "j", "j", "setTasks", "tasks", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nTasksTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksTable.kt\ncom/jetbrains/rider/debugger/tasksView/table/view/TasksTable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n11095#2:112\n11430#2,3:113\n13309#2:120\n13310#2:122\n1549#3:116\n1620#3,3:117\n1#4:121\n*S KotlinDebug\n*F\n+ 1 TasksTable.kt\ncom/jetbrains/rider/debugger/tasksView/table/view/TasksTable\n*L\n55#1:112\n55#1:113,3\n83#1:120\n83#1:122\n55#1:116\n55#1:117,3\n*E\n"})
public final class TasksTable
extends TableView<TaskNode>
implements DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TasksViewManager tasksViewManager;
    @NotNull
    private final TaskTableModel model;
    @NotNull
    private static final DataKey<TasksView> TASKS_TABLE = DataKey.Companion.create("TASKS_TABLE");

    public TasksTable(@NotNull Lifetime lifetime2, @NotNull TasksViewManager tasksViewManager) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)tasksViewManager, (String)"tasksViewManager");
        this.tasksViewManager = tasksViewManager;
        this.model = this.j();
        this.setModel((TableModel)((Object)this.model));
        this.updateColumnSizes();
        this.setAutoResizeMode(2);
        this.selectionModel.setSelectionMode(0);
        this.j();
        this.selectionModel.addListSelectionListener(arg_0 -> TasksTable.j(this, arg_0));
        this.tasksViewManager.getSelectionManager().getSelectedNode().advise(lifetime2, new Function1<ParallelTasksNode<?>, Unit>(){

            public final void invoke(@NotNull ParallelTasksNode<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it instanceof TaskNode) {
                    this.j((TaskNode)it);
                }
            }
        });
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText;
        StatusText statusText2 = super.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"getEmptyText(...)");
        StatusText statusText3 = statusText = statusText2;
        boolean bl = false;
        statusText3.setText("");
        return statusText;
    }

    public final void clear(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.model.setItems(CollectionsKt.emptyList());
        this.getEmptyText().setText(text2);
    }

    @Nullable
    public final TaskNode getSelectedTask() {
        Collection collection;
        int n2;
        int n3;
        int[] nArray = this.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        Object object = nArray;
        boolean bl = false;
        int[] nArray2 = object;
        Collection collection2 = new ArrayList(((int[])object).length);
        boolean bl2 = false;
        int n4 = nArray2.length;
        for (int k = 0; k < n4; ++k) {
            n2 = n3 = nArray2[k];
            collection = collection2;
            boolean bl3 = false;
            collection.add(this.convertRowIndexToModel(n2));
        }
        object = (List)collection2;
        bl = false;
        nArray2 = object;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        bl2 = false;
        for (Object t : nArray2) {
            n3 = ((Number)t).intValue();
            collection = collection2;
            n2 = 0;
            collection.add((TaskNode)this.getListTableModel().getItem(n3));
        }
        return (TaskNode)CollectionsKt.singleOrNull((List)((List)collection2));
    }

    public final void setTasks(@NotNull List<TaskNode> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        this.model.setItems(tasks);
    }

    private final void j(TaskNode taskNode) {
        int n2 = this.getListTableModel().indexOf((Object)taskNode);
        if (n2 == -1) {
            return;
        }
        int n3 = this.convertRowIndexToView(n2);
        this.selectionModel.setSelectionInterval(n3, n3);
    }

    public final void navigateTo(@NotNull ParallelTasksNode<?> node, @NotNull NavigationLocation navigationLocation) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)navigationLocation), (String)"navigationLocation");
        this.tasksViewManager.getNodeToCodeNavigator().navigateTo(node, navigationLocation);
    }

    public final boolean canNavigateTo(@NotNull ParallelTasksNode<?> node, @NotNull NavigationLocation navigationLocation) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)navigationLocation), (String)"navigationLocation");
        return this.tasksViewManager.getNodeToCodeNavigator().canNavigateTo(node, navigationLocation);
    }

    private final void j() {
        TasksViewColumn<?>[] tasksViewColumnArray;
        TasksViewColumn<?>[] tasksViewColumnArray2 = tasksViewColumnArray = new DefaultActionGroup("", false);
        int n2 = 0;
        tasksViewColumnArray2.getTemplatePresentation().setHideGroupIfEmpty(true);
        TasksViewColumn<?>[] tasksViewColumnArray3 = tasksViewColumnArray;
        tasksViewColumnArray = this.model.getColumnInfos();
        boolean bl = false;
        int n3 = tasksViewColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            AnAction anAction;
            TasksViewColumn<?> tasksViewColumn;
            TasksViewColumn<?> tasksViewColumn2 = tasksViewColumn = tasksViewColumnArray[n2];
            boolean bl2 = false;
            if (tasksViewColumn2.getRowClickedAction() == null) continue;
            boolean bl3 = false;
            tasksViewColumnArray3.add(anAction);
        }
        PopupHandler.installRowSelectionTablePopup((JTable)((JTable)((Object)this)), (ActionGroup)((ActionGroup)tasksViewColumnArray3), (String)"TasksViewPopup");
    }

    private final TaskTableModel j() {
        TasksViewColumn[] tasksViewColumnArray = new TasksViewColumn[]{new IdColumn(), new StatusColumn(), new ThreadColumn(), new ParentColumn(), new CurrentLocationColumn(this.tasksViewManager.getNodePresenter()), new InitialLocationColumn(this.tasksViewManager.getNodePresenter())};
        return new TaskTableModel(tasksViewColumnArray);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (TASKS_TABLE.is(dataId)) {
            return this;
        }
        return null;
    }

    private static final void j(TasksTable tasksTable, ListSelectionEvent listSelectionEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)tasksTable), (String)"this$0");
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        TaskNode taskNode = tasksTable.getSelectedTask();
        if (taskNode == null) {
            return;
        }
        TaskNode taskNode2 = taskNode;
        tasksTable.tasksViewManager.getSelectionManager().selectNode(taskNode2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/table/view/TasksTable$Companion;", "", "()V", "TASKS_TABLE", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/rider/debugger/tasksView/TasksView;", "getTASKS_TABLE", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TasksView> getTASKS_TABLE() {
            return TASKS_TABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

