/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution;

import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.tasksView.shared.MethodSignature;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.ExecutionInfo;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.ExecutionInfoVisitor;
import com.jetbrains.rider.model.debuggerWorker.ModuleId;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J#\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/FrameExecutionInfo;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfo;", "stackFrame", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "isAsync", "", "(Lcom/jetbrains/rider/debugger/DotNetStackFrame;Z)V", "()Z", "getStackFrame", "()Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "getMethodSignature", "Lcom/jetbrains/rider/debugger/tasksView/shared/MethodSignature;", "visit", "T", "visitor", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfoVisitor;", "(Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfoVisitor;)Ljava/lang/Object;", "intellij.rider"})
public final class FrameExecutionInfo
implements ExecutionInfo {
    @NotNull
    private final DotNetStackFrame stackFrame;
    private final boolean isAsync;

    public FrameExecutionInfo(@NotNull DotNetStackFrame stackFrame, boolean isAsync) {
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        this.stackFrame = stackFrame;
        this.isAsync = isAsync;
    }

    @NotNull
    public final DotNetStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public final boolean isAsync() {
        return this.isAsync;
    }

    @Override
    @NotNull
    public MethodSignature getMethodSignature() {
        StackFrameProxy stackFrameProxy = this.stackFrame.getFrameProxy();
        boolean bl = false;
        ModuleId moduleId = stackFrameProxy.getModuleId();
        return new MethodSignature(moduleId != null ? moduleId.getMvid() : null, stackFrameProxy.getMethodToken(), stackFrameProxy.getTypeName() + "." + stackFrameProxy.getMethodName());
    }

    @Override
    @Nullable
    public <T> T visit(@NotNull ExecutionInfoVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visit(this);
    }
}

