/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.shared.graph;

import com.jetbrains.rider.debugger.tasksView.shared.graph.ParallelTasksNode;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.execution.ExecutionInfo;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.nodes.TaskFrameNode;
import com.jetbrains.rider.model.debuggerWorker.RdTaskNode;
import com.jetbrains.rider.model.debuggerWorker.RdTasksViewNode;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TaskNode;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/ParallelTasksNode;", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/nodes/TaskFrameNode;", "rdNode", "Lcom/jetbrains/rider/model/debuggerWorker/RdTaskNode;", "(Lcom/jetbrains/rider/model/debuggerWorker/RdTaskNode;)V", "parentTaskId", "", "getParentTaskId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getRdNode", "()Lcom/jetbrains/rider/model/debuggerWorker/RdTaskNode;", "taskId", "getTaskId", "uniqueTaskId", "Ljava/util/UUID;", "getUniqueTaskId", "()Ljava/util/UUID;", "createFrameNode", "executionInfo", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/execution/ExecutionInfo;", "equals", "", "other", "", "hashCode", "intellij.rider"})
public final class TaskNode
extends ParallelTasksNode<TaskFrameNode> {
    @NotNull
    private final RdTaskNode rdNode;
    @NotNull
    private final UUID uniqueTaskId;
    @Nullable
    private final Integer taskId;
    @Nullable
    private final Integer parentTaskId;

    public TaskNode(@NotNull RdTaskNode rdNode) {
        Intrinsics.checkNotNullParameter((Object)rdNode, (String)"rdNode");
        super((RdTasksViewNode)rdNode);
        this.rdNode = rdNode;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uniqueTaskId = uUID;
        this.taskId = this.getRdNode().getTaskId();
        this.parentTaskId = this.getRdNode().getParentTaskId();
    }

    @NotNull
    public RdTaskNode getRdNode() {
        return this.rdNode;
    }

    @NotNull
    public final UUID getUniqueTaskId() {
        return this.uniqueTaskId;
    }

    @Nullable
    public final Integer getTaskId() {
        return this.taskId;
    }

    @Nullable
    public final Integer getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    @NotNull
    public TaskFrameNode createFrameNode(@NotNull ExecutionInfo executionInfo) {
        Intrinsics.checkNotNullParameter((Object)executionInfo, (String)"executionInfo");
        return new TaskFrameNode(this, executionInfo);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.tasksView.shared.graph.TaskNode");
        TaskNode cfr_ignored_0 = (TaskNode)other;
        return Intrinsics.areEqual((Object)this.uniqueTaskId, (Object)((TaskNode)other).uniqueTaskId);
    }

    public int hashCode() {
        return this.uniqueTaskId.hashCode();
    }
}

