/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebugViewSessionListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.tasksView.SubViews;
import com.jetbrains.rider.debugger.tasksView.TasksViewSubView;
import com.jetbrains.rider.debugger.tasksView.shared.TasksViewManager;
import com.jetbrains.rider.debugger.tasksView.states.ResumedState;
import com.jetbrains.rider.debugger.tasksView.states.TasksViewState;
import com.jetbrains.rider.debugger.tasksView.states.UnsupportedState;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0006\u0010\u0016\u001a\u00020\u0014J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000bJ\u0010\u0010%\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000e2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/debugger/tasksView/TasksView;", "Lcom/intellij/xdebugger/impl/frame/XDebugView;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "tasksViewManager", "Lcom/jetbrains/rider/debugger/tasksView/shared/TasksViewManager;", "views", "", "Lcom/jetbrains/rider/debugger/tasksView/TasksViewSubView;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/debugger/tasksView/shared/TasksViewManager;Ljava/util/List;)V", "currentState", "Lcom/jetbrains/rider/debugger/tasksView/states/TasksViewState;", "isActive", "", "subviews", "Lcom/jetbrains/rider/debugger/tasksView/SubViews;", "activate", "", "clear", "deactivate", "dispose", "getCurrentView", "getData", "", "dataId", "", "getMainComponent", "Ljavax/swing/JComponent;", "getViews", "processSessionEvent", "event", "Lcom/intellij/xdebugger/impl/frame/XDebugView$SessionEvent;", "selectView", "subView", "j", "nextState", "Companion", "intellij.rider"})
public final class TasksView
extends XDebugView
implements DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    private boolean isActive;
    @NotNull
    private final SubViews subviews;
    @NotNull
    private TasksViewState currentState;
    @NotNull
    private static final DataKey<TasksView> TASKS_VIEW = DataKey.Companion.create("TASKS_VIEW");

    public TasksView(@NotNull Lifetime lifetime2, @NotNull XDebugSession session, @NotNull TasksViewManager tasksViewManager, @NotNull List<? extends TasksViewSubView> views) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)tasksViewManager, (String)"tasksViewManager");
        Intrinsics.checkNotNullParameter(views, (String)"views");
        this.session = session;
        this.subviews = new SubViews(lifetime2, views);
        this.currentState = new UnsupportedState(this.subviews, this.session, this);
        XDebugViewSessionListener.attach((XDebugView)this, (XDebugSession)this.session);
        Disposer.register((Disposable)LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime2, null, (int)1, null), (Disposable)((Disposable)this));
        DataManager.registerDataProvider((JComponent)this.getMainComponent(), (DataProvider)this);
        this.currentState.enter();
        SourceExKt.adviseOnce((ISource)((ISource)tasksViewManager.isSupported()), (Lifetime)lifetime2, (Function1)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (it) {
                    TasksView.switchState$default(this, new ResumedState(subviews, session, this), null, 2, null);
                }
            }
        }));
    }

    public void dispose() {
    }

    @NotNull
    public final List<TasksViewSubView> getViews() {
        return this.subviews.getAll();
    }

    @NotNull
    public final TasksViewSubView getCurrentView() {
        return this.subviews.getCurrentView();
    }

    @NotNull
    public JComponent getMainComponent() {
        return this.subviews.getMainComponent();
    }

    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        UIUtil.invokeLaterIfNeeded(() -> TasksView.j(this, event));
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public final void activate() {
        this.isActive = true;
        this.currentState.activate();
    }

    public final void deactivate() {
        this.isActive = false;
        this.currentState.deactivate();
    }

    protected void clear() {
    }

    public final void selectView(@NotNull TasksViewSubView subView) {
        Intrinsics.checkNotNullParameter((Object)subView, (String)"subView");
        this.currentState.selectView(subView);
    }

    private final void j(XDebugView.SessionEvent sessionEvent) {
        this.j(this.currentState.getNextState(sessionEvent), sessionEvent);
    }

    private final void j(TasksViewState tasksViewState, XDebugView.SessionEvent sessionEvent) {
        if (Intrinsics.areEqual((Object)this.currentState, (Object)tasksViewState)) {
            if (sessionEvent == null) {
                return;
            }
            this.currentState.processSessionEvent(sessionEvent);
        } else {
            this.currentState.exit();
            tasksViewState.enter();
            this.currentState = tasksViewState;
        }
    }

    static /* synthetic */ void switchState$default(TasksView tasksView, TasksViewState tasksViewState, XDebugView.SessionEvent sessionEvent, int n, Object object) {
        if ((n & 2) != 0) {
            sessionEvent = null;
        }
        tasksView.j(tasksViewState, sessionEvent);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (TASKS_VIEW.is(dataId)) {
            return this;
        }
        return null;
    }

    private static final void j(TasksView tasksView, XDebugView.SessionEvent sessionEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)tasksView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)sessionEvent, (String)"$event");
        tasksView.j(sessionEvent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/TasksView$Companion;", "", "()V", "TASKS_VIEW", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/jetbrains/rider/debugger/tasksView/TasksView;", "getTASKS_VIEW", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TasksView> getTASKS_VIEW() {
            return TASKS_VIEW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

