/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetDebugSessionInfo;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsCollector;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerSteppingTrackerKt;
import com.jetbrains.rider.debugger.statistics.SteppingType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/debugger/statistics/RiderDebuggerSteppingTracker;", "", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "(Lcom/jetbrains/rider/debugger/DotNetDebugProcess;)V", "currentSteppingRequestNanoTimeMillis", "", "Ljava/lang/Long;", "currentSteppingType", "Lcom/jetbrains/rider/debugger/statistics/SteppingType;", "trackerLock", "onNextPause", "", "registerSteppingStart", "steppingType", "intellij.rider"})
public final class RiderDebuggerSteppingTracker {
    @NotNull
    private final DotNetDebugProcess debugProcess;
    @NotNull
    private final Object trackerLock;
    @Nullable
    private Long currentSteppingRequestNanoTimeMillis;
    @Nullable
    private SteppingType currentSteppingType;

    public RiderDebuggerSteppingTracker(@NotNull DotNetDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.trackerLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSteppingStart(@NotNull SteppingType steppingType) {
        Intrinsics.checkNotNullParameter((Object)((Object)steppingType), (String)"steppingType");
        Object object = this.trackerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.currentSteppingRequestNanoTimeMillis != null) {
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().warn("There's another active stepping request, the debugger state is invalid");
            }
            this.currentSteppingType = steppingType;
            this.currentSteppingRequestNanoTimeMillis = System.nanoTime();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNextPause() {
        Object object = this.trackerLock;
        synchronized (object) {
            Object object2;
            boolean bl;
            Object object3;
            boolean bl2 = false;
            long l = System.nanoTime();
            Long l2 = this.currentSteppingRequestNanoTimeMillis;
            if (l2 == null) {
                return;
            }
            long l3 = l2;
            this.currentSteppingRequestNanoTimeMillis = null;
            SteppingType steppingType = this.currentSteppingType;
            if (steppingType == null) {
                SteppingType steppingType2 = SteppingType.Over;
                object3 = steppingType2;
                bl = false;
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().error("Stepping type is not expected to be null");
                steppingType = steppingType2;
            }
            SteppingType steppingType3 = steppingType;
            this.currentSteppingType = null;
            long l4 = (l - l3) / 1000000L;
            object3 = (DotNetDebugSessionInfo)this.debugProcess.getSessionInfo().getValueOrNull();
            if (object3 == null) {
                RiderDebuggerSteppingTrackerKt.access$getLogger$p().warn("Session info is unavailable");
            }
            bl = (object2 = object3) != null && (object2 = ((DotNetDebugSessionInfo)object2).getInfo()) != null ? object2.isMono() : false;
            RiderDebuggerStatisticsCollector.INSTANCE.onSteppingCompleted(this.debugProcess.getProject(), l4, steppingType3, bl);
            Unit unit = Unit.INSTANCE;
        }
    }
}

