/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.editAndContinue.HotReloadApplyResultKind;
import com.jetbrains.rider.debugger.statistics.HotReloadResultKind;
import com.jetbrains.rider.debugger.statistics.HotReloadUsageKind;
import com.jetbrains.rider.debugger.statistics.OSType;
import com.jetbrains.rider.debugger.statistics.RiderHotReloadStatisticsCollector;
import com.jetbrains.rider.debugger.statistics.RuntimeType;
import com.jetbrains.rider.debugger.statistics.StatisticsEvaluationResultKind;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.OSTypeModel;
import com.jetbrains.rider.model.debuggerWorker.ValueResultKind;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\u001a\f\u0010\u0006\u001a\u00020\t*\u00020\nH\u0000\u001a\u001a\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"getRuntime", "Lcom/jetbrains/rider/debugger/statistics/RuntimeType;", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerSessionInfo;", "toStatisticsKind", "Lcom/jetbrains/rider/debugger/statistics/HotReloadResultKind;", "Lcom/jetbrains/rider/debugger/editAndContinue/HotReloadApplyResultKind;", "toStatisticsModel", "Lcom/jetbrains/rider/debugger/statistics/OSType;", "Lcom/jetbrains/rider/model/debuggerWorker/OSTypeModel;", "Lcom/jetbrains/rider/debugger/statistics/StatisticsEvaluationResultKind;", "Lcom/jetbrains/rider/model/debuggerWorker/ValueResultKind;", "withStatistics", "usageKind", "Lcom/jetbrains/rider/debugger/statistics/HotReloadUsageKind;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
public final class RiderDebuggerStatisticsUtilKt {
    @NotNull
    public static final HotReloadApplyResultKind withStatistics(@NotNull HotReloadApplyResultKind $this$withStatistics, @NotNull HotReloadUsageKind usageKind, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withStatistics), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)usageKind), (String)"usageKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if ($this$withStatistics == HotReloadApplyResultKind.NoChanges) {
            return $this$withStatistics;
        }
        RiderHotReloadStatisticsCollector.INSTANCE.applyChangesAttempt($this$withStatistics, usageKind, project);
        return $this$withStatistics;
    }

    @NotNull
    public static final StatisticsEvaluationResultKind toStatisticsModel(@NotNull ValueResultKind $this$toStatisticsModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toStatisticsModel, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toStatisticsModel.ordinal()]) {
            case 1 -> StatisticsEvaluationResultKind.Success;
            case 2 -> StatisticsEvaluationResultKind.ExceptionIsThrown;
            case 3 -> StatisticsEvaluationResultKind.Error;
            case 4 -> StatisticsEvaluationResultKind.NotSupported;
            case 5 -> StatisticsEvaluationResultKind.TargetInvokeDisabled;
            case 6 -> StatisticsEvaluationResultKind.CrossThreadDependencyRejected;
            case 7 -> StatisticsEvaluationResultKind.MethodDisabledToInvoke;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final OSType toStatisticsModel(@NotNull OSTypeModel $this$toStatisticsModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toStatisticsModel, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toStatisticsModel.ordinal()]) {
            case 1 -> OSType.Linux;
            case 2 -> OSType.Mac;
            case 3 -> OSType.Win;
            case 4 -> OSType.FreeBSD;
            case 5 -> OSType.NotAvailable;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final RuntimeType getRuntime(@NotNull DebuggerSessionInfo $this$getRuntime) {
        Intrinsics.checkNotNullParameter((Object)$this$getRuntime, (String)"<this>");
        return $this$getRuntime.isIl2Cpp() ? RuntimeType.L2CPP : ($this$getRuntime.isMono() ? RuntimeType.Mono : RuntimeType.Dotnet);
    }

    @NotNull
    public static final HotReloadResultKind toStatisticsKind(@NotNull HotReloadApplyResultKind $this$toStatisticsKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toStatisticsKind), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toStatisticsKind.ordinal()]) {
            case 1 -> HotReloadResultKind.Applied;
            case 2 -> HotReloadResultKind.BuildFailed;
            case 3 -> HotReloadResultKind.Failed;
            case 4 -> HotReloadResultKind.Canceled;
            case 5 -> throw new IllegalStateException("'No changes' event should not be collected");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ValueResultKind.values().length];
            try {
                nArray[ValueResultKind.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.ExceptionIsThrown.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.NotSupported.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.TargetInvokeDisabled.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.CrossThreadDependencyRejected.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueResultKind.MethodDisabledToInvoke.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OSTypeModel.values().length];
            try {
                nArray[OSTypeModel.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSTypeModel.MacOsX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSTypeModel.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSTypeModel.FreeBSD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSTypeModel.NotAvailable.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[HotReloadApplyResultKind.values().length];
            try {
                nArray[HotReloadApplyResultKind.Applied.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HotReloadApplyResultKind.BuildFailed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HotReloadApplyResultKind.Failed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HotReloadApplyResultKind.Canceled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HotReloadApplyResultKind.NoChanges.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

