/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Function;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.TableModelEditor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.settings.BaseOptionsPageConfigurable;
import com.jetbrains.rider.debugger.settings.SymbolServerConfigurable;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.SymbolServersPage;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.LoadableConfigurable;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.simple.SimpleOptionsPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020 H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\b\u0010*\u001a\u00020\u0015H\u0016J\b\u0010+\u001a\u00020\rH\u0016J\u0012\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0-*\u00020\u0015H\u0002J\u0012\u0010.\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u001e0-H\u0002R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable;", "Lcom/jetbrains/rider/debugger/settings/BaseOptionsPageConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/jetbrains/rider/settings/IRiderViewModelConfigurable;", "Lcom/jetbrains/rider/settings/LoadableConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "()V", "COLUMNS", "", "Lcom/intellij/util/ui/ColumnInfo;", "[Lcom/intellij/util/ui/ColumnInfo;", "isLoaded", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "myIsLoaded", "Lcom/jetbrains/rd/util/reactive/Property;", "myLoadingDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "pageId", "", "reSharperPagesId", "", "getReSharperPagesId", "()Ljava/lang/Iterable;", "serverList", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "symbolServerEditor", "Lcom/intellij/util/ui/table/TableModelEditor;", "Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable$MutableSymbolServerEntry;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "j", "Lcom/intellij/util/ui/table/TableModelEditor$DialogItemEditor;", "rootPanel", "Ljavax/swing/JPanel;", "disposeUIResources", "getDisplayName", "getHelpTopic", "getId", "isModified", "j", "", "j", "Companion", "MutableSymbolServerEntry", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSymbolServerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolServerConfigurable.kt\ncom/jetbrains/rider/debugger/settings/SymbolServerConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,326:1\n766#2:327\n857#2,2:328\n1549#2:330\n1620#2,3:331\n1549#2:334\n1620#2,3:335\n13#3:338\n13#4:339\n*S KotlinDebug\n*F\n+ 1 SymbolServerConfigurable.kt\ncom/jetbrains/rider/debugger/settings/SymbolServerConfigurable\n*L\n295#1:327\n295#1:328,2\n296#1:330\n296#1:331,3\n304#1:334\n304#1:335,3\n37#1:338\n37#1:339\n*E\n"})
public final class SymbolServerConfigurable
extends BaseOptionsPageConfigurable
implements Configurable,
IRiderViewModelConfigurable,
LoadableConfigurable,
SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnInfo<?, ?>[] COLUMNS;
    @NotNull
    private final String pageId;
    @Nullable
    private TableModelEditor<MutableSymbolServerEntry> symbolServerEditor;
    @Nullable
    private IOptProperty<String> serverList;
    @NotNull
    private final Property<Boolean> myIsLoaded;
    @NotNull
    private final Disposable myLoadingDisposable;
    @NotNull
    private static final Logger LOG;

    public SymbolServerConfigurable() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new TableModelEditor.EditableColumnInfo<MutableSymbolServerEntry, Boolean>(){

            @NotNull
            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            @NotNull
            public Boolean valueOf(@NotNull MutableSymbolServerEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getEnabled();
            }

            public void setValue(@NotNull MutableSymbolServerEntry item, boolean value) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                item.setEnabled(value);
            }
        }, new TableModelEditor.EditableColumnInfo<MutableSymbolServerEntry, String>(){

            @NotNull
            public String valueOf(@NotNull MutableSymbolServerEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getUrl();
            }

            public boolean isCellEditable(@Nullable MutableSymbolServerEntry item) {
                return false;
            }

            public void setValue(@NotNull MutableSymbolServerEntry item, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }
        }};
        this.COLUMNS = columnInfoArray;
        this.pageId = "SymbolServersOptionPage";
        this.myIsLoaded = new Property((Object)false);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.myLoadingDisposable = disposable;
    }

    @NotNull
    public String getId() {
        return "SymbolServersPageId";
    }

    @NotNull
    public String getHelpTopic() {
        return "Settings_Debugger_Symbols";
    }

    @NotNull
    public Iterable<String> getReSharperPagesId() {
        return CollectionsKt.listOf((Object)this.pageId);
    }

    public void disposeUIResources() {
        if (!Disposer.isDisposed((Disposable)this.myLoadingDisposable)) {
            Disposer.dispose((Disposable)this.myLoadingDisposable);
        }
    }

    @NotNull
    public IPropertyView<Boolean> isLoaded() {
        return (IPropertyView)this.myIsLoaded;
    }

    public boolean isModified() {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.configurable.name.external.symbols", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        BorderLayoutPanel borderLayoutPanel;
        block0: {
            SettingsViewModelHost settingsViewModelHost;
            borderLayoutPanel = new BorderLayoutPanel();
            JBLoadingPanel jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myLoadingDisposable, 0, 4, null);
            borderLayoutPanel.add((Component)jBLoadingPanel, (Object)"Center");
            jBLoadingPanel.startLoading();
            SettingsViewModelHost settingsViewModelHost2 = settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost2 == null) break block0;
            settingsViewModelHost2.requestPage(this.pageId, (Function1)new Function1<OptionsPageContentBase, Unit>(jBLoadingPanel, this, borderLayoutPanel, settingsViewModelHost){
                final /* synthetic */ JBLoadingPanel $myLoadingPanel;
                final /* synthetic */ SymbolServerConfigurable this$0;
                final /* synthetic */ BorderLayoutPanel $rootPanel;
                final /* synthetic */ SettingsViewModelHost $host;
                {
                    this.$myLoadingPanel = $myLoadingPanel;
                    this.this$0 = $receiver;
                    this.$rootPanel = $rootPanel;
                    this.$host = $host;
                    super(1);
                }

                public final void invoke(@NotNull OptionsPageContentBase content2) {
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    this.$myLoadingPanel.stopLoading();
                    Disposer.dispose((Disposable)SymbolServerConfigurable.access$getMyLoadingDisposable$p(this.this$0));
                    if (content2 instanceof SymbolServersPage) {
                        Object object;
                        JComponent jComponent;
                        JComponent jComponent2;
                        JCheckBox jCheckBox;
                        JCheckBox jCheckBox2;
                        SymbolServerConfigurable.access$getMyIsLoaded$p(this.this$0).setValue((Object)true);
                        this.$rootPanel.removeAll();
                        JBPanel jBPanel = new JBPanel();
                        jBPanel.setLayout((LayoutManager)new BoxLayout((Container)jBPanel, 1));
                        JCheckBox jCheckBox3 = jCheckBox2 = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.use.sources.from.symbol.files.when.available", new Object[0]));
                        boolean bl = false;
                        jCheckBox3.setToolTipText(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.tooltip.text.use.symbol.files.to.get.compiled.code.source", new Object[0]));
                        JCheckBox jCheckBox4 = jCheckBox2;
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox4, 0, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox4);
                        JCheckBox jCheckBox5 = jCheckBox3 = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.allow.downloading.symbols.from.remote.locations", new Object[0]));
                        boolean bl2 = false;
                        jCheckBox5.setToolTipText(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.tooltip.text.download.symbol.files.from.symbol.server.s", new Object[0]));
                        jCheckBox2 = jCheckBox3;
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox2, 1, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox2);
                        jCheckBox3 = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.enable.private.source.link.support", new Object[0]));
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox3, 1, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox3);
                        JCheckBox jCheckBox6 = jCheckBox = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.decompile.methods", new Object[0]));
                        boolean bl3 = false;
                        jCheckBox6.setToolTipText(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.tooltip.text.decompile.method.bodies", new Object[0]));
                        jCheckBox5 = jCheckBox;
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox5, 0, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox5);
                        JCheckBox jCheckBox7 = jCheckBox6 = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.decompile.protected.assemblies", new Object[0]));
                        boolean bl4 = false;
                        jCheckBox7.setToolTipText(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.tooltip.text.decompile.protected.assemblies", new Object[0]));
                        jCheckBox = jCheckBox6;
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox, 0, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox);
                        JCheckBox jCheckBox8 = jCheckBox7 = new JCheckBox(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.checkbox.show.non.public.compiled.items", new Object[0]));
                        boolean bl5 = false;
                        jCheckBox8.setToolTipText(RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.tooltip.text.show.non.public.compiled.items.in.go.to", new Object[0]));
                        jCheckBox6 = jCheckBox7;
                        BaseOptionsPageConfigurable.setBasicProperties$default(this.this$0, jCheckBox6, 0, 0, false, 12, null);
                        jBPanel.add((Component)jCheckBox6);
                        jCheckBox7 = BaseOptionsPageConfigurable.createHeaderSeparator$default(this.this$0, RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.separator.symbol.servers", new Object[0]), 0, false, 6, null);
                        jBPanel.add((Component)jCheckBox7);
                        this.$rootPanel.addToTop((Component)jBPanel);
                        jCheckBox8 = SymbolServerConfigurable.access$createItemEditor(this.this$0, (JPanel)this.$rootPanel);
                        SymbolServerConfigurable.access$setSymbolServerEditor$p(this.this$0, new TableModelEditor(SymbolServerConfigurable.access$getCOLUMNS$p(this.this$0), (CollectionItemEditor)jCheckBox8, RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.empty.text.no.symbol.servers.configured", new Object[0])));
                        TableModelEditor tableModelEditor = SymbolServerConfigurable.access$getSymbolServerEditor$p(this.this$0);
                        JComponent jComponent3 = jComponent2 = tableModelEditor != null ? tableModelEditor.createComponent() : null;
                        if (jComponent3 != null) {
                            jComponent = jComponent3;
                            BorderLayoutPanel borderLayoutPanel = this.$rootPanel;
                            object = jComponent;
                            boolean bl6 = false;
                            borderLayoutPanel.addToCenter((Component)object);
                        }
                        TableModelEditor tableModelEditor2 = SymbolServerConfigurable.access$getSymbolServerEditor$p(this.this$0);
                        if (tableModelEditor2 != null) {
                            tableModelEditor2.modelListener((TableModelEditor.DataChangedListener)new TableModelEditor.DataChangedListener<MutableSymbolServerEntry>(this.this$0){
                                final /* synthetic */ SymbolServerConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public void dataChanged(@NotNull ColumnInfo<MutableSymbolServerEntry, ?> columnInfo, int rowIndex) {
                                    block1: {
                                        String string;
                                        List list2;
                                        ListTableModel listTableModel;
                                        Intrinsics.checkNotNullParameter(columnInfo, (String)"columnInfo");
                                        TableModelEditor tableModelEditor = SymbolServerConfigurable.access$getSymbolServerEditor$p(this.this$0);
                                        if (tableModelEditor == null || (listTableModel = tableModelEditor.getModel()) == null || (list2 = listTableModel.getItems()) == null || (string = SymbolServerConfigurable.access$toStringList(this.this$0, list2)) == null) break block1;
                                        String string2 = string;
                                        SymbolServerConfigurable symbolServerConfigurable = this.this$0;
                                        String string3 = string2;
                                        boolean bl = false;
                                        IOptProperty iOptProperty = SymbolServerConfigurable.access$getServerList$p(symbolServerConfigurable);
                                        if (iOptProperty != null) {
                                            iOptProperty.set((Object)string3);
                                        }
                                    }
                                }

                                public void tableChanged(@NotNull TableModelEvent e) {
                                    block1: {
                                        String string;
                                        List list2;
                                        ListTableModel listTableModel;
                                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                        TableModelEditor tableModelEditor = SymbolServerConfigurable.access$getSymbolServerEditor$p(this.this$0);
                                        if (tableModelEditor == null || (listTableModel = tableModelEditor.getModel()) == null || (list2 = listTableModel.getItems()) == null || (string = SymbolServerConfigurable.access$toStringList(this.this$0, list2)) == null) break block1;
                                        String string2 = string;
                                        SymbolServerConfigurable symbolServerConfigurable = this.this$0;
                                        String string3 = string2;
                                        boolean bl = false;
                                        IOptProperty iOptProperty = SymbolServerConfigurable.access$getServerList$p(symbolServerConfigurable);
                                        if (iOptProperty != null) {
                                            iOptProperty.set((Object)string3);
                                        }
                                    }
                                }
                            });
                        }
                        jComponent = this.$host.getCurrentDialogLifetime();
                        String string = (String)((SymbolServersPage)content2).getServerList().getValueOrNull();
                        if (string != null) {
                            object = string;
                            SymbolServerConfigurable symbolServerConfigurable = this.this$0;
                            Object object2 = object;
                            boolean bl7 = false;
                            TableModelEditor tableModelEditor3 = SymbolServerConfigurable.access$getSymbolServerEditor$p(symbolServerConfigurable);
                            if (tableModelEditor3 != null) {
                                tableModelEditor3.reset(SymbolServerConfigurable.access$toEntryList(symbolServerConfigurable, (String)object2));
                            }
                        }
                        ((SymbolServersPage)content2).getUseSymbolFiles().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox4, jCheckBox2, jCheckBox3){
                            final /* synthetic */ JCheckBox $useSymbolFilesView;
                            final /* synthetic */ JCheckBox $downloadSourcesView;
                            final /* synthetic */ JCheckBox $sourceLinkV3View;
                            {
                                this.$useSymbolFilesView = $useSymbolFilesView;
                                this.$downloadSourcesView = $downloadSourcesView;
                                this.$sourceLinkV3View = $sourceLinkV3View;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$useSymbolFilesView.setSelected(it);
                                this.$downloadSourcesView.setEnabled(it);
                                this.$sourceLinkV3View.setEnabled(it);
                            }
                        });
                        jCheckBox4.addItemListener(arg_0 -> createComponent.1.j(content2, jCheckBox2, jCheckBox3, arg_0));
                        ((SymbolServersPage)content2).getDownloadSources().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox2){
                            final /* synthetic */ JCheckBox $downloadSourcesView;
                            {
                                this.$downloadSourcesView = $downloadSourcesView;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$downloadSourcesView.setSelected(it);
                            }
                        });
                        ((SymbolServersPage)content2).getSourceLinkV3Enabed().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox3){
                            final /* synthetic */ JCheckBox $sourceLinkV3View;
                            {
                                this.$sourceLinkV3View = $sourceLinkV3View;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$sourceLinkV3View.setSelected(it);
                            }
                        });
                        jCheckBox2.addItemListener(arg_0 -> createComponent.1.N(content2, arg_0));
                        jCheckBox3.addItemListener(arg_0 -> createComponent.1.t(content2, arg_0));
                        ((SymbolServersPage)content2).getDecompileMethodBodies().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox5){
                            final /* synthetic */ JCheckBox $decompileMethodBodiesView;
                            {
                                this.$decompileMethodBodiesView = $decompileMethodBodiesView;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$decompileMethodBodiesView.setSelected(it);
                            }
                        });
                        jCheckBox5.addItemListener(arg_0 -> createComponent.1.w(content2, arg_0));
                        ((SymbolServersPage)content2).getDecompileProtectedAssemblies().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox){
                            final /* synthetic */ JCheckBox $decompileProtectedAssembliesView;
                            {
                                this.$decompileProtectedAssembliesView = $decompileProtectedAssembliesView;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$decompileProtectedAssembliesView.setSelected(it);
                            }
                        });
                        jCheckBox.addItemListener(arg_0 -> createComponent.1.v(content2, arg_0));
                        ((SymbolServersPage)content2).getShowNonPublicCompiledElementsInGoto().advise((Lifetime)jComponent, (Function1)new Function1<Boolean, Unit>(jCheckBox6){
                            final /* synthetic */ JCheckBox $showNonPublicCompiledElementsInGotoView;
                            {
                                this.$showNonPublicCompiledElementsInGotoView = $showNonPublicCompiledElementsInGotoView;
                                super(1);
                            }

                            public final void invoke(boolean it) {
                                this.$showNonPublicCompiledElementsInGotoView.setSelected(it);
                            }
                        });
                        jCheckBox6.addItemListener(arg_0 -> createComponent.1.j(content2, arg_0));
                        SymbolServerConfigurable.access$setServerList$p(this.this$0, ((SymbolServersPage)content2).getServerList());
                        this.$rootPanel.validate();
                        this.$rootPanel.repaint();
                    } else {
                        SymbolServerConfigurable.access$getLOG$cp().error("Unexpected page content " + content2);
                        SymbolServerConfigurable.access$getMyIsLoaded$p(this.this$0).setValue((Object)false);
                    }
                }

                private static final void j(OptionsPageContentBase optionsPageContentBase, JCheckBox jCheckBox, JCheckBox jCheckBox2, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"$downloadSourcesView");
                    Intrinsics.checkNotNullParameter((Object)jCheckBox2, (String)"$sourceLinkV3View");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getUseSymbolFiles().set((Object)bl);
                    jCheckBox.setEnabled(bl);
                    jCheckBox2.setEnabled(bl);
                }

                private static final void N(OptionsPageContentBase optionsPageContentBase, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getDownloadSources().set((Object)bl);
                }

                private static final void t(OptionsPageContentBase optionsPageContentBase, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getSourceLinkV3Enabed().set((Object)bl);
                }

                private static final void w(OptionsPageContentBase optionsPageContentBase, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getDecompileMethodBodies().set((Object)bl);
                }

                private static final void v(OptionsPageContentBase optionsPageContentBase, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getDecompileProtectedAssemblies().set((Object)bl);
                }

                private static final void j(OptionsPageContentBase optionsPageContentBase, ItemEvent itemEvent) {
                    Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"$content");
                    boolean bl = itemEvent.getStateChange() == 1;
                    ((SymbolServersPage)optionsPageContentBase).getShowNonPublicCompiledElementsInGoto().set((Object)bl);
                }
            });
        }
        return (JComponent)borderLayoutPanel;
    }

    private final TableModelEditor.DialogItemEditor<MutableSymbolServerEntry> j(JPanel jPanel) {
        return (TableModelEditor.DialogItemEditor)new TableModelEditor.DialogItemEditor<MutableSymbolServerEntry>(jPanel, this){
            final /* synthetic */ JPanel $rootPanel;
            final /* synthetic */ SymbolServerConfigurable this$0;
            {
                this.$rootPanel = $rootPanel;
                this.this$0 = $receiver;
            }

            public void edit(@NotNull MutableSymbolServerEntry item, @NotNull Function<? super MutableSymbolServerEntry, ? extends MutableSymbolServerEntry> mutator, boolean isAdd) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
                    String string = Messages.showInputDialog((Component)this.$rootPanel, (String)RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.dialog.message.enter.symbol.server.url", new Object[0]), (String)RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.dialog.title.symbol.server", new Object[0]), null, (String)item.getUrl(), (InputValidator)((InputValidator)new InputValidatorEx(){

                        public boolean checkInput(@NotNull String inputString) {
                            Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                            return this.getErrorText(inputString) == null;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Nullable
                        public String getErrorText(@NotNull String inputString) {
                            Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                            try {
                                String string;
                                String string2;
                                String string3;
                                String string4;
                                Object[] objectArray;
                                Object[] objectArray2 = new URI(inputString).getScheme();
                                if (objectArray2 != null) {
                                    objectArray = objectArray2;
                                    Locale locale = Locale.ENGLISH;
                                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                                    String string5 = objectArray.toLowerCase(locale);
                                    string4 = string5;
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                                } else {
                                    string4 = null;
                                }
                                String string6 = string3 = (string2 = string4);
                                if (string6 == null) {
                                    string = RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.error.text.uri.scheme.not.specified", new Object[0]);
                                    return string;
                                }
                                switch (string6.hashCode()) {
                                    case 3143036: {
                                        if (string3.equals("file")) return null;
                                        break;
                                    }
                                    case 3213448: {
                                        if (string3.equals("http")) return null;
                                        break;
                                    }
                                    case 99617003: {
                                        if (string3.equals("https")) {
                                            return null;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                objectArray = new Object[]{string2};
                                string = RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.error.text.unsupported.uri.scheme", objectArray);
                                return string;
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                return RiderDebuggerBundle.Companion.message("SymbolServerConfigurable.error.text.malformed.uri", new Object[0]);
                            }
                        }

                        public boolean canClose(@NotNull String inputString) {
                            Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                            return this.checkInput(inputString);
                        }
                    }));
                    if (string == null) break block1;
                    ((MutableSymbolServerEntry)mutator.fun((Object)item)).setUrl(string);
                    TableModelEditor tableModelEditor = SymbolServerConfigurable.access$getSymbolServerEditor$p(this.this$0);
                    if (tableModelEditor != null && (tableModelEditor = tableModelEditor.getModel()) != null) {
                        tableModelEditor.fireTableDataChanged();
                    }
                }
            }

            public void applyEdited(@NotNull MutableSymbolServerEntry oldItem, @NotNull MutableSymbolServerEntry newItem) {
                Intrinsics.checkNotNullParameter((Object)oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            @NotNull
            public Class<? extends MutableSymbolServerEntry> getItemClass() {
                return MutableSymbolServerEntry.class;
            }

            @NotNull
            public MutableSymbolServerEntry clone(@NotNull MutableSymbolServerEntry item, boolean forInPlaceEditing) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new MutableSymbolServerEntry(item.getEnabled(), item.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
    }

    public void apply() {
    }

    private final List<MutableSymbolServerEntry> j(String string) {
        String string2;
        Object object;
        Object object2 = new char[]{'|'};
        object2 = StringsKt.split$default((CharSequence)string, (char[])object2, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        char[] cArray = object2;
        Object object3 = new ArrayList();
        boolean bl2 = false;
        Iterator iterator2 = cArray.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            string2 = (String)object;
            boolean bl3 = false;
            boolean bl4 = ((CharSequence)string2).length() > 0;
            if (!bl4) continue;
            object3.add(object);
        }
        object2 = (List)object3;
        MutableSymbolServerEntry.Companion companion = MutableSymbolServerEntry.Companion;
        boolean bl5 = false;
        object3 = object2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        boolean bl6 = false;
        object = object3.iterator();
        while (object.hasNext()) {
            String string3 = string2 = object.next();
            Collection collection2 = collection;
            boolean bl7 = false;
            collection2.add(companion.fromStringEntry(string3));
        }
        return (List)collection;
    }

    private final String j(List<MutableSymbolServerEntry> list2) {
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            MutableSymbolServerEntry mutableSymbolServerEntry = (MutableSymbolServerEntry)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(mutableSymbolServerEntry.toStringEntry());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)collection), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ Disposable access$getMyLoadingDisposable$p(SymbolServerConfigurable $this) {
        return $this.myLoadingDisposable;
    }

    public static final /* synthetic */ Property access$getMyIsLoaded$p(SymbolServerConfigurable $this) {
        return $this.myIsLoaded;
    }

    public static final /* synthetic */ TableModelEditor.DialogItemEditor access$createItemEditor(SymbolServerConfigurable $this, JPanel rootPanel) {
        return $this.j(rootPanel);
    }

    public static final /* synthetic */ void access$setSymbolServerEditor$p(SymbolServerConfigurable $this, TableModelEditor tableModelEditor) {
        $this.symbolServerEditor = tableModelEditor;
    }

    public static final /* synthetic */ ColumnInfo[] access$getCOLUMNS$p(SymbolServerConfigurable $this) {
        return $this.COLUMNS;
    }

    public static final /* synthetic */ TableModelEditor access$getSymbolServerEditor$p(SymbolServerConfigurable $this) {
        return $this.symbolServerEditor;
    }

    public static final /* synthetic */ String access$toStringList(SymbolServerConfigurable $this, List $receiver) {
        return $this.j($receiver);
    }

    public static final /* synthetic */ IOptProperty access$getServerList$p(SymbolServerConfigurable $this) {
        return $this.serverList;
    }

    public static final /* synthetic */ void access$setServerList$p(SymbolServerConfigurable $this, IOptProperty iOptProperty) {
        $this.serverList = iOptProperty;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ List access$toEntryList(SymbolServerConfigurable $this, String $receiver) {
        return $this.j($receiver);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(SimpleOptionsPage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable$MutableSymbolServerEntry;", "", "()V", "enabled", "", "url", "", "(ZLjava/lang/String;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "toStringEntry", "Companion", "intellij.rider"})
    private static final class MutableSymbolServerEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean enabled;
        @NotNull
        private String url;

        public MutableSymbolServerEntry(boolean enabled, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            this.enabled = enabled;
            this.url = url2;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.url = string;
        }

        public MutableSymbolServerEntry() {
            this(true, "");
        }

        @NotNull
        public final String toStringEntry() {
            return (this.enabled ? "1" : "0") + this.url;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final MutableSymbolServerEntry copy(boolean enabled, @NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return new MutableSymbolServerEntry(enabled, url2);
        }

        public static /* synthetic */ MutableSymbolServerEntry copy$default(MutableSymbolServerEntry mutableSymbolServerEntry, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mutableSymbolServerEntry.enabled;
            }
            if ((n & 2) != 0) {
                string = mutableSymbolServerEntry.url;
            }
            return mutableSymbolServerEntry.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "MutableSymbolServerEntry(enabled=" + this.enabled + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int n = Boolean.hashCode(this.enabled);
            n = n * 31 + this.url.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MutableSymbolServerEntry)) {
                return false;
            }
            MutableSymbolServerEntry mutableSymbolServerEntry = (MutableSymbolServerEntry)other;
            if (this.enabled != mutableSymbolServerEntry.enabled) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)mutableSymbolServerEntry.url);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable$MutableSymbolServerEntry$Companion;", "", "()V", "fromStringEntry", "Lcom/jetbrains/rider/debugger/settings/SymbolServerConfigurable$MutableSymbolServerEntry;", "entry", "", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MutableSymbolServerEntry fromStringEntry(@NotNull String entry2) {
                Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
                boolean bl = entry2.charAt(0) == '1';
                String string = entry2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return new MutableSymbolServerEntry(bl, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

