/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.modulesView;

import com.intellij.xdebugger.impl.modulesView.DebuggerModule;
import com.intellij.xdebugger.impl.modulesView.ModuleListener;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import com.jetbrains.rider.model.debuggerWorker.Module;
import com.jetbrains.rider.model.debuggerWorker.ModuleId;
import com.jetbrains.rider.model.debuggerWorker.ModuleSymbolsLoadingResult;
import com.jetbrains.rider.model.debuggerWorker.SymbolsSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001dH\u0016J\u000e\u00109\u001a\u00020:H\u0086@\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u000207H\u0002J\u0010\u0010@\u001a\u0002072\u0006\u00108\u001a\u00020\u001dH\u0016J\u000e\u0010A\u001a\u000207H\u0086@\u00a2\u0006\u0002\u0010;R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u0004\u0018\u00010&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0017R\u0019\u0010/\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006B"}, d2={"Lcom/jetbrains/rider/debugger/modulesView/DotnetDebuggerModule;", "Lcom/intellij/xdebugger/impl/modulesView/DebuggerModule;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "module", "Lcom/jetbrains/rider/model/debuggerWorker/Module;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/debuggerWorker/Module;)V", "_loadedSymbols", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/rider/model/debuggerWorker/SymbolsSource;", "appDomainName", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "Lcom/intellij/openapi/util/NlsSafe;", "getAppDomainName", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "decompilesSourcesAllowed", "", "getDecompilesSourcesAllowed", "()Z", "id", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "isProjectOutputAssembly", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "listeners", "", "Lcom/intellij/xdebugger/impl/modulesView/ModuleListener;", "loadOrder", "", "getLoadOrder", "()I", "loadedSymbols", "getLoadedSymbols", "()Lcom/jetbrains/rd/util/reactive/ViewableList;", "location", "Ljava/nio/file/Path;", "getLocation", "()Ljava/nio/file/Path;", "moduleId", "Lcom/jetbrains/rider/model/debuggerWorker/ModuleId;", "getModuleId", "()Lcom/jetbrains/rider/model/debuggerWorker/ModuleId;", "mvid", "getMvid", "name", "getName", "()Ljava/lang/String;", "version", "Lcom/jetbrains/rider/debugger/modulesView/AssemblyVersion;", "getVersion", "()Lcom/jetbrains/rider/debugger/modulesView/AssemblyVersion;", "addListener", "", "listener", "loadSymbols", "Lcom/jetbrains/rider/model/debuggerWorker/ModuleSymbolsLoadingResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadSymbolsFrom", "path", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "j", "removeListener", "toggleDecompiledSourcesAllowed", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotnetDebuggerModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotnetDebuggerModule.kt\ncom/jetbrains/rider/debugger/modulesView/DotnetDebuggerModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1#2:77\n1855#3,2:78\n*S KotlinDebug\n*F\n+ 1 DotnetDebuggerModule.kt\ncom/jetbrains/rider/debugger/modulesView/DotnetDebuggerModule\n*L\n74#1:78,2\n*E\n"})
public final class DotnetDebuggerModule
implements DebuggerModule {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Module module;
    @NotNull
    private final List<ModuleListener> listeners;
    @NotNull
    private final ViewableList<SymbolsSource> _loadedSymbols;
    @NotNull
    private final String name;
    @Nullable
    private final Path location;
    private final int loadOrder;
    @NotNull
    private final AssemblyVersion version;
    @NotNull
    private final IOptProperty<String> appDomainName;
    @NotNull
    private final ModuleId moduleId;
    @NotNull
    private final UUID mvid;
    private final boolean isProjectOutputAssembly;
    @NotNull
    private final ViewableList<SymbolsSource> loadedSymbols;

    public DotnetDebuggerModule(@NotNull Lifetime lifetime2, @NotNull Module module) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.lifetime = lifetime2;
        this.module = module;
        this.listeners = new ArrayList();
        this._loadedSymbols = new ViewableList(null, 1, null);
        this.name = this.module.getName();
        DotnetDebuggerModule dotnetDebuggerModule = this;
        String string = this.module.getPath();
        if (string != null) {
            String string2 = string;
            DotnetDebuggerModule dotnetDebuggerModule2 = dotnetDebuggerModule;
            boolean bl = false;
            path = Path.of(string2, new String[0]);
            dotnetDebuggerModule = dotnetDebuggerModule2;
        } else {
            path = null;
        }
        dotnetDebuggerModule.location = path;
        this.loadOrder = this.module.getOrder();
        this.version = AssemblyVersion.Companion.parse(this.module.getVersion());
        this.appDomainName = this.module.getAppDomainName();
        this.moduleId = this.module.getModuleId();
        this.mvid = this.moduleId.getMvid();
        this.isProjectOutputAssembly = this.module.isProjectOutputAssembly();
        this.loadedSymbols = this._loadedSymbols;
        this.module.getSymbols().view(this.lifetime, (Function3)new Function3<Lifetime, Integer, SymbolsSource, Unit>(){

            public final void invoke(@NotNull Lifetime symbolsLifetime, int n, final @NotNull SymbolsSource symbols) {
                Intrinsics.checkNotNullParameter((Object)symbolsLifetime, (String)"symbolsLifetime");
                Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
                _loadedSymbols.add((Object)symbols);
                this.j();
                symbolsLifetime.onTermination((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        _loadedSymbols.remove((Object)symbols);
                        this.j();
                    }
                });
            }
        });
        this.module.getAppDomainName().advise(this.lifetime, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.j();
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Path getLocation() {
        return this.location;
    }

    @Override
    public int getLoadOrder() {
        return this.loadOrder;
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.mvid;
    }

    @Override
    public void addListener(@NotNull ModuleListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull ModuleListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @NotNull
    public final AssemblyVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final IOptProperty<String> getAppDomainName() {
        return this.appDomainName;
    }

    @NotNull
    public final ModuleId getModuleId() {
        return this.moduleId;
    }

    @NotNull
    public final UUID getMvid() {
        return this.mvid;
    }

    public final boolean isProjectOutputAssembly() {
        return this.isProjectOutputAssembly;
    }

    @NotNull
    public final ViewableList<SymbolsSource> getLoadedSymbols() {
        return this.loadedSymbols;
    }

    public final boolean getDecompilesSourcesAllowed() {
        return (Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)this.module.getExternalDecompiledSourcesAllowed());
    }

    @Nullable
    public final Object loadSymbols(@NotNull Continuation<? super ModuleSymbolsLoadingResult> $completion) {
        return IRdCall.DefaultImpls.startSuspending$default((IRdCall)this.module.getLoadSymbols(), (Object)Unit.INSTANCE, null, $completion, (int)2, null);
    }

    @Nullable
    public final Object loadSymbolsFrom(@NotNull String path, @NotNull Continuation<? super ModuleSymbolsLoadingResult> $completion) {
        return IRdCall.DefaultImpls.startSuspending$default((IRdCall)this.module.getLoadSymbolsFrom(), (Object)path, null, $completion, (int)2, null);
    }

    @Nullable
    public final Object toggleDecompiledSourcesAllowed(@NotNull Continuation<? super Unit> $completion) {
        return IRdCall.DefaultImpls.startSuspending$default((IRdCall)this.module.getSetDecompiledSourcesAllowed(), (Object)Boxing.boxBoolean(((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)this.module.getExternalDecompiledSourcesAllowed()) == false ? 1 : 0) != 0), null, $completion, (int)2, null);
    }

    private final void j() {
        Iterable iterable = this.listeners;
        boolean bl = false;
        for (Object t : iterable) {
            ModuleListener moduleListener = (ModuleListener)t;
            boolean bl2 = false;
            moduleListener.moduleChanged();
        }
    }
}

