/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.memoryView;

import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.jetbrains.rider.model.debuggerWorker.TypeInformation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\r\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderTypeInfo;", "Lcom/intellij/xdebugger/memory/ui/TypeInfo;", "", "typeInfo", "Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;", "count", "", "totalSize", "(Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;JJ)V", "getCount", "()J", "getTotalSize", "getTypeInfo", "()Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;", "canGetInstanceInfo", "", "compareTo", "", "other", "equals", "", "getInstances", "", "Lcom/intellij/xdebugger/memory/ui/ReferenceInfo;", "limit", "hashCode", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "toString", "intellij.rider"})
public final class RiderTypeInfo
implements TypeInfo,
Comparable<RiderTypeInfo> {
    @NotNull
    private final TypeInformation typeInfo;
    private final long count;
    private final long totalSize;

    public RiderTypeInfo(@NotNull TypeInformation typeInfo, long count, long totalSize) {
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.typeInfo = typeInfo;
        this.count = count;
        this.totalSize = totalSize;
    }

    @NotNull
    public final TypeInformation getTypeInfo() {
        return this.typeInfo;
    }

    public final long getCount() {
        return this.count;
    }

    public final long getTotalSize() {
        return this.totalSize;
    }

    @NotNull
    public String name() {
        return this.typeInfo.getDisplayName();
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        throw new IllegalStateException("Should not use sync version, use RiderAsyncInstancesProvider.getInstancesAsync");
    }

    public boolean canGetInstanceInfo() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        RiderTypeInfo riderTypeInfo = other instanceof RiderTypeInfo ? (RiderTypeInfo)other : null;
        if (riderTypeInfo == null) {
            return false;
        }
        RiderTypeInfo riderTypeInfo2 = riderTypeInfo;
        return Intrinsics.areEqual((Object)riderTypeInfo2.typeInfo.getClrFullName(), (Object)this.typeInfo.getClrFullName());
    }

    public int hashCode() {
        return this.typeInfo.getClrFullName().hashCode();
    }

    @Override
    public int compareTo(@NotNull RiderTypeInfo other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.name().compareTo(other.name());
    }

    @NotNull
    public String toString() {
        return this.name();
    }
}

