/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.memoryView;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.ui.InstancesViewBase;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.memoryView.DotNetMemoryViewValue;
import com.jetbrains.rider.debugger.memoryView.DotNetMemoryViewValueGroup;
import com.jetbrains.rider.debugger.memoryView.RiderAsyncInstancesProvider;
import com.jetbrains.rider.debugger.memoryView.RiderInstancesView;
import com.jetbrains.rider.debugger.memoryView.RiderReferenceInfo;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.GroupProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectEntityBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.ui.components.ComponentFactories;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderInstancesView;", "Lcom/intellij/xdebugger/memory/ui/InstancesViewBase;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "instancesProvider", "Lcom/jetbrains/rider/debugger/memoryView/RiderAsyncInstancesProvider;", "executionContextProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "totalCount", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/debugger/memoryView/RiderAsyncInstancesProvider;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;JLcom/jetbrains/rd/util/lifetime/Lifetime;)V", "hyperlinkLabel", "Lcom/intellij/ui/HyperlinkLabel;", "instancesTree", "Lcom/intellij/xdebugger/memory/ui/InstancesTree;", "numberOfInstancesShown", "statusLabel", "Ljavax/swing/JLabel;", "statusPanel", "Ljavax/swing/JPanel;", "getInstancesTree", "j", "Ljava/lang/Runnable;", "j", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderInstancesView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderInstancesView.kt\ncom/jetbrains/rider/debugger/memoryView/RiderInstancesView\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n13#2:110\n13#3:111\n*S KotlinDebug\n*F\n+ 1 RiderInstancesView.kt\ncom/jetbrains/rider/debugger/memoryView/RiderInstancesView\n*L\n35#1:110\n35#1:111\n*E\n"})
public final class RiderInstancesView
extends InstancesViewBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final RiderAsyncInstancesProvider instancesProvider;
    @NotNull
    private final ExecutionContextProxy executionContextProxy;
    private final long totalCount;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final InstancesTree instancesTree;
    @NotNull
    private final JPanel statusPanel;
    @NotNull
    private final JLabel statusLabel;
    @NotNull
    private final HyperlinkLabel hyperlinkLabel;
    private long numberOfInstancesShown;
    @NotNull
    private static final Logger logger;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final long INSTANCES_BATCH_SIZE = 2000L;

    public RiderInstancesView(@NotNull XDebugSession session, @NotNull RiderAsyncInstancesProvider instancesProvider, @NotNull ExecutionContextProxy executionContextProxy, long totalCount, @NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)instancesProvider, (String)"instancesProvider");
        Intrinsics.checkNotNullParameter((Object)executionContextProxy, (String)"executionContextProxy");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)), session, (InstancesProvider)instancesProvider);
        this.session = session;
        this.instancesProvider = instancesProvider;
        this.executionContextProxy = executionContextProxy;
        this.totalCount = totalCount;
        this.lifetime = lifetime2;
        this.instancesTree = new InstancesTree(this.session.getProject(), this.session.getDebugProcess().getEditorsProvider(), this.getValueMarkers(this.session), this.j());
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.hyperlinkLabel = ComponentFactories.Companion.hyperlinkLabel(RiderDebuggerBundle.Companion.message("RiderInstancesView.label.shown.more", new Object[0]), (Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderInstancesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RiderInstancesView.access$updateInstancesActivity(this.this$0).run();
            }
        });
        this.setLayout((LayoutManager)new MigLayout("ins 0, fill, flowy, gap " + JBUI.scale((int)5), "", "[][min!]"));
        this.add((Component)new JBScrollPane((Component)this.instancesTree), "grow");
        this.statusPanel.setLayout((LayoutManager)new HorizontalLayout(5, 0, 2, null));
        this.statusPanel.add(this.statusLabel);
        this.statusPanel.add((Component)this.hyperlinkLabel);
        this.add(this.statusPanel);
    }

    @NotNull
    protected InstancesTree getInstancesTree() {
        return this.instancesTree;
    }

    private final Runnable j() {
        return () -> RiderInstancesView.j(this);
    }

    private final void j() {
        Object[] objectArray = new Object[]{this.numberOfInstancesShown, this.totalCount};
        this.statusLabel.setText(RiderDebuggerBundle.Companion.message("RiderInstancesView.label.shown.0.1", objectArray));
        this.hyperlinkLabel.setVisible(this.numberOfInstancesShown < this.totalCount);
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void N(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    private static final void j(RiderInstancesView riderInstancesView) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderInstancesView), (String)"this$0");
        long l = Math.min(2000L, riderInstancesView.totalCount - riderInstancesView.numberOfInstancesShown);
        if (!RLifetimeKt.isAlive((Lifetime)riderInstancesView.lifetime)) {
            return;
        }
        riderInstancesView.instancesProvider.getInstancesAsync(riderInstancesView.numberOfInstancesShown, l).onSuccess(arg_0 -> RiderInstancesView.j((Function1)new Function1<List<RiderReferenceInfo>, Unit>(riderInstancesView, l){
            final /* synthetic */ RiderInstancesView this$0;
            final /* synthetic */ long $countToFetch;
            {
                this.this$0 = $receiver;
                this.$countToFetch = $countToFetch;
                super(1);
            }

            public final void invoke(@NotNull List<RiderReferenceInfo> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                Object object = it;
                RiderInstancesView riderInstancesView = this.this$0;
                boolean bl = false;
                for (T t : object) {
                    RiderReferenceInfo riderReferenceInfo = (RiderReferenceInfo)t;
                    boolean bl2 = false;
                    ObjectEntityBase objectEntityBase = riderReferenceInfo.getObjectEntity();
                    ObjectEntityBase objectEntityBase2 = objectEntityBase;
                    if (objectEntityBase2 instanceof GroupProxy) {
                        DotNetMemoryViewValueGroup dotNetMemoryViewValueGroup = new DotNetMemoryViewValueGroup((GroupProxy)objectEntityBase, RiderInstancesView.access$getExecutionContextProxy$p(riderInstancesView), RiderInstancesView.access$getLifetime$p(riderInstancesView), RiderInstancesView.access$getSession$p(riderInstancesView));
                        if (((GroupProxy)objectEntityBase).isTop()) {
                            xValueChildrenList.addTopGroup((XValueGroup)dotNetMemoryViewValueGroup);
                            continue;
                        }
                        xValueChildrenList.addBottomGroup((XValueGroup)dotNetMemoryViewValueGroup);
                        continue;
                    }
                    if (objectEntityBase2 instanceof ObjectProxy) {
                        xValueChildrenList.add((XNamedValue)new DotNetMemoryViewValue((ObjectProxy)objectEntityBase, RiderInstancesView.access$getExecutionContextProxy$p(riderInstancesView), RiderInstancesView.access$getLifetime$p(riderInstancesView), RiderInstancesView.access$getSession$p(riderInstancesView), null));
                        continue;
                    }
                    throw new IllegalStateException("Unsupported value entity");
                }
                object = this.this$0;
                RiderInstancesView.access$setNumberOfInstancesShown$p((RiderInstancesView)((Object)object), RiderInstancesView.access$getNumberOfInstancesShown$p((RiderInstancesView)((Object)object)) + this.$countToFetch);
                RiderInstancesView.access$updateStatusLabels(this.this$0);
                RiderInstancesView.access$getInstancesTree$p(this.this$0).addChildren(xValueChildrenList, RiderInstancesView.access$getNumberOfInstancesShown$p(this.this$0) >= RiderInstancesView.access$getTotalCount$p(this.this$0));
            }
        }, arg_0)).onError(arg_0 -> RiderInstancesView.N(updateInstancesActivity.1.2.INSTANCE, arg_0));
    }

    public static final /* synthetic */ void access$setNumberOfInstancesShown$p(RiderInstancesView $this, long l) {
        $this.numberOfInstancesShown = l;
    }

    public static final /* synthetic */ long access$getNumberOfInstancesShown$p(RiderInstancesView $this) {
        return $this.numberOfInstancesShown;
    }

    public static final /* synthetic */ void access$updateStatusLabels(RiderInstancesView $this) {
        $this.j();
    }

    public static final /* synthetic */ InstancesTree access$getInstancesTree$p(RiderInstancesView $this) {
        return $this.instancesTree;
    }

    public static final /* synthetic */ long access$getTotalCount$p(RiderInstancesView $this) {
        return $this.totalCount;
    }

    public static final /* synthetic */ ExecutionContextProxy access$getExecutionContextProxy$p(RiderInstancesView $this) {
        return $this.executionContextProxy;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(RiderInstancesView $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ XDebugSession access$getSession$p(RiderInstancesView $this) {
        return $this.session;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Runnable access$updateInstancesActivity(RiderInstancesView $this) {
        return $this.j();
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RiderInstancesView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderInstancesView$Companion;", "", "()V", "BORDER_LAYOUT_DEFAULT_GAP", "", "INSTANCES_BATCH_SIZE", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

