/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.memoryView;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ValuePropertiesModelBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetValueUtilsKt;
import com.jetbrains.rider.debugger.IDotNetValue;
import com.jetbrains.rider.debugger.memoryView.DotNetMemoryViewValueGroup;
import com.jetbrains.rider.model.ExtraInfo;
import com.jetbrains.rider.model.debuggerWorker.ComputeObjectPropertiesArg;
import com.jetbrains.rider.model.debuggerWorker.DataBreakpointInitializationStatusBase;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.GroupProxy;
import com.jetbrains.rider.model.debuggerWorker.NameAlias;
import com.jetbrains.rider.model.debuggerWorker.ObjectEntityBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesBase;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+J\u000e\u0010-\u001a\u00020.H\u0096@\u00a2\u0006\u0002\u0010+J \u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 2\u0006\u00100\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/DotNetMemoryViewValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lcom/jetbrains/rider/debugger/IDotNetValue;", "objectProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "executionContextProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "tag", "", "(Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;Ljava/lang/String;)V", "lastComputedProperties", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesBase;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "objectProperties", "getObjectProperties", "()Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesBase;", "getObjectProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "getTag", "()Ljava/lang/String;", "canNavigateToTypeSource", "", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeTypeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "createObjectId", "label", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeDataBreakpoint", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeObjectId", "setDataBreakpoint", "Lcom/jetbrains/rider/model/debuggerWorker/DataBreakpointInitializationStatusBase;", "updateProperties", "newObjectProperties", "intellij.rider"})
public final class DotNetMemoryViewValue
extends XNamedValue
implements IDotNetValue {
    @NotNull
    private final ObjectProxy objectProxy;
    @NotNull
    private final ExecutionContextProxy executionContextProxy;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final XDebugSession session;
    @Nullable
    private final String tag;
    @Nullable
    private ObjectPropertiesBase lastComputedProperties;

    public DotNetMemoryViewValue(@NotNull ObjectProxy objectProxy, @NotNull ExecutionContextProxy executionContextProxy, @NotNull Lifetime lifetime2, @NotNull XDebugSession session, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)objectProxy, (String)"objectProxy");
        Intrinsics.checkNotNullParameter((Object)executionContextProxy, (String)"executionContextProxy");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(objectProxy.getName());
        this.objectProxy = objectProxy;
        this.executionContextProxy = executionContextProxy;
        this.lifetime = lifetime2;
        this.session = session;
        this.tag = tag;
    }

    @Override
    @NotNull
    public ObjectProxy getObjectProxy() {
        return this.objectProxy;
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public Object createObjectId(@NotNull String label2, @NotNull Continuation<? super String> $completion) {
        throw new NotImplementedError("Creation of object id for memory view items is not supported");
    }

    @Nullable
    public Object removeObjectId(@NotNull Continuation<?> $completion) {
        throw new NotImplementedError("Creation of object id for memory view items is not supported");
    }

    @Override
    @Nullable
    public Object setDataBreakpoint(@NotNull Continuation<? super DataBreakpointInitializationStatusBase> $completion) {
        throw new NotImplementedError("Creation of data breakpoint is not supported yet");
    }

    @Nullable
    public Object removeDataBreakpoint(@NotNull Continuation<?> $completion) {
        throw new NotImplementedError("Creation of data breakpoint is not supported yet");
    }

    @Override
    @Nullable
    public ObjectPropertiesBase getObjectProperties() {
        return this.lastComputedProperties;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        ExtraInfo extraInfo = DotNetValueUtilsKt.tryGetExtraInfo(node);
        List<NameAlias> list2 = DotNetValueUtilsKt.getNameAliases(this.session);
        this.getObjectProxy().getComputeObjectProperties().start(this.getLifetime(), (Object)new ComputeObjectPropertiesArg(null, null, null, null, list2, extraInfo, null, null, 128, null)).getResult().advise(this.getLifetime(), (Function1)new Function1<RdTaskResult<? extends ValuePropertiesModelBase>, Unit>(this, node, place){
            final /* synthetic */ DotNetMemoryViewValue this$0;
            final /* synthetic */ XValueNode $node;
            final /* synthetic */ XValuePlace $place;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                this.$place = $place;
                super(1);
            }

            public final void invoke(@NotNull RdTaskResult<? extends ValuePropertiesModelBase> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                RdTaskResult<? extends ValuePropertiesModelBase> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    Object object = ((RdTaskResult.Success)it).getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesBase");
                    ObjectPropertiesBase objectPropertiesBase = (ObjectPropertiesBase)object;
                    this.this$0.updateProperties(this.$node, objectPropertiesBase, this.$place);
                    IDotNetValue iDotNetValue = this.this$0;
                    ExecutionContextProxy executionContextProxy = DotNetMemoryViewValue.access$getExecutionContextProxy$p(this.this$0);
                    XDebugSession xDebugSession = DotNetMemoryViewValue.access$getSession$p(this.this$0);
                    Project project = DotNetMemoryViewValue.access$getSession$p(this.this$0).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    DotNetValueUtilsKt.updateFullValueEvaluators(iDotNetValue, objectPropertiesBase, this.$node, this.$place, executionContextProxy, xDebugSession, project);
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    DotNetValueUtilsKt.setError(this.$node, ((RdTaskResult.Fault)it).getError().getReasonMessage());
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    DotNetValueUtilsKt.setError(this.$node, "Computation cancelled");
                }
            }
        });
    }

    @Override
    public void updateProperties(@NotNull XValueNode node, @NotNull ObjectPropertiesBase newObjectProperties, @NotNull XValuePlace place) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)newObjectProperties, (String)"newObjectProperties");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        this.lastComputedProperties = newObjectProperties;
        DotNetValueUtilsKt.renderObject(node, this.getObjectProxy(), newObjectProperties);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DotNetValueUtilsKt.computeChildren((ObjectEntityBase)this.getObjectProxy(), node, this.getLifetime(), (Function1<? super ObjectProxy, ? extends XNamedValue>)((Function1)new Function1<ObjectProxy, XNamedValue>(this){
            final /* synthetic */ DotNetMemoryViewValue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final XNamedValue invoke(@NotNull ObjectProxy it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new DotNetMemoryViewValue(it, DotNetMemoryViewValue.access$getExecutionContextProxy$p(this.this$0), this.this$0.getLifetime(), DotNetMemoryViewValue.access$getSession$p(this.this$0), null);
            }
        }), (Function1<? super GroupProxy, ? extends XValueGroup>)((Function1)new Function1<GroupProxy, XValueGroup>(this){
            final /* synthetic */ DotNetMemoryViewValue this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final XValueGroup invoke(@NotNull GroupProxy it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new DotNetMemoryViewValueGroup(it, DotNetMemoryViewValue.access$getExecutionContextProxy$p(this.this$0), this.this$0.getLifetime(), DotNetMemoryViewValue.access$getSession$p(this.this$0));
            }
        }), false, false);
    }

    public boolean canNavigateToTypeSource() {
        return DotNetValueUtilsKt.canNavigateToTypeLocation(this);
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        IDotNetValue iDotNetValue = this;
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DotNetValueUtilsKt.computeTypeLocation(iDotNetValue, navigatable, project, this.getLifetime());
    }

    public static final /* synthetic */ ExecutionContextProxy access$getExecutionContextProxy$p(DotNetMemoryViewValue $this) {
        return $this.executionContextProxy;
    }

    public static final /* synthetic */ XDebugSession access$getSession$p(DotNetMemoryViewValue $this) {
        return $this.session;
    }
}

