/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow.consoleImpl;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBFont;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowOperations;
import com.jetbrains.rider.debugger.immediateWindow.consoleImpl.ImmediateWindowConsoleImpl;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import icons.RiderIcons;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0003*\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0004\u001a \u0010\u000b\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0010\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0003*\u00020\u0004\u00a8\u0006\u0012"}, d2={"createEnableBreakEventsOnEvaluationAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "attachOnActionHandler", "", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;", "operations", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;", "changeConsolesTheme", "calledOnComponentCreation", "", "changeFontSize", "createAddWatchAction", "enabled", "Lcom/jetbrains/rd/util/reactive/Property;", "createShowEvaluateDialogAction", "setFocusOnWritableContent", "setToolbarColor", "subscribeToThemeChanging", "intellij.rider"})
public final class ImmediateWindowConsoleImplUtilsKt {
    @NotNull
    public static final AnAction createAddWatchAction(@NotNull ImmediateWindowConsoleImpl $this$createAddWatchAction, @NotNull ImmediateWindowOperations operations, @NotNull Property<Boolean> enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createAddWatchAction), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        String string = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.add.watch.action.text", new Object[0]);
        String string2 = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.add.watch.action.description", new Object[0]);
        Icon icon2 = AllIcons.Debugger.Watch;
        return (AnAction)new TooltipDescriptionProvider($this$createAddWatchAction, enabled, operations, string, string2, icon2){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_createAddWatchAction;
            final /* synthetic */ Property<Boolean> $enabled;
            final /* synthetic */ ImmediateWindowOperations $operations;
            {
                this.$this_createAddWatchAction = $receiver;
                this.$enabled = $enabled;
                this.$operations = $operations;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int n = (SystemInfo.isMac ? 4 : 2) | 1;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(10, n);
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke));
                this.registerCustomShortcutSet($receiver.getConsoleEditor().getComponent(), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)$receiver.getLifetime(), null, (int)1, null));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.addWatch();
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(((Boolean)this.$enabled.getValue()).booleanValue());
                super.update(e);
            }

            public final void addWatch() {
                String string = this.$this_createAddWatchAction.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.$operations.addWatch(string);
            }
        };
    }

    @NotNull
    public static final AnAction createShowEvaluateDialogAction(@NotNull ImmediateWindowConsoleImpl $this$createShowEvaluateDialogAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createShowEvaluateDialogAction), (String)"<this>");
        String string = RiderDebuggerBundle.Companion.message("immediate.window.action.evaluate.in.dialog.window.text", new Object[0]);
        Icon icon2 = AllIcons.Debugger.EvaluateExpression;
        return (AnAction)new DumbAware($this$createShowEvaluateDialogAction, string, icon2){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_createShowEvaluateDialogAction;
            {
                this.$this_createShowEvaluateDialogAction = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                Project project = DataContextKt.getProject((DataContext)dataContext);
                if (project == null) {
                    throw new IllegalStateException("Not null project expected".toString());
                }
                Project project2 = project;
                XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
                if (xDebugSession == null) {
                    throw new IllegalStateException("Not null session expected".toString());
                }
                XDebugSession xDebugSession2 = xDebugSession;
                XDebuggerEvaluator xDebuggerEvaluator = xDebugSession2.getDebugProcess().getEvaluator();
                if (xDebuggerEvaluator == null) {
                    throw new IllegalStateException("Not null evaluator expected".toString());
                }
                XDebuggerEvaluator xDebuggerEvaluator2 = xDebuggerEvaluator;
                XExpression xExpression = xDebugSession2.getDebugProcess().getEditorsProvider().createExpression(project2, (Document)this.$this_createShowEvaluateDialogAction.getConsoleEditor().getDocument(), (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
                Intrinsics.checkNotNullExpressionValue((Object)xExpression, (String)"createExpression(...)");
                XExpression xExpression2 = xExpression;
                XStackFrame xStackFrame = xDebugSession2.getCurrentStackFrame();
                XSourcePosition xSourcePosition = xStackFrame != null ? xStackFrame.getSourcePosition() : null;
                XDebuggerEvaluationDialog xDebuggerEvaluationDialog = new XDebuggerEvaluationDialog(xDebugSession2, xDebugSession2.getDebugProcess().getEditorsProvider(), xExpression2, xSourcePosition, xDebuggerEvaluator2.isCodeFragmentEvaluationSupported());
                xDebuggerEvaluationDialog.show();
                String string = xExpression2.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    xDebuggerEvaluationDialog.performOKAction();
                }
            }
        };
    }

    public static final void attachOnActionHandler(@NotNull ImmediateWindowConsoleImpl $this$attachOnActionHandler, @NotNull ImmediateWindowOperations operations) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$attachOnActionHandler), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        BaseConsoleExecuteActionHandler baseConsoleExecuteActionHandler = new BaseConsoleExecuteActionHandler($this$attachOnActionHandler, operations){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_attachOnActionHandler;
            final /* synthetic */ ImmediateWindowOperations $operations;
            {
                this.$this_attachOnActionHandler = $receiver;
                this.$operations = $operations;
                super(false);
            }

            public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                String string = consoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                this.$this_attachOnActionHandler.getLogger().debug("User request, text: " + string2);
                if (StringsKt.isBlank((CharSequence)string2)) {
                    return;
                }
                this.$operations.startEval(string2);
            }
        };
        ConsoleExecuteAction consoleExecuteAction2 = new ConsoleExecuteAction((LanguageConsoleView)$this$attachOnActionHandler, (ConsoleExecuteAction.ConsoleExecuteActionHandler)baseConsoleExecuteActionHandler, baseConsoleExecuteActionHandler.getEmptyExecuteAction(), arg_0 -> ImmediateWindowConsoleImplUtilsKt.j((Function1)new Function1<LanguageConsoleView, Boolean>($this$attachOnActionHandler){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_attachOnActionHandler;
            {
                this.$this_attachOnActionHandler = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(LanguageConsoleView it) {
                return RLifetimeKt.isAlive((Lifetime)this.$this_attachOnActionHandler.getLifetime());
            }
        }, arg_0));
        consoleExecuteAction2.registerCustomShortcutSet(consoleExecuteAction2.getShortcutSet(), $this$attachOnActionHandler.getConsoleEditor().getComponent());
    }

    public static final void setFocusOnWritableContent(@NotNull ImmediateWindowConsoleImpl $this$setFocusOnWritableContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setFocusOnWritableContent), (String)"<this>");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)$this$setFocusOnWritableContent.getProject());
        SelectionListener selectionListener2 = new SelectionListener(booleanRef, ideFocusManager, $this$setFocusOnWritableContent){
            final /* synthetic */ Ref.BooleanRef $isSelection;
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ ImmediateWindowConsoleImpl $this_setFocusOnWritableContent;
            {
                this.$isSelection = $isSelection;
                this.$focusManager = $focusManager;
                this.$this_setFocusOnWritableContent = $receiver;
            }

            public void selectionChanged(@NotNull SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getNewRange().isEmpty()) {
                    this.$isSelection.element = false;
                    return;
                }
                this.$isSelection.element = true;
                this.$focusManager.requestFocus((Component)this.$this_setFocusOnWritableContent.getHistoryViewer().getContentComponent(), true);
            }
        };
        $this$setFocusOnWritableContent.getHistoryViewer().getSelectionModel().addSelectionListener(selectionListener2);
        $this$setFocusOnWritableContent.getLifetime().onTermination((Function0)new Function0<Unit>($this$setFocusOnWritableContent, selectionListener2){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_setFocusOnWritableContent;
            final /* synthetic */ SelectionListener $selectionListener;
            {
                this.$this_setFocusOnWritableContent = $receiver;
                this.$selectionListener = $selectionListener;
                super(0);
            }

            public final void invoke() {
                this.$this_setFocusOnWritableContent.getHistoryViewer().getSelectionModel().removeSelectionListener(this.$selectionListener);
            }
        });
        $this$setFocusOnWritableContent.getHistoryViewer().addFocusListener(new FocusChangeListener(booleanRef, ideFocusManager, $this$setFocusOnWritableContent){
            final /* synthetic */ Ref.BooleanRef $isSelection;
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ ImmediateWindowConsoleImpl $this_setFocusOnWritableContent;
            {
                this.$isSelection = $isSelection;
                this.$focusManager = $focusManager;
                this.$this_setFocusOnWritableContent = $receiver;
            }

            public void focusGained(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (this.$isSelection.element) {
                    return;
                }
                this.$focusManager.requestFocus((Component)this.$this_setFocusOnWritableContent.getConsoleEditor().getContentComponent(), true);
            }
        });
    }

    public static final void setToolbarColor(@NotNull ImmediateWindowConsoleImpl $this$setToolbarColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setToolbarColor), (String)"<this>");
        $this$setToolbarColor.getToolbarManager().getToolbar().setBackground(EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultBackground());
    }

    public static final void changeConsolesTheme(@NotNull ImmediateWindowConsoleImpl $this$changeConsolesTheme, boolean calledOnComponentCreation) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$changeConsolesTheme), (String)"<this>");
        $this$changeConsolesTheme.getConsoleEditor().setColorsScheme($this$changeConsolesTheme.getConsoleEditor().createBoundColorSchemeDelegate(EditorColorsManager.getInstance().getSchemeForCurrentUITheme()));
        $this$changeConsolesTheme.getHistoryViewer().setColorsScheme($this$changeConsolesTheme.getHistoryViewer().createBoundColorSchemeDelegate(EditorColorsManager.getInstance().getSchemeForCurrentUITheme()));
        ImmediateWindowConsoleImplUtilsKt.setToolbarColor($this$changeConsolesTheme);
        if (ExperimentalUI.Companion.isNewUI() && calledOnComponentCreation) {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = new PropertyChangeListener($this$changeConsolesTheme, (Ref.ObjectRef<PropertyChangeListener>)objectRef){
                final /* synthetic */ ImmediateWindowConsoleImpl $this_changeConsolesTheme;
                final /* synthetic */ Ref.ObjectRef<PropertyChangeListener> $listener;
                {
                    this.$this_changeConsolesTheme = $receiver;
                    this.$listener = $listener;
                }

                public void propertyChange(@Nullable PropertyChangeEvent evt) {
                    PropertyChangeEvent propertyChangeEvent = evt;
                    if (!Intrinsics.areEqual((Object)(propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null), (Object)"background")) {
                        return;
                    }
                    this.$this_changeConsolesTheme.getToolbarManager().getToolbar().removePropertyChangeListener((PropertyChangeListener)this.$listener.element);
                    ImmediateWindowConsoleImplUtilsKt.setToolbarColor(this.$this_changeConsolesTheme);
                }
            };
            $this$changeConsolesTheme.getToolbarManager().getToolbar().addPropertyChangeListener((PropertyChangeListener)objectRef.element);
        }
        JPanel jPanel = $this$changeConsolesTheme.getToolbarManager().getGotItNestedToolbar();
        if (jPanel != null) {
            jPanel.setBackground(EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultBackground());
        }
        $this$changeConsolesTheme.getConsoleEditor().getColorsScheme().setColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY, null);
        $this$changeConsolesTheme.getHistoryViewer().getColorsScheme().setColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY, null);
        $this$changeConsolesTheme.getConsoleEditor().getColorsScheme().setColor(ColorKey.createColorKey((String)"CONSOLE_PROMPT_COLOR"), ConsoleViewContentType.USER_INPUT.getAttributes().getForegroundColor());
        ImmediateWindowConsoleImplUtilsKt.changeFontSize($this$changeConsolesTheme);
    }

    public static /* synthetic */ void changeConsolesTheme$default(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ImmediateWindowConsoleImplUtilsKt.changeConsolesTheme(immediateWindowConsoleImpl, bl);
    }

    public static final void changeFontSize(@NotNull ImmediateWindowConsoleImpl $this$changeFontSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$changeFontSize), (String)"<this>");
        int n = UISettings.Companion.getInstance().getOverrideLafFonts() ? UISettings.Companion.getInstance().getFontSize() : JBFont.label().getSize();
        $this$changeFontSize.setFont($this$changeFontSize.getFont().deriveFont((float)n));
        $this$changeFontSize.getConsoleEditor().setFontSize(n);
        $this$changeFontSize.getHistoryViewer().setFontSize(n);
        EditorEx editorEx = $this$changeFontSize.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editorEx).getColorsScheme().setConsoleFontSize(n);
        Integer n2 = $this$changeFontSize.getToolbarManager().heightOfAction();
        if (n2 == null) {
            boolean bl = false;
            $this$changeFontSize.getLogger().warn("Unable to change immediate size according to UI font size");
            return;
        }
        int n3 = n2;
        if (n3 != 0) {
            float f = (float)n3 + 12.0f;
            $this$changeFontSize.getToolbarManager().getToolbar().setBorder(new EmptyBorder(6, 0, 0, 0));
            Border border = new EmptyBorder(((int)f - $this$changeFontSize.getConsoleEditor().getLineHeight()) / 2, 0, 0, 0);
            $this$changeFontSize.getConsoleEditor().getContentComponent().setBorder(border);
            $this$changeFontSize.getHistoryViewer().getContentComponent().setBorder(border);
            $this$changeFontSize.getOperations().applyCollapsedImmediateHeightChanges(f);
        }
    }

    public static final void subscribeToThemeChanging(@NotNull ImmediateWindowConsoleImpl $this$subscribeToThemeChanging) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$subscribeToThemeChanging), (String)"<this>");
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)$this$subscribeToThemeChanging);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> ImmediateWindowConsoleImplUtilsKt.j($this$subscribeToThemeChanging, arg_0));
    }

    @NotNull
    public static final AnAction createEnableBreakEventsOnEvaluationAction() {
        String string = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.stop.on.break.events.text", new Object[0]);
        Icon icon2 = RiderIcons.Debugger.EvaluateWithBreakpoints;
        return (AnAction)new DumbAwareToggleAction(string, icon2){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return PropertiesComponent.getInstance().getBoolean("debugger.immediate.window.stop.on.break.events", true);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PropertiesComponent.getInstance().setValue("debugger.immediate.window.stop.on.break.events", state, true);
            }
        };
    }

    private static final boolean j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }

    private static final void j(ImmediateWindowConsoleImpl immediateWindowConsoleImpl) {
        Intrinsics.checkNotNullParameter((Object)((Object)immediateWindowConsoleImpl), (String)"$this_subscribeToThemeChanging");
        ImmediateWindowConsoleImplUtilsKt.changeConsolesTheme$default(immediateWindowConsoleImpl, false, 1, null);
    }

    private static final void j(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, LafManager lafManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)immediateWindowConsoleImpl), (String)"$this_subscribeToThemeChanging");
        Intrinsics.checkNotNullParameter((Object)lafManager, (String)"it");
        DebuggerUIUtil.invokeLater(() -> ImmediateWindowConsoleImplUtilsKt.j(immediateWindowConsoleImpl));
    }
}

