/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow.consoleImpl;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.console.EditorMergedHorizontalScrollBarLayout;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.ui.DebuggerCopyPastePreprocessor;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.string.PrettyPrinter;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.evaluation.DotNetExpression;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowOperations;
import com.jetbrains.rider.debugger.immediateWindow.actions.ImmediateWindowCollapseExpandAction;
import com.jetbrains.rider.debugger.immediateWindow.consoleImpl.ImmediateWindowConsoleImplUtilsKt;
import com.jetbrains.rider.interactive.repl.history.CommandHistory;
import com.jetbrains.rider.interactive.repl.history.HistoryKeyListener;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpSyntaxHighlighter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00066789:;B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020/2\u0006\u00105\u001a\u00020\u0006H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u00060\u0010R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0015\u0010\u001d\u001a\u00060\u001eR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0015\u0010!\u001a\u00060\"R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u0015\u0010*\u001a\u00060+R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "expandedMode", "Lcom/jetbrains/rd/util/reactive/Property;", "", "operations", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;", "toolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/reactive/Property;Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;[Lcom/intellij/openapi/actionSystem/AnAction;)V", "getExpandedMode", "()Lcom/jetbrains/rd/util/reactive/Property;", "historyManager", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$HistoryManager;", "getHistoryManager", "()Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$HistoryManager;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getOperations", "()Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;", "placeHolderManager", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$PlaceHolderManager;", "getPlaceHolderManager", "()Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$PlaceHolderManager;", "printer", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$TextPrinter;", "getPrinter", "()Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$TextPrinter;", "scrollBar", "Ljavax/swing/JScrollBar;", "getToolbarActions", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "[Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarManager", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ToolbarManager;", "getToolbarManager", "()Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ToolbarManager;", "clear", "", "createCenterComponent", "Ljavax/swing/JComponent;", "j", "Lcom/intellij/openapi/editor/actionSystem/EditorAction;", "setEditable", "isEditable", "HistoryManager", "ImmediateWindowLayout", "MyActionButton", "PlaceHolderManager", "TextPrinter", "ToolbarManager", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nImmediateWindowConsoleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,487:1\n13#2:488\n13#3:489\n4098#4,11:490\n*S KotlinDebug\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl\n*L\n72#1:488\n72#1:489\n127#1:490,11\n*E\n"})
public final class ImmediateWindowConsoleImpl
extends LanguageConsoleImpl {
    @NotNull
    private final Property<Boolean> expandedMode;
    @NotNull
    private final ImmediateWindowOperations operations;
    @NotNull
    private final AnAction[] toolbarActions;
    @Nullable
    private JScrollBar scrollBar;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final PlaceHolderManager placeHolderManager;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TextPrinter printer;
    @NotNull
    private final HistoryManager historyManager;
    @NotNull
    private final ToolbarManager toolbarManager;

    public ImmediateWindowConsoleImpl(@NotNull Project project, @NotNull Property<Boolean> expandedMode, @NotNull ImmediateWindowOperations operations, AnAction ... toolbarActions) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(expandedMode, (String)"expandedMode");
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        super(project, RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.file.name", new Object[0]), (Language)CSharpLanguage.INSTANCE);
        this.expandedMode = expandedMode;
        this.operations = operations;
        this.toolbarActions = toolbarActions;
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)((Disposable)this));
        this.placeHolderManager = new PlaceHolderManager(this.lifetime);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(ImmediateWindowConsoleImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        this.printer = new TextPrinter();
        this.historyManager = new HistoryManager();
        this.toolbarManager = new ToolbarManager();
        this.getConsoleEditor().putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR, (Object)true);
        this.getHistoryViewer().putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR, (Object)true);
        this.setPrompt(" >");
        ImmediateWindowConsoleImplUtilsKt.attachOnActionHandler(this, this.operations);
        ImmediateWindowConsoleImplUtilsKt.setFocusOnWritableContent(this);
        JComponent jComponent2 = jComponent = this.getComponent();
        boolean bl3 = false;
        jComponent2.updateUI();
        this.getConsoleEditor().getSettings().setGutterIconsShown(false);
        this.getConsoleEditor().getSettings().setAdditionalLinesCount(0);
        this.getHistoryViewer().getSettings().setAdditionalLinesCount(0);
        jComponent = new LexerEditorHighlighter((SyntaxHighlighter)new CSharpSyntaxHighlighter(), EditorColorsManager.getInstance().getGlobalScheme());
        this.getHistoryViewer().setHighlighter((EditorHighlighter)jComponent);
        this.getConsoleEditor().setBorder(BorderFactory.createEmptyBorder());
        this.getHistoryViewer().setBorder(BorderFactory.createEmptyBorder());
        ImmediateWindowConsoleImplUtilsKt.changeConsolesTheme(this, true);
        this.expandedMode.getChange().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean expandedMode) {
                if (expandedMode) {
                    if (this.isEditable() && this.getHistoryViewer().getDocument().getTextLength() != 0) {
                        this.getPlaceHolderManager().removePlaceHolderIfNeeded();
                    }
                    this.getConsoleEditor().putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, null);
                    this.getHistoryViewer().getComponent().setVisible(true);
                } else {
                    if (this.isEditable()) {
                        this.getPlaceHolderManager().addPlaceHolder();
                    }
                    this.getConsoleEditor().putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, (Object)true);
                    this.getHistoryViewer().getComponent().setVisible(false);
                }
                this.getToolbarManager().changeToolbarStateIfNeeded();
            }
        });
        this.toolbarManager.changeToolbarStateIfNeeded();
        this.getConsoleEditor().getScrollPane().getVerticalScrollBar().setOpaque(false);
        this.getHistoryViewer().getScrollPane().getVerticalScrollBar().setOpaque(false);
        if (!ImmediateWindowCollapseExpandAction.Companion.isExpanded()) {
            this.getConsoleEditor().putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, (Object)true);
            this.getHistoryViewer().getComponent().setVisible(false);
        }
    }

    @NotNull
    public final Property<Boolean> getExpandedMode() {
        return this.expandedMode;
    }

    @NotNull
    public final ImmediateWindowOperations getOperations() {
        return this.operations;
    }

    @NotNull
    public final AnAction[] getToolbarActions() {
        return this.toolbarActions;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final PlaceHolderManager getPlaceHolderManager() {
        return this.placeHolderManager;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final TextPrinter getPrinter() {
        return this.printer;
    }

    @NotNull
    public final HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    @NotNull
    public final ToolbarManager getToolbarManager() {
        return this.toolbarManager;
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent jComponent = super.createCenterComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        JPanel jPanel = (JPanel)jComponent;
        Component[] componentArray = jPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] objectArray = componentArray;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object object : objectArray2) {
            if (!(object instanceof JScrollBar)) continue;
            collection.add(object);
        }
        JScrollBar jScrollBar = (JScrollBar)CollectionsKt.single((List)((List)collection));
        EditorEx editorEx = this.getHistoryViewer();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getHistoryViewer(...)");
        EditorEx editorEx2 = this.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"getConsoleEditor(...)");
        jPanel.setLayout((LayoutManager)((Object)new ImmediateWindowLayout(jScrollBar, editorEx, editorEx2, true, this.getMinHistoryLineCount())));
        this.scrollBar = jScrollBar;
        this.expandedMode.advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ ImmediateWindowConsoleImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                JScrollBar jScrollBar = ImmediateWindowConsoleImpl.access$getScrollBar$p(this.this$0);
                if (jScrollBar == null) {
                    throw new IllegalStateException("Panel has not been initialized yet".toString());
                }
                jScrollBar.setVisible(it);
                this.this$0.getConsoleEditor().getScrollPane().getVerticalScrollBar().setVisible(it);
                this.this$0.getHistoryViewer().getScrollPane().getVerticalScrollBar().setVisible(it);
            }
        });
        return jPanel;
    }

    /*
     * Unable to fully structure code
     */
    public void setEditable(boolean isEditable) {
        this.logger.trace("Changed console editable state: " + isEditable);
        if (!isEditable) ** GOTO lbl-1000
        v0 = this.getConsoleEditor();
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        if (!(((EditorImpl)v0).getPlaceholder() != null || this.getHistoryViewer().getDocument().getTextLength() != 0 && ((Boolean)this.expandedMode.invoke()).booleanValue())) {
            this.placeHolderManager.addPlaceHolder();
        } else lbl-1000:
        // 2 sources

        {
            this.placeHolderManager.removePlaceHolderIfNeeded();
        }
        super.setEditable(isEditable);
    }

    private final EditorAction j() {
        EditorActionHandler editorActionHandler = new EditorActionHandler(this){
            final /* synthetic */ ImmediateWindowConsoleImpl this$0;
            {
                this.this$0 = $receiver;
            }

            protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            }

            public boolean isEnabled(@Nullable Editor editor2, @Nullable DataContext dataContext) {
                DataContext dataContext2;
                if (!Intrinsics.areEqual((Object)editor2, (Object)this.this$0.getConsoleEditor())) {
                    this.this$0.getLogger().error("This action is for the immediate editor only");
                }
                if ((dataContext2 = dataContext) == null || (dataContext2 = DataContextKt.getProject((DataContext)dataContext2)) == null) {
                    return false;
                }
                DataContext dataContext3 = dataContext2;
                Editor editor3 = editor2;
                if (editor3 == null || (editor3 = editor3.getDocument()) == null) {
                    return false;
                }
                int n = editor3.getLineCount();
                if (this.this$0.getHistoryManager().isEmpty() || n > 1) {
                    return false;
                }
                return LookupManager.getInstance((Project)dataContext3).getActiveLookup() == null;
            }
        };
        return new EditorAction(editorActionHandler){};
    }

    public void clear() {
        super.clear();
        this.toolbarManager.addToolbarToInputConsole();
    }

    public static final /* synthetic */ JScrollBar access$getScrollBar$p(ImmediateWindowConsoleImpl $this) {
        return $this.scrollBar;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$HistoryManager;", "", "(Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;)V", "commandHistory", "Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;", "historyId", "", "isEmpty", "", "()Z", "<set-?>", "Lcom/jetbrains/rider/debugger/evaluation/DotNetExpression;", "lastDotnetExpression", "getLastDotnetExpression", "()Lcom/jetbrains/rider/debugger/evaluation/DotNetExpression;", "addToHistory", "", "expression", "j", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nImmediateWindowConsoleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$HistoryManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,487:1\n1549#2:488\n1620#2,3:489\n1855#2,2:492\n*S KotlinDebug\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$HistoryManager\n*L\n192#1:488\n192#1:489,3\n192#1:492,2\n*E\n"})
    public final class HistoryManager {
        @NotNull
        private CommandHistory commandHistory = new CommandHistory();
        @NotNull
        private final String historyId;
        @Nullable
        private DotNetExpression lastDotnetExpression;

        public HistoryManager() {
            this.historyId = "immediateWindow";
            Project project = ImmediateWindowConsoleImpl.this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            EditorEx editorEx = ImmediateWindowConsoleImpl.this.getConsoleEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getConsoleEditor(...)");
            final HistoryKeyListener historyKeyListener = new HistoryKeyListener(project, editorEx, this.commandHistory, true);
            ImmediateWindowConsoleImpl.this.getConsoleEditor().getContentComponent().addKeyListener(historyKeyListener);
            this.commandHistory.getListeners().add(historyKeyListener);
            ImmediateWindowConsoleImpl.this.getLifetime().onTermination((Function0)new Function0<Unit>(){

                public final void invoke() {
                    commandHistory.getListeners().remove(historyKeyListener);
                    ImmediateWindowConsoleImpl.this.getConsoleEditor().getContentComponent().removeKeyListener(historyKeyListener);
                }
            });
            List list2 = XDebuggerHistoryManager.getInstance((Project)ImmediateWindowConsoleImpl.this.getProject()).getRecentExpressions(this.historyId);
            Intrinsics.checkNotNull((Object)list2);
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                XExpression xExpression = (XExpression)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                String string = xExpression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
                String string2 = xExpression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExpression(...)");
                collection2.add(new CommandHistory.Entry(string, string2));
            }
            iterable = CollectionsKt.asReversed((List)((List)collection));
            CommandHistory commandHistory = this.commandHistory;
            boolean bl4 = false;
            for (Object e : iterable) {
                CommandHistory.Entry entry2 = (CommandHistory.Entry)e;
                boolean bl5 = false;
                commandHistory.addEntry(entry2);
            }
            ImmediateWindowConsoleImpl.this.getLogger().debug("Console listeners were added");
            ImmediateWindowConsoleImpl.this.j().registerCustomShortcutSet(HistoryManager::j, ImmediateWindowConsoleImpl.this.getConsoleEditor().getComponent());
        }

        public final boolean isEmpty() {
            return this.commandHistory.getSize() == 0;
        }

        @Nullable
        public final DotNetExpression getLastDotnetExpression() {
            return this.lastDotnetExpression;
        }

        public final void addToHistory(@NotNull DotNetExpression expression) {
            Intrinsics.checkNotNullParameter((Object)((Object)expression), (String)"expression");
            XDebuggerHistoryManager.getInstance((Project)ImmediateWindowConsoleImpl.this.getProject()).addRecentExpression(this.historyId, (XExpression)expression);
            String string = expression.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
            String string2 = expression.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExpression(...)");
            this.commandHistory.addEntry(new CommandHistory.Entry(string, string2));
            this.j();
            this.lastDotnetExpression = expression;
            ImmediateWindowConsoleImpl.this.getToolbarManager().enableWatchActionIfNeeded();
        }

        private final void j() {
            String string = ImmediateWindowConsoleImpl.this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = (((CharSequence)string).length() > 0 ? "\n" : "") + "  ";
            String string3 = string2 + ImmediateWindowConsoleImpl.this.getConsoleEditor().getDocument().getText() + "\n";
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)ImmediateWindowConsoleImpl.this.getEditorDocument(), (Project)ImmediateWindowConsoleImpl.this.getProject(), (boolean)false);
            MarkupModelEx markupModelEx = ImmediateWindowConsoleImpl.this.getHistoryViewer().getMarkupModel();
            Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
            MarkupModelEx markupModelEx2 = markupModelEx;
            TextRange textRange = TextRange.create((int)0, (int)ImmediateWindowConsoleImpl.this.getConsoleEditor().getDocument().getTextLength());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            TextRange textRange2 = textRange;
            int n = string2.length() + markupModelEx2.getDocument().getTextLength();
            ImmediateWindowConsoleImpl.this.getLogger().debug("Text for insertion the user input into history console: \"" + string3 + "\"");
            ImmediateWindowConsoleImpl.this.getHistoryViewer().getDocument().insertString(markupModelEx2.getDocument().getTextLength(), (CharSequence)string3);
            ImmediateWindowConsoleImpl.this.getToolbarManager().changeToolbarStateIfNeeded();
            String[] stringArray = new String[]{"ReSharper.OUTLINED_ENTITY", "MATCHED_BRACE_ATTRIBUTES", "UNMATCHED_BRACE_ATTRIBUTES"};
            LanguageConsoleImpl.duplicateHighlighters((MarkupModel)((MarkupModel)markupModelEx2), (MarkupModel)markupModel, (int)n, (TextRange)textRange2, (String[])stringArray);
        }

        private static final Shortcut[] j() {
            return KeymapManager.getInstance().getActiveKeymap().getShortcuts("EditorUp");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ImmediateWindowLayout;", "Lcom/intellij/execution/console/EditorMergedHorizontalScrollBarLayout;", "myScrollBar", "Ljavax/swing/JScrollBar;", "myFirst", "Lcom/intellij/openapi/editor/ex/EditorEx;", "mySecond", "myForceAdditionalColumnsUsage", "", "myMinLineCount", "", "(Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;Ljavax/swing/JScrollBar;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;ZI)V", "normalizeHeights", "Lcom/intellij/execution/console/EditorMergedHorizontalScrollBarLayout$HeightOfComponents;", "newHistoryHeight", "newInputHeight", "intellij.rider"})
    public final class ImmediateWindowLayout
    extends EditorMergedHorizontalScrollBarLayout {
        public ImmediateWindowLayout(@NotNull JScrollBar myScrollBar, @NotNull EditorEx myFirst, EditorEx mySecond, boolean myForceAdditionalColumnsUsage, int myMinLineCount) {
            Intrinsics.checkNotNullParameter((Object)myScrollBar, (String)"myScrollBar");
            Intrinsics.checkNotNullParameter((Object)myFirst, (String)"myFirst");
            Intrinsics.checkNotNullParameter((Object)mySecond, (String)"mySecond");
            super(myScrollBar, myFirst, mySecond, myForceAdditionalColumnsUsage, myMinLineCount);
        }

        @NotNull
        protected EditorMergedHorizontalScrollBarLayout.HeightOfComponents normalizeHeights(int newHistoryHeight, int newInputHeight) {
            if (!ImmediateWindowConsoleImpl.this.isEditable()) {
                if (ImmediateWindowConsoleImpl.this.getHistoryViewer().getComponent().isVisible() && ImmediateWindowConsoleImpl.this.getHistoryViewer().getDocument().getTextLength() != 0) {
                    return new EditorMergedHorizontalScrollBarLayout.HeightOfComponents(newHistoryHeight + newInputHeight, 0);
                }
                return new EditorMergedHorizontalScrollBarLayout.HeightOfComponents(0, newHistoryHeight + newInputHeight);
            }
            if (((Boolean)ImmediateWindowConsoleImpl.this.getExpandedMode().invoke()).booleanValue()) {
                if ((float)newHistoryHeight < ImmediateWindowCollapseExpandAction.Companion.getCollapsedImmediateHeight()) {
                    if (Intrinsics.areEqual((Object)ImmediateWindowConsoleImpl.this.getToolbarManager().getToolbarOnInputConsole(), (Object)false)) {
                        ImmediateWindowConsoleImpl.this.getToolbarManager().addToolbarToInputConsole();
                    }
                } else if (Intrinsics.areEqual((Object)ImmediateWindowConsoleImpl.this.getToolbarManager().getToolbarOnInputConsole(), (Object)true)) {
                    ImmediateWindowConsoleImpl.this.getToolbarManager().addToolbarToHistoryConsole();
                }
                return new EditorMergedHorizontalScrollBarLayout.HeightOfComponents(newHistoryHeight, newInputHeight);
            }
            return new EditorMergedHorizontalScrollBarLayout.HeightOfComponents(0, newHistoryHeight + newInputHeight);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$MyActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "minimumSize", "Ljava/awt/Dimension;", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;Ljava/awt/Dimension;)V", "FIELD_INPLACE_LOOK", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "getDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getIcon", "Ljavax/swing/Icon;", "getPopState", "", "isRolloverState", "", "intellij.rider"})
    public static final class MyActionButton
    extends ActionButton {
        @NotNull
        private final ActionButtonLook FIELD_INPLACE_LOOK;

        public MyActionButton(@NotNull AnAction action2, @NotNull Presentation presentation2, @NotNull String place, @NotNull Dimension minimumSize) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
            super(action2, presentation2, place, minimumSize);
            this.FIELD_INPLACE_LOOK = (ActionButtonLook)new IdeaActionButtonLook(){
                @NotNull
                private final JBColor BUTTON_SELECTED_BACKGROUND;
                {
                    JBColor jBColor = JBColor.namedColor((String)"SearchOption.selectedBackground", (int)14345453, (int)6054244);
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
                    this.BUTTON_SELECTED_BACKGROUND = jBColor;
                }

                public void paintBorder(@NotNull Graphics g, @NotNull JComponent component2, @ActionButtonComponent.ButtonState int state) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    if (component2.isFocusOwner() && component2.isEnabled()) {
                        Rectangle rectangle = new Rectangle(component2.getSize());
                        JBInsets.removeFrom((Rectangle)rectangle, (Insets)component2.getInsets());
                        IdeaActionButtonLook.SYSTEM_LOOK.paintLookBorder(g, rectangle, JBUI.CurrentTheme.ActionButton.focusedBorder());
                    } else {
                        super.paintBorder(g, component2, 0);
                    }
                }

                public void paintBackground(@NotNull Graphics g, @NotNull JComponent component2, int state) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    if (((MyActionButton)((Object)component2)).isRolloverState()) {
                        super.paintBackground(g, component2, state);
                        return;
                    }
                    if (state == 2 && component2.isEnabled()) {
                        Rectangle rectangle = new Rectangle(component2.getSize());
                        JBInsets.removeFrom((Rectangle)rectangle, (Insets)component2.getInsets());
                        this.paintLookBackground(g, rectangle, (Color)this.BUTTON_SELECTED_BACKGROUND);
                    }
                }
            };
            this.setLook(this.FIELD_INPLACE_LOOK);
            this.setFocusable(true);
            this.updateIcon();
        }

        public final boolean isRolloverState() {
            return super.isRollover();
        }

        @NotNull
        protected DataContext getDataContext() {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            return dataContext;
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        @Nullable
        public Icon getIcon() {
            Icon icon2;
            if (this.isEnabled() && this.isSelected() && (icon2 = this.myPresentation.getSelectedIcon()) != null) {
                return icon2;
            }
            return super.getIcon();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$PlaceHolderManager;", "", "placeHolderLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getPlaceHolderLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "addPlaceHolder", "", "removePlaceHolderIfNeeded", "j", "intellij.rider"})
    public final class PlaceHolderManager {
        @NotNull
        private final Lifetime placeHolderLifetime;

        public PlaceHolderManager(Lifetime placeHolderLifetime) {
            Intrinsics.checkNotNullParameter((Object)placeHolderLifetime, (String)"placeHolderLifetime");
            this.placeHolderLifetime = placeHolderLifetime;
            MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable((Lifetime)this.placeHolderLifetime, (String)"immediate keymap disposable"));
            Topic topic = KeymapManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new KeymapManagerListener(){

                public void activeKeymapChanged(@Nullable Keymap keymap2) {
                    this.j();
                }

                public void shortcutChanged(@NotNull Keymap keymap2, @NotNull String actionId) {
                    Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
                    Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
                    if (!Intrinsics.areEqual((Object)actionId, (Object)"NavigateToImmediateWindow")) {
                        return;
                    }
                    this.j();
                }
            });
        }

        @NotNull
        public final Lifetime getPlaceHolderLifetime() {
            return this.placeHolderLifetime;
        }

        private final void j() {
            String string = DebuggerUIUtil.getActionShortcutText((String)"NavigateToImmediateWindow");
            String string2 = RiderDebuggerBundle.Companion.message("ImmediateWindow.placeholder.evaluation.with.breakpoints.available", new Object[0]);
            String string3 = string == null ? string2 : string2 + " (" + string + ")";
            EditorEx editorEx = ImmediateWindowConsoleImpl.this.getConsoleEditor();
            Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            ((EditorImpl)editorEx).setPlaceholder((CharSequence)string3);
        }

        public final void addPlaceHolder() {
            ImmediateWindowConsoleImpl.this.getLogger().trace("Added placeholder");
            this.j();
        }

        public final void removePlaceHolderIfNeeded() {
            EditorEx editorEx = ImmediateWindowConsoleImpl.this.getConsoleEditor();
            Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            if (((EditorImpl)editorEx).getPlaceholder() == null) {
                return;
            }
            ImmediateWindowConsoleImpl.this.getLogger().trace("Removed placeholder");
            EditorEx editorEx2 = ImmediateWindowConsoleImpl.this.getConsoleEditor();
            Intrinsics.checkNotNull((Object)editorEx2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            ((EditorImpl)editorEx2).setPlaceholder(null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$TextPrinter;", "", "(Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;)V", "j", "", "text", "", "consoleViewContentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printError", "printSuccess", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nImmediateWindowConsoleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$TextPrinter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1#2:488\n*E\n"})
    public final class TextPrinter {
        public final void printSuccess(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            this.j(text2, consoleViewContentType);
        }

        public final void printError(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
            this.j(text2, consoleViewContentType);
        }

        private final void j(String string, ConsoleViewContentType consoleViewContentType) {
            PrettyPrinter prettyPrinter;
            int n = ImmediateWindowConsoleImpl.this.getHistoryViewer().getScrollPane().getHorizontalScrollBar().getValue();
            SwingUtilities.invokeLater(() -> TextPrinter.j(ImmediateWindowConsoleImpl.this, n));
            PrettyPrinter prettyPrinter2 = prettyPrinter = new PrettyPrinter();
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindowConsoleImpl.this;
            boolean bl = false;
            prettyPrinter2.setIndent(2);
            prettyPrinter2.print(string + "\n");
            immediateWindowConsoleImpl.print(prettyPrinter.toString(), consoleViewContentType);
            ImmediateWindowConsoleImpl.this.requestScrollingToEnd();
        }

        private static final void j(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, int n) {
            Intrinsics.checkNotNullParameter((Object)((Object)immediateWindowConsoleImpl), (String)"this$0");
            immediateWindowConsoleImpl.getHistoryViewer().getScrollPane().getHorizontalScrollBar().setValue(n);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\tH\u0002J\u0006\u0010#\u001a\u00020\u001fJ\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\tH\u0002J\u0006\u0010&\u001a\u00020\u001fJ\r\u0010'\u001a\u0004\u0018\u00010(\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR$\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ToolbarManager;", "", "(Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;)V", "addWatchAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "addWatchActionButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "addWatchActionIsEnabled", "Lcom/jetbrains/rd/util/reactive/Property;", "", "gotItNestedToolbar", "Ljavax/swing/JPanel;", "getGotItNestedToolbar", "()Ljavax/swing/JPanel;", "setGotItNestedToolbar", "(Ljavax/swing/JPanel;)V", "keyListener", "Ljava/awt/event/KeyListener;", "toolbar", "getToolbar", "<set-?>", "toolbarOnInputConsole", "getToolbarOnInputConsole", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "watchActionConstantlyEnabled", "getWatchActionConstantlyEnabled", "()Z", "setWatchActionConstantlyEnabled", "(Z)V", "addGotItPopup", "", "addToolbarToHistoryConsole", "addToolbarToInputConsole", "j", "changeToolbarStateIfNeeded", "N", "enable", "enableWatchActionIfNeeded", "heightOfAction", "", "()Ljava/lang/Integer;", "hideToolbar", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nImmediateWindowConsoleImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ToolbarManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1549#2:488\n1620#2,3:489\n1855#2,2:493\n1#3:492\n*S KotlinDebug\n*F\n+ 1 ImmediateWindowConsoleImpl.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl$ToolbarManager\n*L\n341#1:488\n341#1:489,3\n342#1:493,2\n*E\n"})
    public final class ToolbarManager {
        @NotNull
        private final JPanel toolbar;
        @Nullable
        private Boolean toolbarOnInputConsole;
        @NotNull
        private Property<Boolean> addWatchActionIsEnabled = new Property((Object)false);
        @NotNull
        private final AnAction addWatchAction = ImmediateWindowConsoleImplUtilsKt.createAddWatchAction(ImmediateWindowConsoleImpl.this, ImmediateWindowConsoleImpl.this.getOperations(), this.addWatchActionIsEnabled);
        @Nullable
        private JPanel gotItNestedToolbar;
        @NotNull
        private final KeyListener keyListener = new KeyListener(this, ImmediateWindowConsoleImpl.this){
            final /* synthetic */ ToolbarManager this$0;
            final /* synthetic */ ImmediateWindowConsoleImpl this$1;
            {
                this.this$0 = $receiver;
                this.this$1 = $receiver2;
            }

            public void keyPressed(@Nullable KeyEvent e) {
            }

            public void keyTyped(@Nullable KeyEvent e) {
            }

            public void keyReleased(@Nullable KeyEvent e) {
                ToolbarManager.access$enableDisableWatchAction(this.this$0, this.this$1.getConsoleEditor().getDocument().getTextLength() != 0);
            }
        };
        @NotNull
        private ActionButton addWatchActionButton;
        private boolean watchActionConstantlyEnabled;

        public ToolbarManager() {
            boolean bl;
            AnAction anAction;
            ImmediateWindowConsoleImpl.this.getConsoleEditor().getContentComponent().addKeyListener(this.keyListener);
            this.addWatchActionButton = ToolbarManager.j(this.addWatchAction);
            this.N(false);
            Object object = new SpreadBuilder(3);
            object.add((Object)ImmediateWindowConsoleImplUtilsKt.createEnableBreakEventsOnEvaluationAction());
            object.add((Object)ImmediateWindowConsoleImplUtilsKt.createShowEvaluateDialogAction(ImmediateWindowConsoleImpl.this));
            object.addSpread((Object)ImmediateWindowConsoleImpl.this.getToolbarActions());
            List list2 = CollectionsKt.listOf((Object[])object.toArray((Object[])new AnAction[object.size()]));
            Object object2 = list2;
            Object object3 = CollectionsKt.listOf((Object)this.addWatchActionButton);
            boolean bl2 = false;
            Iterable iterable = object2;
            Iterable iterable2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
            boolean bl3 = false;
            for (Object object4 : iterable) {
                anAction = (AnAction)object4;
                Collection collection = iterable2;
                bl = false;
                collection.add(ToolbarManager.j(anAction));
            }
            object = CollectionsKt.plus((Collection)object3, (Iterable)((List)iterable2));
            Object object5 = object2 = new JPanel(new FlowLayout(1, 5, 0));
            object3 = this;
            boolean bl4 = false;
            iterable2 = (Iterable)object;
            bl3 = false;
            for (Object object4 : iterable2) {
                anAction = (ActionButton)object4;
                bl = false;
                ((Container)object5).add((Component)anAction);
            }
            ((ToolbarManager)object3).toolbar = object2;
            this.toolbar.setBackground(ImmediateWindowConsoleImpl.this.getConsoleEditor().getBackgroundColor());
            ImmediateWindowConsoleImplUtilsKt.subscribeToThemeChanging(ImmediateWindowConsoleImpl.this);
        }

        @NotNull
        public final JPanel getToolbar() {
            return this.toolbar;
        }

        @Nullable
        public final Boolean getToolbarOnInputConsole() {
            return this.toolbarOnInputConsole;
        }

        @Nullable
        public final JPanel getGotItNestedToolbar() {
            return this.gotItNestedToolbar;
        }

        public final void setGotItNestedToolbar(@Nullable JPanel jPanel) {
            this.gotItNestedToolbar = jPanel;
        }

        public final boolean getWatchActionConstantlyEnabled() {
            return this.watchActionConstantlyEnabled;
        }

        public final void setWatchActionConstantlyEnabled(boolean bl) {
            this.watchActionConstantlyEnabled = bl;
        }

        public final void enableWatchActionIfNeeded() {
            if (this.watchActionConstantlyEnabled) {
                return;
            }
            ImmediateWindowConsoleImpl.this.getConsoleEditor().getContentComponent().removeKeyListener(this.keyListener);
            this.N(true);
            this.watchActionConstantlyEnabled = true;
        }

        private final void N(boolean bl) {
            if ((Boolean)this.addWatchActionIsEnabled.getValue() == bl) {
                return;
            }
            this.addWatchActionIsEnabled.set((Object)bl);
            this.addWatchActionButton.update();
        }

        @Nullable
        public final Integer heightOfAction() {
            Component[] componentArray = ImmediateWindowConsoleImpl.this.getToolbarManager().toolbar.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Serializable serializable = (Component)ArraysKt.getOrNull((Object[])componentArray, (int)0);
            return serializable != null && (serializable = serializable.getPreferredSize()) != null ? Integer.valueOf(((Dimension)serializable).height) : null;
        }

        public final void addGotItPopup() {
            if (this.gotItNestedToolbar != null) {
                return;
            }
            float f = ImmediateWindowConsoleImpl.this.getConsoleEditor().getColorsScheme().getConsoleFontSize();
            ActionLink actionLink = new JPanel(new FlowLayout(1, 5, 0));
            Object object = ImmediateWindowConsoleImpl.this;
            ActionLink actionLink2 = actionLink;
            boolean bl = false;
            actionLink2.setBackground(object.getConsoleEditor().getBackgroundColor());
            ActionLink actionLink3 = actionLink;
            object = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)this.addWatchAction.getShortcutSet())), (String)"getKeystrokeText(...)");
            object = new JBLabel(RiderDebuggerBundle.Companion.message("immediate.window.toolbar.got.it.description.message", (Object[])object));
            actionLink2 = object;
            bl = false;
            actionLink2.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
            actionLink2.setFont(actionLink2.getFont().deriveFont(f - (float)2));
            actionLink = object;
            Icon icon2 = AllIcons.Actions.Forward;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Forward");
            ActionLink actionLink4 = actionLink2 = new JBLabel(IconUtil.scaleByFont((Icon)icon2, null, (float)(f - (float)4)));
            boolean bl2 = false;
            actionLink4.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
            object = actionLink2;
            actionLink4 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)this.addWatchAction.getShortcutSet())), (String)"getKeystrokeText(...)");
            ActionLink actionLink5 = actionLink4 = new ActionLink(RiderDebuggerBundle.Companion.message("immediate.window.toolbar.got.it.action.link.text", (Object[])actionLink4), (Function1)new Function1<ActionEvent, Unit>(this, (JPanel)actionLink3){
                final /* synthetic */ ToolbarManager this$0;
                final /* synthetic */ JPanel $gotItToolbar;
                {
                    this.this$0 = $receiver;
                    this.$gotItToolbar = $gotItToolbar;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PropertiesComponent.getInstance().setValue("immediate.window.eval.count.until.watch.got.it.hidden", -1, 0);
                    this.this$0.getToolbar().remove(this.$gotItToolbar);
                    this.this$0.getToolbar().repaint();
                }
            });
            boolean bl3 = false;
            actionLink5.setFont(actionLink5.getFont().deriveFont(f - (float)2));
            actionLink2 = actionLink4;
            actionLink3.add((Component)actionLink);
            actionLink3.add((Component)actionLink2);
            actionLink3.add((Component)object);
            this.toolbar.add((Component)actionLink3, 0);
            this.gotItNestedToolbar = actionLink3;
        }

        public final void hideToolbar() {
            this.toolbar.setVisible(false);
        }

        public final void addToolbarToInputConsole() {
            JScrollPane jScrollPane = ImmediateWindowConsoleImpl.this.getHistoryViewer().getScrollPane();
            Intrinsics.checkNotNull((Object)jScrollPane, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBScrollPane");
            ((JBScrollPane)jScrollPane).setStatusComponent((JComponent)new JPanel());
            this.j(true);
        }

        public final void addToolbarToHistoryConsole() {
            this.j(false);
        }

        public final void changeToolbarStateIfNeeded() {
            boolean bl;
            boolean bl2 = bl = !ImmediateWindowCollapseExpandAction.Companion.isExpanded() || ImmediateWindowConsoleImpl.this.getHistoryViewer().getDocument().getTextLength() == 0;
            if (Intrinsics.areEqual((Object)this.toolbarOnInputConsole, (Object)bl)) {
                return;
            }
            this.j(bl);
        }

        private final void j(boolean bl) {
            if (bl) {
                ImmediateWindowConsoleImpl.this.getConsoleEditor().getComponent().add((Component)this.toolbar, "East");
                this.toolbarOnInputConsole = true;
            } else {
                ImmediateWindowConsoleImpl.this.getConsoleEditor().getComponent().remove(this.toolbar);
                JScrollPane jScrollPane = ImmediateWindowConsoleImpl.this.getHistoryViewer().getScrollPane();
                Intrinsics.checkNotNull((Object)jScrollPane, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBScrollPane");
                ((JBScrollPane)jScrollPane).setStatusComponent((JComponent)this.toolbar);
                this.toolbarOnInputConsole = false;
            }
        }

        private static final MyActionButton j(AnAction anAction) {
            Presentation presentation2 = anAction.getTemplatePresentation().clone();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"clone(...)");
            Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"DEFAULT_MINIMUM_BUTTON_SIZE");
            return new MyActionButton(anAction, presentation2, "unknown", dimension);
        }

        public static final /* synthetic */ void access$enableDisableWatchAction(ToolbarManager $this, boolean enable) {
            $this.N(enable);
        }
    }
}

