/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindow;
import java.awt.Dimension;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "(Lcom/intellij/xdebugger/impl/XDebugSessionImpl;)V", "componentListenerAdded", "", "getComponentListenerAdded", "()Z", "setComponentListenerAdded", "(Z)V", "expanded", "Lcom/jetbrains/rd/util/reactive/Property;", "getExpanded", "()Lcom/jetbrains/rd/util/reactive/Property;", "getSession", "()Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "applyCollapsedImmediateHeightChanges", "newHeight", "", "initialize", "j", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "needExpand", "Companion", "intellij.rider"})
public final class ImmediateWindowCollapseExpandAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSessionImpl session;
    @NotNull
    private final Property<Boolean> expanded;
    private boolean componentListenerAdded;
    private static float collapsedImmediateHeight = 34.0f;
    @NotNull
    public static final String immediateWindowExpandedKey = "debugger.immediate.window.expanded";

    public ImmediateWindowCollapseExpandAction(@NotNull XDebugSessionImpl session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(Companion.generateText(), null, Companion.getIcon());
        this.session = session;
        this.expanded = new Property((Object)Companion.isExpanded());
    }

    @NotNull
    public final XDebugSessionImpl getSession() {
        return this.session;
    }

    @NotNull
    public final Property<Boolean> getExpanded() {
        return this.expanded;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean bl = !Companion.isExpanded();
        this.j(bl);
        PropertiesComponent.getInstance().setValue(immediateWindowExpandedKey, bl, true);
        e.getPresentation().setIcon(Companion.getIcon());
        e.getPresentation().setText(Companion.generateText());
        this.expanded.set((Object)bl);
    }

    public final boolean getComponentListenerAdded() {
        return this.componentListenerAdded;
    }

    public final void setComponentListenerAdded(boolean bl) {
        this.componentListenerAdded = bl;
    }

    private final void j(boolean bl) {
        this.j(ImmediateWindow.Companion.getDebuggerSplitter((XDebugSession)this.session), bl);
    }

    private final void j(OnePixelSplitter onePixelSplitter, boolean bl) {
        if (bl) {
            onePixelSplitter.setProportion(0.5f);
            onePixelSplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_PROPORTION);
            onePixelSplitter.setResizeEnabled(true);
        } else {
            float f = 1.0f - collapsedImmediateHeight / (float)onePixelSplitter.getHeight();
            onePixelSplitter.setProportion(f);
            onePixelSplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
            onePixelSplitter.setResizeEnabled(false);
        }
        onePixelSplitter.getSecondComponent().getMinimumSize().height = (int)collapsedImmediateHeight;
    }

    public final void applyCollapsedImmediateHeightChanges(float newHeight) {
        collapsedImmediateHeight = newHeight;
        OnePixelSplitter onePixelSplitter = ImmediateWindow.Companion.getDebuggerSplitterSafe((XDebugSession)this.session);
        if (onePixelSplitter == null) {
            return;
        }
        this.j(onePixelSplitter, Companion.isExpanded());
    }

    public final void initialize() {
        if (!Companion.isExpanded()) {
            OnePixelSplitter onePixelSplitter;
            OnePixelSplitter onePixelSplitter2 = onePixelSplitter = ImmediateWindow.Companion.getDebuggerSplitter((XDebugSession)this.session);
            boolean bl = false;
            onePixelSplitter2.getSecondComponent().setMinimumSize(new Dimension(onePixelSplitter2.getSecondComponent().getMinimumSize().width, (int)collapsedImmediateHeight));
            onePixelSplitter2.setProportion(1.0f);
            onePixelSplitter2.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
            onePixelSplitter2.setResizeEnabled(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction$Companion;", "", "()V", "collapsedImmediateHeight", "", "getCollapsedImmediateHeight", "()F", "setCollapsedImmediateHeight", "(F)V", "immediateWindowExpandedKey", "", "generateText", "getIcon", "Ljavax/swing/Icon;", "isExpanded", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final float getCollapsedImmediateHeight() {
            return collapsedImmediateHeight;
        }

        public final void setCollapsedImmediateHeight(float f) {
            collapsedImmediateHeight = f;
        }

        public final boolean isExpanded() {
            return PropertiesComponent.getInstance().getBoolean(ImmediateWindowCollapseExpandAction.immediateWindowExpandedKey, true);
        }

        @NotNull
        public final Icon getIcon() {
            Icon icon2;
            if (this.isExpanded()) {
                Icon icon3 = AllIcons.General.CollapseComponent;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CollapseComponent");
            } else {
                Icon icon4 = AllIcons.General.ExpandComponent;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ExpandComponent");
            }
            return icon2;
        }

        @NlsActions.ActionText
        @NotNull
        public final String generateText() {
            return this.isExpanded() ? RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowCollapseExpandAction.collapse.text", new Object[0]) : RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowCollapseExpandAction.expand.text", new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

