/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XSplitterWatchesViewImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.rd.ide.model.ValuePresentationPartKind;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.evaluation.DotNetExpression;
import com.jetbrains.rider.debugger.evaluation.RiderExpressionUtilKt;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindow;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowEvaluator;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowOperations;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowStatistics;
import com.jetbrains.rider.debugger.immediateWindow.actions.ImmediateWindowCollapseExpandAction;
import com.jetbrains.rider.debugger.immediateWindow.consoleImpl.ImmediateWindowConsoleImpl;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.model.debuggerWorker.ImmediateEvaluationResult;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u00039:;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016J\u0006\u00103\u001a\u00020\u001fJ\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u00107\u001a\u00020-J\u0010\u00108\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00060$R\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0017\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow;", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowOperations;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debugTabLifetime", "immediateEvaluator", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;", "editorsProvider", "Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;)V", "collapseExpandAction", "Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction;", "getCollapseExpandAction", "()Lcom/jetbrains/rider/debugger/immediateWindow/actions/ImmediateWindowCollapseExpandAction;", "console", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;", "consoleEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getConsoleEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getDebugTabLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditorsProvider", "()Lcom/jetbrains/rider/debugger/DotNetDebuggerEditorsProvider;", "evalCounter", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$EvalCounter;", "getImmediateEvaluator", "()Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindowEvaluator;", "isImmediateMode", "", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sandboxManager", "Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "getSandboxManager", "()Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "setSandboxManager", "(Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;)V", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getSessionLifetime", "addWatch", "", "text", "", "applyCollapsedImmediateHeightChanges", "newHeight", "", "consoleIsFocusOwner", "createConsole", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "insertText", "requestFocus", "startEval", "Companion", "EvalCounter", "SandboxManager", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nImmediateWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindow.kt\ncom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n13#2:273\n13#3:274\n1#4:275\n*S KotlinDebug\n*F\n+ 1 ImmediateWindow.kt\ncom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow\n*L\n64#1:273\n64#1:274\n*E\n"})
public final class ImmediateWindow
implements ImmediateWindowOperations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final Lifetime sessionLifetime;
    @NotNull
    private final Lifetime debugTabLifetime;
    @NotNull
    private final ImmediateWindowEvaluator immediateEvaluator;
    @NotNull
    private final DotNetDebuggerEditorsProvider editorsProvider;
    private ImmediateWindowConsoleImpl console;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ImmediateWindowCollapseExpandAction collapseExpandAction;
    @NotNull
    private final EvalCounter evalCounter;
    public SandboxManager sandboxManager;
    @NotNull
    public static final String stopOnBreakEventsKey = "debugger.immediate.window.stop.on.break.events";

    public ImmediateWindow(@NotNull XDebugSession session, @NotNull Lifetime sessionLifetime, @NotNull Lifetime debugTabLifetime, @NotNull ImmediateWindowEvaluator immediateEvaluator, @NotNull DotNetDebuggerEditorsProvider editorsProvider) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)debugTabLifetime, (String)"debugTabLifetime");
        Intrinsics.checkNotNullParameter((Object)immediateEvaluator, (String)"immediateEvaluator");
        Intrinsics.checkNotNullParameter((Object)((Object)editorsProvider), (String)"editorsProvider");
        this.session = session;
        this.sessionLifetime = sessionLifetime;
        this.debugTabLifetime = debugTabLifetime;
        this.immediateEvaluator = immediateEvaluator;
        this.editorsProvider = editorsProvider;
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(ImmediateWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        this.collapseExpandAction = new ImmediateWindowCollapseExpandAction((XDebugSessionImpl)xDebugSession);
        this.evalCounter = new EvalCounter();
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    @NotNull
    public final Lifetime getDebugTabLifetime() {
        return this.debugTabLifetime;
    }

    @NotNull
    public final ImmediateWindowEvaluator getImmediateEvaluator() {
        return this.immediateEvaluator;
    }

    @NotNull
    public final DotNetDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @NotNull
    public final EditorImpl getConsoleEditor() {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        EditorEx editorEx = immediateWindowConsoleImpl.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return (EditorImpl)editorEx;
    }

    public final boolean isImmediateMode() {
        return ImmediateWindowCollapseExpandAction.Companion.isExpanded();
    }

    @NotNull
    public final ImmediateWindowCollapseExpandAction getCollapseExpandAction() {
        return this.collapseExpandAction;
    }

    @NotNull
    public final SandboxManager getSandboxManager() {
        SandboxManager sandboxManager = this.sandboxManager;
        if (sandboxManager != null) {
            return sandboxManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sandboxManager");
        return null;
    }

    public final void setSandboxManager(@NotNull SandboxManager sandboxManager) {
        Intrinsics.checkNotNullParameter((Object)sandboxManager, (String)"<set-?>");
        this.sandboxManager = sandboxManager;
    }

    @NotNull
    public final LanguageConsoleImpl createConsole() {
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AnAction[] anActionArray = new AnAction[]{this.collapseExpandAction};
        this.console = new ImmediateWindowConsoleImpl(project, this.collapseExpandAction.getExpanded(), this, anActionArray);
        this.logger.debug("Immediate console created");
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.setEditable(false);
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = this.console;
        if (immediateWindowConsoleImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl2 = null;
        }
        this.immediateEvaluator.setConsole(immediateWindowConsoleImpl2);
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl3 = this.console;
        if (immediateWindowConsoleImpl3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl3 = null;
        }
        EditorEx editorEx = immediateWindowConsoleImpl3.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.immediateEvaluator.setEditor((EditorImpl)editorEx);
        this.debugTabLifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImmediateWindow this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
                Disposer.dispose((Disposable)((Disposable)immediateWindowConsoleImpl));
            }
        });
        this.setSandboxManager(new SandboxManager());
        this.sessionLifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImmediateWindow this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl;
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl2 = null;
                }
                immediateWindowConsoleImpl2.setEditable(false);
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl3 = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl3 = null;
                }
                immediateWindowConsoleImpl3.setInputText("");
                if (!this.this$0.isImmediateMode()) {
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl4 = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl4 = null;
                    }
                    immediateWindowConsoleImpl4.clear();
                }
                if ((immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0)) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
                immediateWindowConsoleImpl.getConsoleEditor().getComponent().setVisible(false);
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl5 = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl5 = null;
                }
                immediateWindowConsoleImpl5.getToolbarManager().hideToolbar();
            }
        });
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl4 = this.console;
        if (immediateWindowConsoleImpl4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl4 = null;
        }
        return immediateWindowConsoleImpl4;
    }

    @Override
    public void applyCollapsedImmediateHeightChanges(float newHeight) {
        this.collapseExpandAction.applyCollapsedImmediateHeightChanges(newHeight);
    }

    public final void requestFocus() {
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.getConsoleEditor().getContentComponent().requestFocus();
    }

    public final boolean consoleIsFocusOwner() {
        return this.getConsoleEditor().getContentComponent().isFocusOwner();
    }

    public final void insertText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
        if (immediateWindowConsoleImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"console");
            immediateWindowConsoleImpl = null;
        }
        immediateWindowConsoleImpl.setInputText(text2);
        this.getConsoleEditor().getCaretModel().moveToOffset(text2.length());
    }

    @Override
    public void addWatch(@NotNull String text2) {
        XExpression xExpression;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.isBlank((CharSequence)text2)) {
            DotNetExpression dotNetExpression;
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            DotNetExpression dotNetExpression2 = immediateWindowConsoleImpl.getHistoryManager().getLastDotnetExpression();
            if (dotNetExpression2 != null) {
                DotNetExpression dotNetExpression3;
                DotNetExpression dotNetExpression4 = dotNetExpression3 = dotNetExpression2;
                boolean bl = false;
                RiderExpressionUtilKt.setNew(dotNetExpression4, true);
                dotNetExpression = dotNetExpression3;
            } else {
                dotNetExpression = null;
            }
            v3 = (XExpression)dotNetExpression;
        } else {
            v3 = xExpression = this.session.getDebugProcess().getEditorsProvider().createExpression(this.session.getProject(), (Document)this.immediateEvaluator.getEditor().getDocument(), (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
        }
        if (xExpression == null) {
            return;
        }
        XExpression xExpression2 = xExpression;
        XDebugSession xDebugSession = this.session;
        Intrinsics.checkNotNull((Object)xDebugSession, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        xExpression = (XDebugSessionImpl)xDebugSession;
        XDebugSessionTab xDebugSessionTab = xExpression.getSessionTab();
        Object object = xDebugSessionTab != null ? xDebugSessionTab.getWatchesView() : null;
        if (object == null) {
            throw new IllegalStateException("Not null session tab is expected here");
        }
        XWatchesView xWatchesView = object;
        xWatchesView.addWatchExpression(xExpression2, -1, false);
    }

    @Override
    public void startEval(@NotNull String text2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Project project = this.session.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DocumentEx documentEx = this.immediateEvaluator.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        XExpression xExpression = this.editorsProvider.createExpression(project, (Document)documentEx, (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
        Intrinsics.checkNotNull((Object)xExpression, (String)"null cannot be cast to non-null type com.jetbrains.rider.debugger.evaluation.DotNetExpression");
        DotNetExpression dotNetExpression = (DotNetExpression)xExpression;
        int n = ThreadLocalRandom.current().nextInt();
        Object object = this.session.getCurrentStackFrame();
        DotNetStackFrame dotNetStackFrame = object instanceof DotNetStackFrame ? (DotNetStackFrame)object : null;
        Integer n2 = dotNetStackFrame != null && (dotNetStackFrame = dotNetStackFrame.getFrameProxy()) != null ? Integer.valueOf(dotNetStackFrame.getId()) : null;
        ImmediateWindowStatistics.INSTANCE.getSTART_IMMEDIATE_EVALUATION().log((Object)n);
        boolean bl2 = bl = n2 != null;
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
        this.evalCounter.onStartEval();
        this.logger.debug("Start evaluation");
        bl = PropertiesComponent.getInstance().getBoolean(stopOnBreakEventsKey, true);
        Integer n3 = n2;
        Intrinsics.checkNotNull((Object)n3);
        this.immediateEvaluator.evaluateAsync(n3, dotNetExpression, bl, n, (Function0<Unit>)((Function0)new Function0<Unit>(this, dotNetExpression){
            final /* synthetic */ ImmediateWindow this$0;
            final /* synthetic */ DotNetExpression $expression;
            {
                this.this$0 = $receiver;
                this.$expression = $expression;
                super(0);
            }

            public final void invoke() {
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
                immediateWindowConsoleImpl.getHistoryManager().addToHistory(this.$expression);
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = ImmediateWindow.access$getConsole$p(this.this$0);
                if (immediateWindowConsoleImpl2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl2 = null;
                }
                immediateWindowConsoleImpl2.requestScrollingToEnd();
                if (this.this$0.isImmediateMode()) {
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl3 = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl3 = null;
                    }
                    immediateWindowConsoleImpl3.setInputText("");
                }
            }
        })).then(arg_0 -> ImmediateWindow.j((Function1)new Function1<ImmediateEvaluationResult, Unit>(this, n){
            final /* synthetic */ ImmediateWindow this$0;
            final /* synthetic */ int $evalId;
            {
                this.this$0 = $receiver;
                this.$evalId = $evalId;
                super(1);
            }

            public final void invoke(ImmediateEvaluationResult immediateResult) {
                if (immediateResult.getCreatedNewSyntheticVar()) {
                    this.this$0.getSandboxManager().recreateSandbox();
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl = null;
                    }
                    immediateWindowConsoleImpl.requestFocus();
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl2 = null;
                    }
                    immediateWindowConsoleImpl2.getConsoleEditor().getContentComponent().requestFocus();
                }
                ImmediateWindow.access$startEval$onEvaluationFinish(this.this$0, this.$evalId);
                this.this$0.getSession().rebuildViews();
                String string = ImmediateWindow.access$getEvalCounter$p(this.this$0).getWasExtraEvalOnStop() ? "\n" : "";
                String string2 = string + immediateResult.getResultOnConsole().getValue();
                if (immediateResult.getResultOnConsole().getKind() == ValuePresentationPartKind.Error) {
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl = null;
                    }
                    immediateWindowConsoleImpl.getPrinter().printError(string2);
                    ImmediateWindow.access$getLogger$p(this.this$0).debug("Error message with text: \"" + string2 + "\" was printed into history console");
                } else {
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$0);
                    if (immediateWindowConsoleImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl = null;
                    }
                    immediateWindowConsoleImpl.getPrinter().printSuccess(string2);
                    ImmediateWindow.access$getLogger$p(this.this$0).debug("Success message with text: \"" + string2 + "\" was printed into history console");
                }
            }
        }, arg_0)).onError(arg_0 -> ImmediateWindow.j((Function1)new Function1<Throwable, Unit>(this, n){
            final /* synthetic */ ImmediateWindow this$0;
            final /* synthetic */ int $evalId;
            {
                this.this$0 = $receiver;
                this.$evalId = $evalId;
                super(1);
            }

            public final void invoke(Throwable it) {
                if (it.getCause() instanceof CancellationException) {
                    ImmediateWindow.access$getLogger$p(this.this$0).debug("Evaluation(" + this.$evalId + ") was cancelled");
                    startEval.3.j(this.this$0, "Request was cancelled");
                } else {
                    String string = it.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    startEval.3.j(this.this$0, string);
                    ImmediateWindow.access$getLogger$p(this.this$0).debug("Throws exception during evaluation, message: \"" + it.getMessage() + "\" (" + this.$evalId + ")");
                }
                ImmediateWindow.access$startEval$onEvaluationFinish(this.this$0, this.$evalId);
            }

            private static final void j(ImmediateWindow immediateWindow, String string) {
                immediateWindow.getSession().rebuildViews();
                ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(immediateWindow);
                if (immediateWindowConsoleImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
                immediateWindowConsoleImpl.getPrinter().printError(string + "\n");
            }
        }, arg_0));
    }

    private static final void j(ImmediateWindow immediateWindow, int n) {
        ImmediateWindowStatistics.INSTANCE.getEND_IMMEDIATE_EVALUATION().log((Object)n);
        if (immediateWindow.isImmediateMode()) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getPlaceHolderManager().removePlaceHolderIfNeeded();
        }
        immediateWindow.evalCounter.onEndEval();
        if (PropertiesComponent.getInstance().getInt("immediate.window.eval.count.until.watch.got.it.hidden", 0) >= 3) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = immediateWindow.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getToolbarManager().addGotItPopup();
        }
    }

    private static final Unit j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Unit)function1.invoke(object);
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ void access$startEval$onEvaluationFinish(ImmediateWindow this$0, int evalId) {
        ImmediateWindow.j(this$0, evalId);
    }

    public static final /* synthetic */ EvalCounter access$getEvalCounter$p(ImmediateWindow $this) {
        return $this.evalCounter;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ImmediateWindow $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$Companion;", "", "()V", "stopOnBreakEventsKey", "", "getDebuggerSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getDebuggerSplitterSafe", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final OnePixelSplitter getDebuggerSplitterSafe(@NotNull XDebugSession session) {
            XSplitterWatchesViewImpl xSplitterWatchesViewImpl;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            XDebugSessionTab xDebugSessionTab = ((XDebugSessionImpl)session).getSessionTab();
            if (xDebugSessionTab == null) {
                return null;
            }
            XDebugSessionTab xDebugSessionTab2 = xDebugSessionTab;
            XWatchesView xWatchesView = xDebugSessionTab2.getWatchesView();
            XSplitterWatchesViewImpl xSplitterWatchesViewImpl2 = xSplitterWatchesViewImpl = xWatchesView instanceof XSplitterWatchesViewImpl ? (XSplitterWatchesViewImpl)xWatchesView : null;
            if (xSplitterWatchesViewImpl != null) {
                Component component2 = xSplitterWatchesViewImpl.getPanel().getComponents()[0];
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.ui.OnePixelSplitter");
                return (OnePixelSplitter)component2;
            }
            XWatchesView xWatchesView2 = xDebugSessionTab2.getWatchesView();
            Intrinsics.checkNotNull((Object)xWatchesView2, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.frame.XWatchesViewImpl");
            JPanel jPanel = ((XWatchesViewImpl)xWatchesView2).getPanel();
            Intrinsics.checkNotNull((Object)jPanel, (String)"null cannot be cast to non-null type com.intellij.ui.OnePixelSplitter");
            return (OnePixelSplitter)jPanel;
        }

        @NotNull
        public final OnePixelSplitter getDebuggerSplitter(@NotNull XDebugSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            OnePixelSplitter onePixelSplitter = this.getDebuggerSplitterSafe(session);
            if (onePixelSplitter == null) {
                throw new IllegalStateException("Not null session tab is expected here");
            }
            return onePixelSplitter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$EvalCounter;", "", "()V", "currentEvalIndex", "", "getCurrentEvalIndex", "()I", "setCurrentEvalIndex", "(I)V", "lastStartedEvalIndex", "getLastStartedEvalIndex", "setLastStartedEvalIndex", "wasExtraEvalOnStop", "", "getWasExtraEvalOnStop", "()Z", "onEndEval", "", "onStartEval", "intellij.rider"})
    private static final class EvalCounter {
        private int lastStartedEvalIndex;
        private int currentEvalIndex;

        public final int getLastStartedEvalIndex() {
            return this.lastStartedEvalIndex;
        }

        public final void setLastStartedEvalIndex(int n) {
            this.lastStartedEvalIndex = n;
        }

        public final int getCurrentEvalIndex() {
            return this.currentEvalIndex;
        }

        public final void setCurrentEvalIndex(int n) {
            this.currentEvalIndex = n;
        }

        public final boolean getWasExtraEvalOnStop() {
            return this.currentEvalIndex != this.lastStartedEvalIndex;
        }

        public final void onStartEval() {
            int n = this.currentEvalIndex;
            this.currentEvalIndex = n + 1;
            this.lastStartedEvalIndex = n;
        }

        public final void onEndEval() {
            int n = this.currentEvalIndex;
            this.currentEvalIndex = n + -1;
            n = PropertiesComponent.getInstance().getInt("immediate.window.eval.count.until.watch.got.it.hidden", 0);
            if (n != -1) {
                PropertiesComponent.getInstance().setValue("immediate.window.eval.count.until.watch.got.it.hidden", n + 1, 0);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow$SandboxManager;", "", "(Lcom/jetbrains/rider/debugger/immediateWindow/ImmediateWindow;)V", "focusGained", "", "getFocusGained", "()Z", "setFocusGained", "(Z)V", "sandboxAlreadyCreated", "getSandboxAlreadyCreated", "setSandboxAlreadyCreated", "disableEnableTypeHandler", "", "enable", "prepareSandboxBeforeCreating", "recreateSandbox", "recreateSandboxIfNeeded", "intellij.rider"})
    public final class SandboxManager {
        private boolean sandboxAlreadyCreated;
        private boolean focusGained;

        public SandboxManager() {
            FocusListener focusListener2 = new FocusListener(this){
                final /* synthetic */ SandboxManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(@Nullable FocusEvent e) {
                    this.this$0.setFocusGained(true);
                    this.this$0.recreateSandboxIfNeeded();
                }

                public void focusLost(@Nullable FocusEvent e) {
                    this.this$0.setFocusGained(false);
                }
            };
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.getConsoleEditor().getContentComponent().addFocusListener(focusListener2);
            XDebugSessionListener xDebugSessionListener = new XDebugSessionListener(this, ImmediateWindow.this){
                final /* synthetic */ SandboxManager this$0;
                final /* synthetic */ ImmediateWindow this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void sessionPaused() {
                    this.this$0.prepareSandboxBeforeCreating();
                    if (this.this$0.getFocusGained()) {
                        this.this$0.recreateSandbox();
                    }
                }

                public void sessionResumed() {
                    this.this$0.setSandboxAlreadyCreated(false);
                    ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.access$getConsole$p(this.this$1);
                    if (immediateWindowConsoleImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                        immediateWindowConsoleImpl = null;
                    }
                    immediateWindowConsoleImpl.setEditable(false);
                }

                public void stackFrameChanged() {
                    this.this$0.setSandboxAlreadyCreated(false);
                }
            };
            ImmediateWindow.this.getSession().addSessionListener(xDebugSessionListener, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)ImmediateWindow.this.getSessionLifetime(), null, (int)1, null));
        }

        public final boolean getSandboxAlreadyCreated() {
            return this.sandboxAlreadyCreated;
        }

        public final void setSandboxAlreadyCreated(boolean bl) {
            this.sandboxAlreadyCreated = bl;
        }

        public final void disableEnableTypeHandler(boolean enable) {
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl;
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl2 = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl2 = null;
            }
            Editor editor2 = immediateWindowConsoleImpl2.getEditor();
            if (enable) {
                immediateWindowConsoleImpl = ImmediateWindow.this.console;
                if (immediateWindowConsoleImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                    immediateWindowConsoleImpl = null;
                }
            } else {
                immediateWindowConsoleImpl = null;
            }
            editor2.putUserData(LanguageConsoleImpl.CONSOLE_VIEW_IN_EDITOR_VIEW, immediateWindowConsoleImpl);
        }

        public final void recreateSandboxIfNeeded() {
            if (this.sandboxAlreadyCreated) {
                return;
            }
            this.recreateSandbox();
        }

        public final void recreateSandbox() {
            ImmediateWindow.this.getImmediateEvaluator().tryReCreateSandbox();
            this.sandboxAlreadyCreated = true;
            this.disableEnableTypeHandler(true);
        }

        public final void prepareSandboxBeforeCreating() {
            this.disableEnableTypeHandler(false);
            ImmediateWindowConsoleImpl immediateWindowConsoleImpl = ImmediateWindow.this.console;
            if (immediateWindowConsoleImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"console");
                immediateWindowConsoleImpl = null;
            }
            immediateWindowConsoleImpl.setEditable(true);
        }

        public final boolean getFocusGained() {
            return this.focusGained;
        }

        public final void setFocusGained(boolean bl) {
            this.focusGained = bl;
        }
    }
}

