/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception.view;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.debugger.DotNetExceptionBreakpointsUtilKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetExceptionBreakpointProperties;
import com.jetbrains.rider.debugger.components.RiderExceptionPaneStatisticsCollector;
import com.jetbrains.rider.debugger.exception.model.CompositeExceptionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModelType;
import com.jetbrains.rider.stacktrace.StacktraceToolWindowFactory;
import com.jetbrains.rider.ui.components.ComponentFactories;
import com.jetbrains.rider.ui.components.base.Viewable;
import com.jetbrains.rider.ui.components.exceptions.ExceptionPaneUtils;
import icons.RiderIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0003J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/debugger/exception/view/ExceptionContentPane;", "Lcom/jetbrains/rider/ui/components/base/Viewable;", "Ljavax/swing/JComponent;", "exceptionModel", "Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "lifeTime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "closeAction", "Lkotlin/Function0;", "", "(Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "pane", "Ljavax/swing/JPanel;", "getPane", "()Ljavax/swing/JPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "selected", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "typeField", "Ljavax/swing/JLabel;", "j", "", "ex", "getView", "j", "intellij.rider"})
public final class ExceptionContentPane
implements Viewable<JComponent> {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Unit> closeAction;
    @Nullable
    private ExceptionModel selected;
    @NotNull
    private final JPanel pane;
    @NotNull
    private final JLabel typeField;
    @NotNull
    private ConsoleViewImpl consoleView;

    public ExceptionContentPane(final @NotNull CompositeExceptionModel exceptionModel, @NotNull Lifetime lifeTime, @NotNull Project project, @NotNull Function0<Unit> closeAction2) {
        ComboBox comboBox2;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"exceptionModel");
        Intrinsics.checkNotNullParameter((Object)lifeTime, (String)"lifeTime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(closeAction2, (String)"closeAction");
        this.project = project;
        this.closeAction = closeAction2;
        MigLayout migLayout = new MigLayout("fill, novisualpadding, ins 0, gapx 0, gapy " + JBUI.scale((int)1) + "px, flowy", "", "[min!][grow]");
        this.pane = new JPanel(migLayout){};
        this.typeField = new JLabel();
        this.consoleView = ExceptionPaneUtils.INSTANCE.getWrappedConsoleView(this.project, lifeTime);
        migLayout = new DefaultActionGroup();
        migLayout.add(ComponentFactories.Companion.getAnAction(RiderActionsBundle.Companion.message("action.stack.trace.explorer.text", new Object[0]), RiderIcons.Stacktrace.Stacktrace, true, (Function0)new Function0<Unit>(){

            public final void invoke() {
                StacktraceToolWindowFactory stacktraceToolWindowFactory = StacktraceToolWindowFactory.Companion.getInstance(this.getProject());
                stacktraceToolWindowFactory.showTab(exceptionModel.getStacktrace(), UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.getProject())));
                closeAction.invoke();
            }
        }));
        if (exceptionModel.getExceptionType() == ExceptionModelType.Handled) {
            migLayout.add(ComponentFactories.Companion.getAnAction(RiderActionsBundle.Companion.message("action.view.breakpoint.text", new Object[0]), AllIcons.General.GearPlain, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    RiderExceptionPaneStatisticsCollector.INSTANCE.exceptionBreakpointsCalled();
                    XBreakpoint<DotNetExceptionBreakpointProperties> xBreakpoint = DotNetExceptionBreakpointsUtilKt.getExistingExceptionBreakpoint(exceptionModel.getBreakpointType(), this.getProject());
                    BreakpointsDialogFactory.getInstance((Project)this.getProject()).showDialog(xBreakpoint);
                }
            }));
        }
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0, gap 0", "[]" + JBUI.scale((int)5) + "[min!]"));
        boolean bl = false;
        if (exceptionModel.getList().size() > 1) {
            comboBox2 = ComponentFactories.Companion.simpleCombo(exceptionModel.getList(), (Function1)new Function1<ExceptionModel, String>(exceptionModel, this){
                final /* synthetic */ CompositeExceptionModel $exceptionModel;
                final /* synthetic */ ExceptionContentPane this$0;
                {
                    this.$exceptionModel = $exceptionModel;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull ExceptionModel it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (String)(this.$exceptionModel.getList().size() == 1 ? "" : this.$exceptionModel.getList().indexOf(it) + 1 + "/" + this.$exceptionModel.getList().size() + " ") + ExceptionContentPane.access$getName(this.this$0, it);
                }
            });
            SourceExKt.adviseNotNull((ISource)((ISource)RdSwingKt.selectedItemProperty((JComboBox)((JComboBox)comboBox2))), (Lifetime)lifeTime, (Function1)((Function1)new Function1<ExceptionModel, Unit>(this){
                final /* synthetic */ ExceptionContentPane this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ExceptionModel it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ExceptionContentPane.access$select(this.this$0, it);
                }
            }));
            jPanel2.add((Component)comboBox2, "pushx, wmin " + JBUI.scale((int)20));
        } else {
            jPanel2.add((Component)this.typeField, "pushx, wmin " + JBUI.scale((int)20) + ", gaptop " + JBUI.scale((int)5) + "px, gapbottom " + JBUI.scale((int)5) + "px");
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Rider.Debugger.Popup", (ActionGroup)migLayout, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        comboBox2 = actionToolbar;
        comboBox2.getComponent().setOpaque(false);
        comboBox2.getComponent().setBorder((Border)JBUI.Borders.empty());
        comboBox2.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        jPanel2.add((Component)comboBox2.getComponent(), "wmin pref");
        JPanel jPanel3 = jPanel;
        this.pane.add(jPanel3);
        this.consoleView.setBorder((Border)JBUI.Borders.empty());
        this.pane.add((Component)this.consoleView, "grow");
        this.j(exceptionModel.getList().get(0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JPanel getPane() {
        return this.pane;
    }

    @NotNull
    public JComponent getView() {
        return this.pane;
    }

    private final void j(ExceptionModel exceptionModel) {
        this.selected = exceptionModel;
        this.typeField.setText(this.j(exceptionModel));
        this.consoleView.clear();
        this.consoleView.print(exceptionModel.getFullInfo(), ConsoleViewContentType.NORMAL_OUTPUT);
        this.consoleView.scrollTo(0);
    }

    @NlsSafe
    private final String j(ExceptionModel exceptionModel) {
        return StringsKt.substringAfterLast$default((String)exceptionModel.getType(), (String)".", null, (int)2, null);
    }

    public static final /* synthetic */ String access$getName(ExceptionContentPane $this, ExceptionModel ex) {
        return $this.j(ex);
    }

    public static final /* synthetic */ void access$select(ExceptionContentPane $this, ExceptionModel ex) {
        $this.j(ex);
    }
}

