/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.debugger.DotNetExceptionBreakpointsUtilKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModelType;
import com.jetbrains.rider.stacktrace.IStacktrace;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 C2\u00020\u0001:\u0001CB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010>\u001a\u000200J\u0006\u0010.\u001a\u000200J\u0006\u00109\u001a\u000200J\u0016\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0086@\u00a2\u0006\u0002\u0010BR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0010R\u0011\u0010!\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010#\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R \u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R \u00109\u001a\b\u0012\u0004\u0012\u0002000/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00102\"\u0004\b;\u00104R\u0011\u0010<\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0010\u00a8\u0006D"}, d2={"Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "", "list", "", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "exceptionType", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;", "(Ljava/util/List;Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;)V", "active", "Lcom/jetbrains/rd/util/reactive/IProperty;", "", "getActive", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "breakpointType", "", "getBreakpointType", "()Ljava/lang/String;", "getExceptionType", "()Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;", "exceptionTypeString", "getExceptionTypeString", "fullInfo", "getFullInfo", "ld", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getList", "()Ljava/util/List;", "message", "getMessage", "mutable", "getMutable", "()Z", "muted", "getMuted", "setMuted", "(Z)V", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "setPosition", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "resume", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getResume", "()Lcom/jetbrains/rd/util/reactive/Signal;", "setResume", "(Lcom/jetbrains/rd/util/reactive/Signal;)V", "stacktrace", "Lcom/jetbrains/rider/stacktrace/IStacktrace;", "getStacktrace", "()Lcom/jetbrains/rider/stacktrace/IStacktrace;", "stop", "getStop", "setStop", "type", "getType", "disable", "toggleMuteException", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider"})
public final class CompositeExceptionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ExceptionModel> list;
    @NotNull
    private final ExceptionModelType exceptionType;
    @NotNull
    private Signal<Unit> resume;
    @NotNull
    private Signal<Unit> stop;
    @NotNull
    private LifetimeDefinition ld;
    @NotNull
    private final IProperty<Boolean> active;
    @Nullable
    private XSourcePosition position;
    private boolean muted;

    public CompositeExceptionModel(@NotNull List<ExceptionModel> list2, @NotNull ExceptionModelType exceptionType) {
        boolean bl;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
        this.list = list2;
        this.exceptionType = exceptionType;
        boolean bl2 = bl = !((Collection)this.list).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.resume = Signal.Companion.Void();
        this.stop = Signal.Companion.Void();
        this.ld = Lifetime.Companion.getEternal().createNested();
        this.active = (IProperty)new Property((Object)true);
    }

    @NotNull
    public final List<ExceptionModel> getList() {
        return this.list;
    }

    @NotNull
    public final ExceptionModelType getExceptionType() {
        return this.exceptionType;
    }

    @NotNull
    public final Signal<Unit> getResume() {
        return this.resume;
    }

    public final void setResume(@NotNull Signal<Unit> signal) {
        Intrinsics.checkNotNullParameter(signal, (String)"<set-?>");
        this.resume = signal;
    }

    @NotNull
    public final Signal<Unit> getStop() {
        return this.stop;
    }

    public final void setStop(@NotNull Signal<Unit> signal) {
        Intrinsics.checkNotNullParameter(signal, (String)"<set-?>");
        this.stop = signal;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.ld.getLifetime();
    }

    @NotNull
    public final IProperty<Boolean> getActive() {
        return this.active;
    }

    @Nullable
    public final XSourcePosition getPosition() {
        return this.position;
    }

    public final void setPosition(@Nullable XSourcePosition xSourcePosition) {
        this.position = xSourcePosition;
    }

    @NlsSafe
    @NotNull
    public final String getMessage() {
        return this.list.get(0).getMessage();
    }

    @NlsSafe
    @NotNull
    public final String getType() {
        return this.list.get(0).getType();
    }

    @NotNull
    public final String getFullInfo() {
        return this.list.get(0).getFullInfo();
    }

    @Nls
    @NotNull
    public final String getExceptionTypeString() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.exceptionType.ordinal()]) {
            case 1 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.unknown.exception.message", new Object[0]);
            case 2 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.handled.exception.message", new Object[0]);
            case 3 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.unhandled.exception.message", new Object[0]);
            case 4 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.user.unhandled.exception.message", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final boolean getMutable() {
        return this.exceptionType != ExceptionModelType.Unhandled;
    }

    public final void disable() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
    }

    public final void resume() {
        InterfacesKt.fire((ISignal)((ISignal)this.resume));
        this.disable();
    }

    public final void stop() {
        InterfacesKt.fire((ISignal)((ISignal)this.stop));
        this.disable();
    }

    @NotNull
    public final IStacktrace getStacktrace() {
        return Companion.stacktrace(this.list.get(0));
    }

    public final boolean getMuted() {
        return this.muted;
    }

    public final void setMuted(boolean bl) {
        this.muted = bl;
    }

    @Nullable
    public final Object toggleMuteException(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Object object = DotNetExceptionBreakpointsUtilKt.toggleMuteException(this.getType(), this.muted, this.exceptionType, this.getBreakpointType() != null, project, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final String getBreakpointType() {
        return this.list.get(0).getBreakpointType();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel$Companion;", "", "()V", "stacktrace", "Lcom/jetbrains/rider/stacktrace/IStacktrace;", "ex", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IStacktrace stacktrace(@NotNull ExceptionModel ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            return new IStacktrace(ex){
                final /* synthetic */ ExceptionModel $ex;
                {
                    this.$ex = $ex;
                }

                @NotNull
                public Object getId() {
                    return this.$ex;
                }

                @NotNull
                public String getText() {
                    return this.$ex.getFullInfo();
                }

                @NotNull
                public String getTitle() {
                    return this.$ex.getType();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionModelType.values().length];
            try {
                nArray[ExceptionModelType.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.Handled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.Unhandled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.UserUnhandled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

