/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.WindowMoveListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.components.RiderPopupBalloonState;
import com.jetbrains.rider.debugger.exception.ExBalloonController;
import com.jetbrains.rider.debugger.exception.ExceptionBalloonLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.DockingLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.EditorAnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.SimplePopupLayouterSource;
import com.jetbrains.rider.ui.components.balloon.DraggableBalloon;
import com.jetbrains.rider.ui.components.resize.ResizeAbility;
import com.jetbrains.rider.ui.components.resize.Resizer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u001a\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0006\u0010(\u001a\u00020#R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/debugger/exception/ExBalloonController;", "", "balloon", "Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "state", "Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "project", "Lcom/intellij/openapi/project/Project;", "parentLT", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/LogicalPosition;Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "active", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getBalloon", "()Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "moveListener", "com/jetbrains/rider/debugger/exception/ExBalloonController$moveListener$1", "Lcom/jetbrains/rider/debugger/exception/ExBalloonController$moveListener$1;", "getProject", "()Lcom/intellij/openapi/project/Project;", "resizer", "Lcom/jetbrains/rider/ui/components/resize/Resizer;", "getState", "()Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "hide", "", "j", "Lcom/jetbrains/rider/ui/components/resize/ResizeAbility;", "balloonPosition", "Lcom/jetbrains/rider/debugger/exception/ExceptionBalloonLayouter$BalloonPosition;", "show", "intellij.rider"})
public final class ExBalloonController {
    @NotNull
    private final DraggableBalloon balloon;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final RiderPopupBalloonState state;
    @NotNull
    private final Project project;
    @Nullable
    private Resizer resizer;
    @NotNull
    private final moveListener.1 moveListener;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private Property<Boolean> active;

    public ExBalloonController(@NotNull DraggableBalloon balloon, @NotNull EditorEx editor2, @NotNull LogicalPosition logicalPosition, @NotNull RiderPopupBalloonState state, @NotNull Project project, @NotNull Lifetime parentLT) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentLT, (String)"parentLT");
        this.balloon = balloon;
        this.editor = editor2;
        this.state = state;
        this.project = project;
        JComponent jComponent = this.balloon.getDragArea();
        this.moveListener = new WindowMoveListener(this, jComponent){
            final /* synthetic */ ExBalloonController this$0;
            {
                this.this$0 = $receiver;
                super((Component)$super_call_param$1);
            }

            @NotNull
            protected Component getView(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                return this.this$0.getBalloon().getComponent();
            }

            public void mouseDragged(@Nullable MouseEvent event) {
                super.mouseDragged(event);
                this.this$0.getState().getPinned().set((Object)true);
                Resizer resizer = ExBalloonController.access$getResizer$p(this.this$0);
                if (resizer != null) {
                    resizer.setResizeAbility(new ResizeAbility(false, false, false, false, 15, null));
                }
            }
        };
        this.lifetime = (Lifetime)parentLT.createNested();
        this.active = new Property((Object)false);
        jComponent = EditorAnchoringRect.Companion.createHorizontalSmartClipRect(this.lifetime, this.editor.getDocument().getLineStartOffset(logicalPosition.line), (Editor)this.editor);
        Function1 function1 = (Function1)new Function1<Lifetime, PopupLayouter>((AnchoringRect)jComponent, this){
            final /* synthetic */ AnchoringRect $anchor;
            final /* synthetic */ ExBalloonController this$0;
            {
                this.$anchor = $anchor;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final PopupLayouter invoke(@NotNull Lifetime lt) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Object[] objectArray = new Anchoring2D[]{new Anchoring2D(Anchoring.FarOutside, Anchoring.FarOutside), new Anchoring2D(Anchoring.FarOutside, Anchoring.NearOutside)};
                return (PopupLayouter)new DockingLayouter(lt, this.$anchor, CollectionsKt.listOf((Object[])objectArray), this.this$0.getProject(), 0, false, 48, null);
            }
        };
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        PopupLayouter popupLayouter2 = new SimplePopupLayouterSource(function1, string).createLayouter(this.lifetime);
        final ExceptionBalloonLayouter exceptionBalloonLayouter = new ExceptionBalloonLayouter(this.lifetime, this.project, (Editor)this.editor, this.balloon, popupLayouter2, logicalPosition);
        this.active.view(this.lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>(){

            public final void invoke(@NotNull Lifetime lt, boolean it) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                if (!it) {
                    return;
                }
                this.getBalloon().getDragArea().addMouseListener((MouseListener)((Object)moveListener));
                this.getBalloon().getDragArea().addMouseMotionListener((MouseMotionListener)((Object)moveListener));
                resizer = new Resizer(this.getBalloon().getComponent(), lt);
                lt.onTermination((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.getBalloon().getDragArea().removeMouseListener((MouseListener)((Object)moveListener));
                        this.getBalloon().getDragArea().removeMouseMotionListener((MouseMotionListener)((Object)moveListener));
                        resizer = null;
                    }
                });
                this.getState().getPinned().view(lt, (Function2)new Function2<Lifetime, Boolean, Unit>(){

                    public final void invoke(@NotNull Lifetime modelt, boolean m) {
                        Intrinsics.checkNotNullParameter((Object)modelt, (String)"modelt");
                        if (!m) {
                            exceptionBalloonLayouter.install();
                            exceptionBalloonLayouter.getBalloonPosition().advise(modelt, (Function1)new Function1<ExceptionBalloonLayouter.BalloonPosition, Unit>(){

                                public final void invoke(@Nullable ExceptionBalloonLayouter.BalloonPosition it) {
                                    Resizer resizer = resizer;
                                    if (resizer != null) {
                                        resizer.setResizeAbility(this.j(it));
                                    }
                                }
                            });
                            modelt.onTermination((Function0)new Function0<Unit>(){

                                public final void invoke() {
                                    exceptionBalloonLayouter.uninstall();
                                }
                            });
                        }
                    }
                });
            }
        });
        this.state.getHideSignal().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hide();
            }
        });
    }

    @NotNull
    public final DraggableBalloon getBalloon() {
        return this.balloon;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final RiderPopupBalloonState getState() {
        return this.state;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    private final ResizeAbility j(ExceptionBalloonLayouter.BalloonPosition balloonPosition) {
        ExceptionBalloonLayouter.BalloonPosition balloonPosition2 = balloonPosition;
        return switch (balloonPosition2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[balloonPosition2.ordinal()]) {
            case -1 -> null;
            case 1 -> ResizeAbility.Companion.getTOP_RIGHT();
            case 2 -> ResizeAbility.Companion.getBOTTOM_RIGHT();
            case 3 -> ResizeAbility.Companion.getTOP_BOTTOM_RIGHT();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void hide() {
        this.active.set((Object)false);
        this.balloon.hide();
    }

    public final void show() {
        this.state.getPinned().set((Object)false);
        this.active.set((Object)true);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionBalloonLayouter.BalloonPosition.values().length];
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

