/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rider.services.popups.nova.layouter.LayoutResult;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterKt;
import com.jetbrains.rider.ui.components.balloon.SimpleBalloon;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u0019J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0019J\b\u0010 \u001a\u00020\u0019H\u0014R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/debugger/exception/EditorBalloonLayouter;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "balloon", "Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;", "popupLayouter", "Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;)V", "active", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getBalloon", "()Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProject", "()Lcom/intellij/openapi/project/Project;", "j", "", "N", "install", "j", "location", "Ljava/awt/Point;", "uninstall", "update", "intellij.rider"})
public class EditorBalloonLayouter {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final SimpleBalloon balloon;
    @NotNull
    private final PopupLayouter popupLayouter;
    @NotNull
    private Property<Boolean> active;

    public EditorBalloonLayouter(@NotNull Lifetime lifetime2, @NotNull Project project, @NotNull Editor editor2, @NotNull SimpleBalloon balloon, @NotNull PopupLayouter popupLayouter2) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)popupLayouter2, (String)"popupLayouter");
        this.lifetime = lifetime2;
        this.project = project;
        this.editor = editor2;
        this.balloon = balloon;
        this.popupLayouter = popupLayouter2;
        this.active = new Property((Object)false);
        RdSwingKt.sizeProperty((JComponent)this.balloon.getComponent()).advise(this.lifetime, (Function1)new Function1<Dimension, Unit>(){

            public final void invoke(@NotNull Dimension it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                popupLayouter.getSize().set((Object)it);
            }
        });
        this.active.view(this.lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>(){

            public final void invoke(@NotNull Lifetime lt, boolean it) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                if (!it) {
                    return;
                }
                popupLayouter.getLayout().advise(lt, (Function1)new Function1<LayoutResult, Unit>(){

                    public final void invoke(@Nullable LayoutResult it) {
                        this.update();
                    }
                });
                PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)popupLayouter.getLayout()), (Function1)2.INSTANCE).view(lt, (Function2)new Function2<Lifetime, Boolean, Unit>(){

                    public final void invoke(@NotNull Lifetime sbslt, boolean sbs) {
                        Intrinsics.checkNotNullParameter((Object)sbslt, (String)"sbslt");
                        if (sbs) {
                            this.N();
                        } else {
                            this.j();
                        }
                    }
                });
                this.update();
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final SimpleBalloon getBalloon() {
        return this.balloon;
    }

    public final void install() {
        this.active.set((Object)true);
    }

    public final void uninstall() {
        this.active.set((Object)false);
    }

    private final void N() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        this.balloon.show();
    }

    protected void update() {
        LayoutResult layoutResult = (LayoutResult)this.popupLayouter.getLayout().getValue();
        this.j(layoutResult != null ? PopupLayouterKt.getLocation((LayoutResult)layoutResult) : null);
    }

    private final void j(Point point) {
        if (point == null) {
            return;
        }
        SwingUtilities.convertPointFromScreen(point, this.balloon.getComponent().getParent());
        this.balloon.getComponent().setLocation(point);
    }

    private final void j() {
        this.balloon.hide();
    }
}

