/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.disabledMethods;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.debugger.disabledMethods.DisabledListItem;
import com.jetbrains.rider.debugger.disabledMethods.RiderDebuggerDisabledMethodsManager;
import com.jetbrains.rider.model.debuggerWorker.CrashDuringEvaluationArg;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="DisabledMethodsStorage", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager$State;", "()V", "allDisabledMethods", "", "Lcom/jetbrains/rider/debugger/disabledMethods/DisabledListItem;", "getAllDisabledMethods", "()Ljava/util/Collection;", "disabledList", "Lcom/jetbrains/rd/util/reactive/IViewableSet;", "getDisabledList", "()Lcom/jetbrains/rd/util/reactive/IViewableSet;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "myDisabledList", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "state", "add", "", "item", "getState", "loadState", "remove", "Companion", "State", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerDisabledMethodsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerDisabledMethodsManager.kt\ncom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n13#2:79\n13#3:80\n1#4:81\n1549#5:82\n1620#5,3:83\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerDisabledMethodsManager.kt\ncom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager\n*L\n35#1:79\n35#1:80\n76#1:82\n76#1:83,3\n*E\n"})
public final class RiderDebuggerDisabledMethodsManager
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final State state;
    @NotNull
    private final ViewableSet<DisabledListItem> myDisabledList;
    @NotNull
    private final IViewableSet<DisabledListItem> disabledList;

    public RiderDebuggerDisabledMethodsManager() {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RiderDebuggerDisabledMethodsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.log = logger2;
        this.state = new State(null, 1, null);
        this.myDisabledList = new ViewableSet(null, 1, null);
        this.disabledList = (IViewableSet)this.myDisabledList;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loading disabled methods:");
            for (String string : state.getDisabledMethods()) {
                this.log.debug(string);
            }
        }
        this.state.setDisabledMethods(state.getDisabledMethods());
        this.myDisabledList.addAll(this.getAllDisabledMethods());
    }

    @NotNull
    public final IViewableSet<DisabledListItem> getDisabledList() {
        return this.disabledList;
    }

    public final void add(@NotNull DisabledListItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.log.trace("Before adding " + item.getMethodTitle() + " into disabled methods list");
        boolean bl = this.state.getDisabledMethods().add(item.getMethodTitle());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "item must be added";
            throw new AssertionError((Object)string);
        }
        bl = this.myDisabledList.add((Object)item);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "item must be added";
            throw new AssertionError((Object)string);
        }
        this.log.trace(item.getMethodTitle() + " was successfully added into disabled methods list");
    }

    public final void remove(@NotNull DisabledListItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.log.trace("Before removing " + item.getMethodTitle() + " from disabled methods list");
        boolean bl = this.state.getDisabledMethods().remove(item.getMethodTitle());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "item must be removed";
            throw new AssertionError((Object)string);
        }
        bl = this.myDisabledList.remove((Object)item);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "item must be removed";
            throw new AssertionError((Object)string);
        }
        this.log.trace(item.getMethodTitle() + " was successfully removed from disabled methods list");
    }

    @NotNull
    public final Collection<DisabledListItem> getAllDisabledMethods() {
        Iterable iterable = this.state.getDisabledMethods();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new DisabledListItem(string));
        }
        return (List)collection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager;", "project", "Lcom/intellij/openapi/project/Project;", "subscribe", "", "debugProxy", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderDebuggerDisabledMethodsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(RiderDebuggerDisabledMethodsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RiderDebuggerDisabledMethodsManager)object;
        }

        public final void subscribe(@NotNull Project project, @NotNull DotNetDebuggerSessionModel debugProxy, @NotNull Lifetime sessionLifetime) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)debugProxy, (String)"debugProxy");
            Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
            RiderDebuggerDisabledMethodsManager riderDebuggerDisabledMethodsManager = this.getInstance(project);
            debugProxy.getCrashDuringEvaluation().advise(sessionLifetime, (Function1)new Function1<CrashDuringEvaluationArg, Unit>(riderDebuggerDisabledMethodsManager){
                final /* synthetic */ RiderDebuggerDisabledMethodsManager $storage;
                {
                    this.$storage = $storage;
                    super(1);
                }

                public final void invoke(@NotNull CrashDuringEvaluationArg it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$storage.add(new DisabledListItem(it.getMethodTitle()));
                }
            });
            riderDebuggerDisabledMethodsManager.getDisabledList().advise(sessionLifetime, (Function1)new Function1<IViewableSet.Event<DisabledListItem>, Unit>(debugProxy){
                final /* synthetic */ DotNetDebuggerSessionModel $debugProxy;
                {
                    this.$debugProxy = $debugProxy;
                    super(1);
                }

                public final void invoke(@NotNull IViewableSet.Event<DisabledListItem> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    switch (subscribe.WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                        case 1: {
                            this.$debugProxy.getDisabledToInvokeMethods().add((Object)((DisabledListItem)it.getValue()).getMethodTitle());
                            break;
                        }
                        case 2: {
                            this.$debugProxy.getDisabledToInvokeMethods().remove((Object)((DisabledListItem)it.getValue()).getMethodTitle());
                        }
                    }
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/disabledMethods/RiderDebuggerDisabledMethodsManager$State;", "", "disabledMethods", "", "", "(Ljava/util/Set;)V", "getDisabledMethods", "()Ljava/util/Set;", "setDisabledMethods", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class State {
        @NotNull
        private Set<String> disabledMethods;

        public State(@NotNull Set<String> disabledMethods) {
            Intrinsics.checkNotNullParameter(disabledMethods, (String)"disabledMethods");
            this.disabledMethods = disabledMethods;
        }

        public /* synthetic */ State(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = new LinkedHashSet();
            }
            this(set);
        }

        @NotNull
        public final Set<String> getDisabledMethods() {
            return this.disabledMethods;
        }

        public final void setDisabledMethods(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.disabledMethods = set;
        }

        @NotNull
        public final Set<String> component1() {
            return this.disabledMethods;
        }

        @NotNull
        public final State copy(@NotNull Set<String> disabledMethods) {
            Intrinsics.checkNotNullParameter(disabledMethods, (String)"disabledMethods");
            return new State(disabledMethods);
        }

        public static /* synthetic */ State copy$default(State state, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = state.disabledMethods;
            }
            return state.copy(set);
        }

        @NotNull
        public String toString() {
            return "State(disabledMethods=" + this.disabledMethods + ")";
        }

        public int hashCode() {
            return ((Object)this.disabledMethods).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.disabledMethods, state.disabledMethods);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

