/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.debugger.actions.ExceptionPopupResumeAction;
import com.jetbrains.rider.debugger.components.RiderPaneWithTitle;
import com.jetbrains.rider.debugger.components.RiderPopupBalloonState;
import com.jetbrains.rider.ui.components.ComponentFactories;
import com.jetbrains.rider.ui.themes.RiderTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u0015H$J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH$J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0003H\u0014J\u0006\u0010%\u001a\u00020&R\u001a\u0010\u000b\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/debugger/components/RiderPaneWithTitle;", "Ljavax/swing/JPanel;", "titleName", "", "state", "Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "header", "getHeader", "()Ljavax/swing/JPanel;", "setHeader", "(Ljavax/swing/JPanel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getState", "()Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "title", "Ljavax/swing/JComponent;", "getTitle", "()Ljavax/swing/JComponent;", "setTitle", "(Ljavax/swing/JComponent;)V", "createContentPane", "j", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getAdditionalToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getPaneMinimumSize", "Lcom/intellij/util/ui/JBDimension;", "j", "Ljava/awt/Dimension;", "getSizeKey", "initPane", "", "intellij.rider"})
public abstract class RiderPaneWithTitle
extends JPanel {
    @NotNull
    private final String titleName;
    @NotNull
    private final RiderPopupBalloonState state;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    public JComponent title;
    public JPanel header;

    public RiderPaneWithTitle(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String titleName, @NotNull RiderPopupBalloonState state, @NotNull Lifetime lifetime2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)titleName, (String)"titleName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new MigLayout("fill, novisualpadding, ins 0, gap 0, flowy, hidemode 3", "", "[min!][grow]"));
        this.titleName = titleName;
        this.state = state;
        this.lifetime = lifetime2;
        this.project = project;
    }

    @NotNull
    protected final RiderPopupBalloonState getState() {
        return this.state;
    }

    @NotNull
    protected final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final JComponent getTitle() {
        JComponent jComponent = this.title;
        if (jComponent != null) {
            return jComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"title");
        return null;
    }

    public final void setTitle(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"<set-?>");
        this.title = jComponent;
    }

    @NotNull
    public final JPanel getHeader() {
        JPanel jPanel = this.header;
        if (jPanel != null) {
            return jPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        return null;
    }

    public final void setHeader(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.header = jPanel;
    }

    public final void initPane() {
        this.setMinimumSize((Dimension)this.getPaneMinimumSize());
        this.setPreferredSize(this.j());
        this.setBackground(JBUI.CurrentTheme.ToolWindow.headerBackground());
        ComponentListener componentListener = new ComponentListener(this){
            final /* synthetic */ RiderPaneWithTitle this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(@Nullable ComponentEvent e) {
                WindowStateService.getInstance((Project)RiderPaneWithTitle.access$getProject$p(this.this$0)).putSize(this.this$0.getSizeKey(), this.this$0.getSize());
            }

            public void componentMoved(@Nullable ComponentEvent e) {
            }

            public void componentShown(@Nullable ComponentEvent e) {
            }

            public void componentHidden(@Nullable ComponentEvent e) {
            }
        };
        this.addComponentListener(componentListener);
        this.lifetime.onTermination((Function0)new Function0<Unit>(this, componentListener){
            final /* synthetic */ RiderPaneWithTitle this$0;
            final /* synthetic */ initPane.resizeListener.1 $resizeListener;
            {
                this.this$0 = $receiver;
                this.$resizeListener = $resizeListener;
                super(0);
            }

            public final void invoke() {
                this.this$0.removeComponentListener(this.$resizeListener);
            }
        });
        JComponent jComponent = new JPanel((LayoutManager)new MigLayout("fillx, novisualpadding, ins 0, gap 0, ay center", "[grow][min!]"));
        Serializable serializable = jComponent;
        RiderPaneWithTitle riderPaneWithTitle = this;
        boolean bl = false;
        serializable.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        serializable.setOpaque(false);
        Object object = new JLabel(this.titleName);
        JLabel jLabel = object;
        JPanel jPanel = serializable;
        boolean bl2 = false;
        jLabel.setFont((Font)JBUI.Fonts.label().asBold());
        jPanel.add((Component)object);
        object = this.j();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Rider.Debugger.Popup", (ActionGroup)object, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        jLabel = actionToolbar;
        jLabel.setTargetComponent((JComponent)serializable);
        jLabel.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        JComponent jComponent2 = jLabel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        JComponent jComponent3 = jComponent2;
        jComponent3.setOpaque(false);
        jComponent3.setBorder((Border)JBUI.Borders.empty());
        serializable.add(jComponent3, "wmin pref, gaptop " + JBUI.scale((int)1) + "px, hmin pref");
        riderPaneWithTitle.setTitle(jComponent);
        jComponent = new JPanel((LayoutManager)new MigLayout("fillx, novisualpadding, ins 0, gap 0"));
        serializable = jComponent;
        riderPaneWithTitle = this;
        bl = false;
        serializable.setBackground((Color)RiderTheme.Companion.getContrastHeaderBackground());
        serializable.add(this.getTitle(), "growx");
        riderPaneWithTitle.setHeader((JPanel)jComponent);
        this.add((Component)this.getHeader(), "growx");
        jComponent = this.createContentPane();
        jComponent.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)4, (int)4));
        this.add((Component)jComponent, "grow");
        serializable = new LineBorder(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)2, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder jBEmptyBorder2 = jBEmptyBorder;
        Border border = JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)0, (int)0, (int)1, (int)0), (Border)((Border)jBEmptyBorder2), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"merge(...)");
        object = border;
        this.state.getPinned().advise(this.lifetime, (Function1)new Function1<Boolean, Unit>(this, jBEmptyBorder2, (LineBorder)serializable, (Border)object){
            final /* synthetic */ RiderPaneWithTitle this$0;
            final /* synthetic */ JBEmptyBorder $baseBorder;
            final /* synthetic */ LineBorder $lineBorder;
            final /* synthetic */ Border $unpinnedBorder;
            {
                this.this$0 = $receiver;
                this.$baseBorder = $baseBorder;
                this.$lineBorder = $lineBorder;
                this.$unpinnedBorder = $unpinnedBorder;
                super(1);
            }

            public final void invoke(boolean it) {
                if (it) {
                    this.this$0.getHeader().setOpaque(true);
                    this.this$0.getHeader().setBorder((Border)this.$baseBorder);
                    this.this$0.setBorder(this.$lineBorder);
                } else {
                    this.this$0.getHeader().setOpaque(false);
                    this.this$0.getHeader().setBorder(this.$unpinnedBorder);
                    this.this$0.setBorder((Border)JBUI.Borders.empty());
                }
            }
        });
    }

    private final DefaultActionGroup j() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.addAll((Collection)this.getAdditionalToolbarActions());
        Lifetime lifetime2 = this.lifetime;
        defaultActionGroup.add((AnAction)new ExceptionPopupResumeAction(this, lifetime2){
            final /* synthetic */ RiderPaneWithTitle this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.actionPerformed(e);
                this.this$0.getState().getResumeSessionSignal().fire((Object)Unit.INSTANCE);
            }

            public void update(@NotNull AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                event.getPresentation().setText(RiderActionsBundle.Companion.message("RiderPaneWithTitle.action.resume.text", new Object[0]));
                super.update(event);
            }

            public boolean displayTextInToolbar() {
                return true;
            }
        });
        defaultActionGroup.addSeparator();
        defaultActionGroup.add(ComponentFactories.Companion.getAnAction(null, AllIcons.Actions.Close, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderPaneWithTitle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getState().getHideSignal().fire((Object)Unit.INSTANCE);
            }
        }));
        return defaultActionGroup;
    }

    @NotNull
    protected abstract List<AnAction> getAdditionalToolbarActions();

    @NotNull
    protected abstract JComponent createContentPane();

    @NotNull
    protected JBDimension getPaneMinimumSize() {
        return new JBDimension(500, 260);
    }

    private final Dimension j() {
        JBDimension jBDimension = this.getPaneMinimumSize();
        Dimension dimension = WindowStateService.getInstance((Project)this.project).getSize(this.getSizeKey());
        if (dimension == null) {
            return (Dimension)jBDimension;
        }
        Dimension dimension2 = dimension;
        if (dimension2.getHeight() < (double)jBDimension.height() || dimension2.getWidth() < (double)jBDimension.width()) {
            return (Dimension)jBDimension;
        }
        return dimension2;
    }

    @NotNull
    protected String getSizeKey() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static final /* synthetic */ Project access$getProject$p(RiderPaneWithTitle $this) {
        return $this.project;
    }
}

