/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.components.ExceptionGutterRenderer;
import com.jetbrains.rider.debugger.components.RiderDebugBalloon;
import com.jetbrains.rider.debugger.components.RiderExceptionPane;
import com.jetbrains.rider.debugger.components.RiderPaneWithTitle;
import com.jetbrains.rider.debugger.exception.model.CompositeExceptionModel;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/components/ExceptionBalloon;", "Lcom/jetbrains/rider/debugger/components/RiderDebugBalloon;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "exceptionModel", "Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "project", "Lcom/intellij/openapi/project/Project;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/editor/LogicalPosition;Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "createPanel", "Lcom/jetbrains/rider/debugger/components/RiderPaneWithTitle;", "Companion", "intellij.rider"})
public final class ExceptionBalloon
extends RiderDebugBalloon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CompositeExceptionModel exceptionModel;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Unit> THROWN_EXCEPTION_HIGHLIGHTER;

    public ExceptionBalloon(@NotNull EditorImpl editor2, @NotNull LogicalPosition logicalPosition, @NotNull CompositeExceptionModel exceptionModel, @NotNull Project project, @NotNull XDebugSession debugSession, @NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"exceptionModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        super(editor2, logicalPosition, project, debugSession, parentLifetime);
        this.editor = editor2;
        this.exceptionModel = exceptionModel;
        MarkupModelEx markupModelEx = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        final MarkupModelEx markupModelEx2 = markupModelEx;
        Icon icon2 = AllIcons.Debugger.Db_exception_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_exception_breakpoint");
        Icon icon3 = icon2;
        int n = this.editor.getDocument().getLineStartOffset(logicalPosition.line);
        RangeHighlighterEx rangeHighlighterEx = markupModelEx2.addRangeHighlighterAndChangeAttributes(n, n, 1000, null, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> ExceptionBalloon.j((Function1)new Function1<RangeHighlighterEx, Unit>(icon3, this){
            final /* synthetic */ Icon $icon;
            final /* synthetic */ ExceptionBalloon this$0;
            {
                this.$icon = $icon;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(RangeHighlighterEx it) {
                it.setGutterIconRenderer((GutterIconRenderer)new ExceptionGutterRenderer(this.$icon, ExceptionBalloon.access$getExceptionModel$p(this.this$0).getExceptionTypeString(), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this.this$0){

                    public final void invoke() {
                        ((ExceptionBalloon)this.receiver).show();
                    }
                })));
                it.putUserData(ExceptionBalloon.Companion.getTHROWN_EXCEPTION_HIGHLIGHTER(), (Object)Unit.INSTANCE);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        final RangeHighlighterEx rangeHighlighterEx2 = rangeHighlighterEx;
        this.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                markupModelEx2.removeHighlighter((RangeHighlighter)rangeHighlighterEx2);
            }
        });
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @Override
    @NotNull
    protected RiderPaneWithTitle createPanel() {
        return new RiderExceptionPane(this.exceptionModel, this.getState(), this.getProject(), this.getLifetime());
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    public static final /* synthetic */ CompositeExceptionModel access$getExceptionModel$p(ExceptionBalloon $this) {
        return $this.exceptionModel;
    }

    static {
        Logger logger2 = Logger.getInstance(ExceptionBalloon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
        THROWN_EXCEPTION_HIGHLIGHTER = new Key("ExceptionBalloon_THROWN_EXCEPTION_HIGHLIGHTER");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/debugger/components/ExceptionBalloon$Companion;", "", "()V", "THROWN_EXCEPTION_HIGHLIGHTER", "Lcom/intellij/openapi/util/Key;", "", "getTHROWN_EXCEPTION_HIGHLIGHTER", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Unit> getTHROWN_EXCEPTION_HIGHLIGHTER() {
            return THROWN_EXCEPTION_HIGHLIGHTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

