/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint.validation;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.validation.RiderBreakpointDocumentRangeShifters;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016J\u001c\u0010\r\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/validation/RiderBreakpointValidationBreakpointsListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointListener;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "breakpointManager", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointManager;", "kotlin.jvm.PlatformType", "breakpointAdded", "", "breakpoint", "breakpointChanged", "breakpointRemoved", "intellij.rider"})
public final class RiderBreakpointValidationBreakpointsListener
implements XBreakpointListener<XBreakpoint<? extends XBreakpointProperties<?>>> {
    @NotNull
    private final Project project;
    private final XLineBreakpointManager breakpointManager;

    public RiderBreakpointValidationBreakpointsListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.project).getBreakpointManager();
        Intrinsics.checkNotNull((Object)xBreakpointManager, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
        this.breakpointManager = ((XBreakpointManagerImpl)xBreakpointManager).getLineBreakpointManager();
    }

    public void breakpointAdded(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(((XLineBreakpoint)breakpoint).getFileUrl());
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Document document2 = (Document)ActionsKt.runReadAction((Function0)((Function0)new Function0<Document>(virtualFile3){
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$virtualFile = $virtualFile;
                super(0);
            }

            @Nullable
            public final Document invoke() {
                return FileDocumentManager.getInstance().getDocument(this.$virtualFile);
            }
        }));
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document3, (Project)this.project);
        if (documentSynchronizer == null) {
            return;
        }
        DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).registerShifter$intellij_rider(virtualFile3, documentSynchronizer2, documentSynchronizer2.getDocumentLifetime());
    }

    public void breakpointRemoved(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(((XLineBreakpoint)breakpoint).getFileUrl());
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Document document2 = (Document)ActionsKt.runReadAction((Function0)((Function0)new Function0<Document>(virtualFile3){
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$virtualFile = $virtualFile;
                super(0);
            }

            @Nullable
            public final Document invoke() {
                return FileDocumentManager.getInstance().getDocument(this.$virtualFile);
            }
        }));
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        if (CollectionsKt.any((Iterable)this.breakpointManager.getDocumentBreakpoints(document3))) {
            return;
        }
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).removeRangeShifter$intellij_rider(virtualFile3);
    }

    public void breakpointChanged(@NotNull XBreakpoint<? extends XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!(breakpoint instanceof XLineBreakpoint) || !(((XLineBreakpoint)breakpoint).getProperties() instanceof DotNetLineBreakpointProperties)) {
            return;
        }
        RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).revalidateShifters$intellij_rider();
    }
}

