/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.breakpoint.dialogs.DotNetExceptionNode;
import com.jetbrains.rider.debugger.breakpoint.dialogs.DotNetExceptionsTree;
import com.jetbrains.rider.model.ProjectExceptionModel;
import com.jetbrains.rider.model.PsiDebuggerHostModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0005H\u0014J\b\u0010\u0014\u001a\u00020\u0005H\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "dialogTitle", "", "addEntityMessage", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;Ljava/lang/String;Ljava/lang/String;)V", "filterTextField", "Lcom/intellij/ui/SearchTextField;", "panel", "Ljavax/swing/JPanel;", "selectedExceptions", "", "Lcom/jetbrains/rider/model/ProjectExceptionModel;", "tree", "Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetExceptionsTree;", "createCenterPanel", "createNorthPanel", "getSelectedModels", "", "j", "", "view", "j", "j", "exceptions", "N", "w", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetNewExceptionBreakpointsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetNewExceptionBreakpointsDialog.kt\ncom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,149:1\n94#2:150\n*S KotlinDebug\n*F\n+ 1 DotNetNewExceptionBreakpointsDialog.kt\ncom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog\n*L\n41#1:150\n*E\n"})
public final class DotNetNewExceptionBreakpointsDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String addEntityMessage;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final SearchTextField filterTextField;
    @NotNull
    private final DotNetExceptionsTree tree;
    @NotNull
    private final Set<ProjectExceptionModel> selectedExceptions;
    @NotNull
    private static final Logger logger;

    public DotNetNewExceptionBreakpointsDialog(@NotNull Project project, @Nullable JComponent parentComponent, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.DialogMessage @NotNull String addEntityMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)addEntityMessage, (String)"addEntityMessage");
        super(project, (Component)parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.project = project;
        this.addEntityMessage = addEntityMessage;
        this.panel = new JPanel();
        this.filterTextField = new SearchTextField(false);
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        this.tree = new DotNetExceptionsTree((Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable));
        this.selectedExceptions = new LinkedHashSet();
        this.setTitle(dialogTitle);
        this.panel.setLayout(new GridLayout(0, 1));
        this.panel.setBorder((Border)JBUI.Borders.empty());
        this.panel.setMinimumSize(new Dimension(400, 400));
        this.j();
        super.init();
        this.filterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = filterTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                tree.updateNodesFilter(string2);
            }
        });
        this.N();
        this.w();
        this.setOKActionEnabled(false);
        this.tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof DotNetExceptionNode) {
                    if (((DotNetExceptionNode)node).isChecked()) {
                        selectedExceptions.add(((DotNetExceptionNode)node).getExceptionModel());
                        this.setOKActionEnabled(true);
                    } else {
                        selectedExceptions.remove(((DotNetExceptionNode)node).getExceptionModel());
                        if (selectedExceptions.isEmpty()) {
                            this.setOKActionEnabled(false);
                        }
                    }
                    this.w();
                }
            }
        });
    }

    public /* synthetic */ DotNetNewExceptionBreakpointsDialog(Project project, JComponent jComponent, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = RiderDebuggerBundle.Companion.message("DotNetNewExceptionBreakpointsDialog.dialog.title.add.clr.exception.breakpoints", new Object[0]);
        }
        if ((n & 8) != 0) {
            string2 = RiderDebuggerBundle.Companion.message("debugger.new.exception.breakpoint.entry.message", new Object[0]);
        }
        this(project, jComponent, string, string2);
    }

    private final void w() {
        this.getOKAction().putValue("Name", this.addEntityMessage + " (" + this.selectedExceptions.size() + ")");
    }

    private final void N() {
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        LifetimeDefinition lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable);
        SourceExKt.adviseOnce((ISource)((ISource)PsiDebuggerHostModel_PregeneratedKt.getPsiDebuggerHostModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getEvaluateExceptionInheritors().start((Lifetime)lifetimeDefinition, (Object)Unit.INSTANCE).getResult()), (Lifetime)((Lifetime)lifetimeDefinition), (Function1)((Function1)new Function1<RdTaskResult<? extends List<? extends ProjectExceptionModel>>, Unit>(lifetimeDefinition, this){
            final /* synthetic */ LifetimeDefinition $callLifetimeDefinition;
            final /* synthetic */ DotNetNewExceptionBreakpointsDialog this$0;
            {
                this.$callLifetimeDefinition = $callLifetimeDefinition;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdTaskResult<? extends List<ProjectExceptionModel>> result2) {
                Intrinsics.checkNotNullParameter(result2, (String)"result");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$callLifetimeDefinition, (boolean)false, (int)1, null);
                RdTaskResult<? extends List<ProjectExceptionModel>> rdTaskResult = result2;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    DotNetNewExceptionBreakpointsDialog.access$setTreePanel(this.this$0, (List)((RdTaskResult.Success)result2).getValue());
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    LoggerKt.error((Logger)DotNetNewExceptionBreakpointsDialog.access$getLogger$cp(), (Throwable)((Throwable)((RdTaskResult.Fault)result2).getError()));
                    this.this$0.close(-1);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    this.this$0.close(1);
                }
            }
        }));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @NotNull
    protected JComponent createNorthPanel() {
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        borderLayoutPanel.addToCenter((Component)this.filterTextField);
        return (JComponent)borderLayoutPanel;
    }

    @NotNull
    public final List<ProjectExceptionModel> getSelectedModels() {
        return CollectionsKt.toList((Iterable)this.selectedExceptions);
    }

    private final void j() {
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 0, 4, null);
        jBLoadingPanel.startLoading();
        this.j((JComponent)jBLoadingPanel);
    }

    private final void j(List<ProjectExceptionModel> list2) {
        this.tree.updateExceptions(list2);
        JBScrollPane jBScrollPane = new JBScrollPane((Component)((Object)this.tree));
        this.j((JComponent)jBScrollPane);
        this.filterTextField.requestFocus();
    }

    private final void j(JComponent jComponent) {
        this.panel.removeAll();
        this.panel.add((Component)jComponent, "North");
        this.panel.validate();
        this.panel.repaint();
    }

    public static final /* synthetic */ void access$setTreePanel(DotNetNewExceptionBreakpointsDialog $this, List exceptions) {
        $this.j(exceptions);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean bl = false;
        logger = LoggerKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DotNetNewExceptionBreakpointsDialog.class));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/dialogs/DotNetNewExceptionBreakpointsDialog$Companion;", "", "()V", "logger", "Lcom/jetbrains/rd/util/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

