/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointFiltersPanel;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.debugger.breakpoint.IDotNetLineBreakpointPopupActionsProvider;
import com.jetbrains.rider.debugger.breakpoint.IDotNetVerifiableBreakpointType;
import com.jetbrains.rider.debugger.breakpoint.RiderBreakpointCompoundPanel;
import com.jetbrains.rider.debugger.breakpoint.RiderBreakpointHost;
import com.jetbrains.rider.debugger.breakpoint.validation.RiderBreakpointDocumentRangeShifters;
import com.jetbrains.rider.model.BreakpointVariantModel;
import com.jetbrains.rider.model.BreakpointVariantModelBase;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00042345B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0\u0018R\b\u0012\u0004\u0012\u00020\u00020\u00010\u00120\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J4\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0\u0018R\b\u0012\u0004\u0012\u00020\u00020\u00010\u00120\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0015J(\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u001f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020!\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\"\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020!\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010#\u001a\u00020\u0002H\u0016J(\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020!2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0018\u0010*\u001a\u00020\u00062\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010!H\u0016J \u0010+\u001a\u0004\u0018\u00010,2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010-\u001a\u0004\u0018\u00010.2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\b\u0010/\u001a\u00020\u000eH\u0016J&\u00100\u001a\u00020\n2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u00101\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u00066"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/IDotNetVerifiableBreakpointType;", "()V", "id", "", "title", "(Ljava/lang/String;Ljava/lang/String;)V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "computeVariants", "", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "computeVariantsAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "position", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "j", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBreakpointProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "createCustomRightPropertiesPanel", "createProperties", "getAdditionalPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "breakpoint", "currentSession", "Lcom/intellij/xdebugger/XDebugSession;", "getDisplayText", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getPriority", "lineShouldBeChanged", "newLine", "Companion", "DotNetAllBreakpointsVariant", "DotNetBreakpointVariant", "Util", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,297:1\n1603#2,9:298\n1855#2:307\n1856#2:309\n1612#2:310\n1747#2,3:311\n1855#2,2:314\n1#3:308\n13#4:316\n13#5:317\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType\n*L\n161#1:298,9\n161#1:307\n161#1:309\n161#1:310\n167#1:311,3\n215#1:314,2\n161#1:308\n72#1:316\n72#1:317\n*E\n"})
public class DotNetLineBreakpointType
extends XLineBreakpointType<DotNetLineBreakpointProperties>
implements IDotNetVerifiableBreakpointType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "DotNet Breakpoints";
    @NotNull
    private static final Logger logger;

    protected DotNetLineBreakpointType(@NotNull String id2, @Nls @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        super(id2, title2);
    }

    public DotNetLineBreakpointType() {
        this(ID, Util.INSTANCE.getTitle());
    }

    @NotNull
    public DotNetLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (DotNetLineBreakpointProperties)((Object)ActionsKt.runReadAction((Function0)((Function0)new Function0<DotNetLineBreakpointProperties>(file2, line){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ int $line;
            {
                this.$file = $file;
                this.$line = $line;
                super(0);
            }

            @NotNull
            public final DotNetLineBreakpointProperties invoke() {
                Document document2 = FileDocumentManager.getInstance().getDocument(this.$file);
                if (document2 == null) {
                    return new DotNetLineBreakpointProperties(false, 0, null, true, 7, null);
                }
                Document document3 = document2;
                int n = document3.getLineStartOffset(this.$line);
                String string = this.$file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return DotNetLineBreakpointProperties.Companion.create$default(DotNetLineBreakpointProperties.Companion, string, null, n, n, false, 0, null, true, 112, null);
            }
        })));
    }

    @NotNull
    public DotNetLineBreakpointProperties createProperties() {
        return new DotNetLineBreakpointProperties(false, 0, null, true, 7, null);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        logger.trace("Verifying possibility of breakpoint insertion for " + file2.getName() + ":" + line);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile != null) {
            logger.trace("Found psi file " + psiFile);
            RiderBreakpointHost riderBreakpointHost = RiderBreakpointHost.Companion.getInstance(project);
            return riderBreakpointHost.isSupportedLanguage(psiFile, line);
        }
        logger.trace("Cannot find psi file for " + file2.getName() + ":" + line + ", return false");
        return false;
    }

    public boolean lineShouldBeChanged(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, int newLine, @NotNull Project project) {
        List list2;
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(breakpoint.getFileUrl());
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = (DotNetLineBreakpointProperties)breakpoint.getProperties();
        if (dotNetLineBreakpointProperties == null) {
            return false;
        }
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties2 = dotNetLineBreakpointProperties;
        Deferred deferred = LifetimeCoroutineUtilKt.async$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, virtualFile3, newLine, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ int $newLine;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                this.$newLine = $newLine;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.create((VirtualFile)this.$virtualFile, (int)this.$newLine);
                        Intrinsics.checkNotNullExpressionValue((Object)xSourcePositionImpl, (String)"create(...)");
                        this.label = 1;
                        Object object3 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, (XSourcePosition)xSourcePositionImpl, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Duration duration = Util.INSTANCE.getWAIT_FOR_VARIANTS_DURATION$intellij_rider();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-WAIT_FOR_VARIANTS_DURATION>(...)");
        if (!ExtensionsKt.pumpMessages((Duration)duration, (Function0)((Function0)new Function0<Boolean>((Deferred<? extends List<? extends DotNetBreakpointVariant>>)deferred){
            final /* synthetic */ Deferred<List<DotNetBreakpointVariant>> $variantsJob;
            {
                this.$variantsJob = $variantsJob;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$variantsJob.isCompleted();
            }
        }))) {
            logger.warn("Failed to wait for variants computation (file: " + virtualFile3 + ", line: " + newLine + ")");
            return false;
        }
        try {
            list2 = (List)deferred.getCompleted();
        }
        catch (Throwable throwable) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = list2;
        if (list3.isEmpty()) {
            return false;
        }
        dotNetLineBreakpointProperties2.setVariant((DotNetBreakpointVariant)((Object)CollectionsKt.first((List)list3)));
        return true;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new DotNetDebuggerEditorsProvider(project, breakpoint);
    }

    @RequiresBackgroundThread
    @NotNull
    public List<DotNetBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, sourcePosition, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ XSourcePosition $sourcePosition;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$sourcePosition = $sourcePosition;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, this.$sourcePosition, (Continuation)this);
                        Object object4 = object3;
                        if (object3 != object2) return (List)object4;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return (List)object4;
                        }
                        catch (CancellationException cancellationException) {
                            throw cancellationException;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new CancellationException();
                        }
                        catch (Throwable throwable) {
                            DotNetLineBreakpointType.access$getLogger$cp().error(throwable);
                            throw throwable;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public Promise<List<XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.computeVariantsAsync(project, UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), position);
    }

    @NotNull
    public final Promise<List<XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project, @NotNull Lifetime lifetime2, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return RdCoroutinesUtilKt.toPromise((Deferred)LifetimeCoroutineUtilKt.async$default((Lifetime)lifetime2, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends DotNetBreakpointVariant>>, Object>(this, project, position, null){
            int label;
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ XSourcePosition $position;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$position = $position;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, this.$project, this.$position, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends DotNetBreakpointVariant>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null));
    }

    /*
     * Unable to fully structure code
     */
    private final Object j(Project var1_1, XSourcePosition var2_2, Continuation<? super List<? extends DotNetBreakpointVariant>> var3_3) throws RuntimeException {
        if (!(var3_3 instanceof computeVariantsInternal.1)) ** GOTO lbl-1000
        var22_4 = var3_3;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var22_4 = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DotNetLineBreakpointType this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DotNetLineBreakpointType.access$computeVariantsInternal(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        var21_5 = var22_4.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var22_4.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var21_5);
                var22_4.L$0 = this;
                var22_4.L$1 = var1_1;
                var22_4.L$2 = var2_2;
                var22_4.label = 1;
                v0 = RiderBreakpointHost.Companion.getInstance(var1_1).requestVariantsComputation(var2_2, (Continuation<? super List<? extends BreakpointVariantModelBase>>)var22_4);
                if (v0 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                var2_2 = (XSourcePosition)var22_4.L$2;
                var1_1 = (Project)var22_4.L$1;
                this = (DotNetLineBreakpointType)var22_4.L$0;
                ResultKt.throwOnFailure((Object)var21_5);
                v0 = var21_5;
lbl26:
                // 2 sources

                var4_7 = (List)v0;
                var6_8 = var4_7;
                var7_10 = false;
                var8_12 = var6_8;
                var9_14 = new ArrayList<E>();
                var10_15 = false;
                var11_17 = var8_12;
                var12_18 = false;
                var13_19 = var11_17.iterator();
                while (var13_19.hasNext()) {
                    var15_21 = var14_20 = var13_19.next();
                    var16_22 = false;
                    var17_23 = (BreakpointVariantModelBase)var15_21;
                    var18_24 = false;
                    if (!(var17_23 instanceof BreakpointVariantModel)) {
                        v1 = null;
                    } else {
                        v2 = ((BreakpointVariantModel)var17_23).getText();
                        v3 = ((BreakpointVariantModel)var17_23).getContainingFunctionPresentation();
                        v4 = new TextRange(((BreakpointVariantModel)var17_23).getStartOffset(), ((BreakpointVariantModel)var17_23).getEndOffset());
                        v5 = var2_2.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getFile(...)");
                        v1 = new DotNetBreakpointVariant(v2, v3, v4, v5, var2_2.getLine(), ((BreakpointVariantModel)var17_23).getDocumentVersion(), ((BreakpointVariantModel)var17_23).isMultiMethodBreakpoint(), var1_1);
                    }
                    if (v1 == null) continue;
                    var19_25 = v1;
                    var20_26 = false;
                    var9_14.add(var19_25);
                }
                var5_27 = CollectionsKt.toMutableList((Collection)((List)var9_14));
                if (var5_27.size() <= 1) ** GOTO lbl73
                var7_11 = var5_27;
                var8_13 = false;
                if (!(var7_11 instanceof Collection) || !((Collection)var7_11).isEmpty()) ** GOTO lbl62
                v6 = false;
                ** GOTO lbl69
lbl62:
                // 2 sources

                for (E var10_16 : var7_11) {
                    var11_17 = (DotNetBreakpointVariant)var10_16;
                    var12_18 = false;
                    if (!var11_17.isMultiMethodBreakpoint()) continue;
                    v6 = true;
                    ** GOTO lbl69
                }
                v6 = false;
lbl69:
                // 3 sources

                var6_9 = v6;
                v7 = (DotNetBreakpointVariant)CollectionsKt.firstOrNull((List)var5_27);
                var5_27.add(new DotNetAllBreakpointsVariant(var2_2, CollectionsKt.toList((Iterable)var5_27), v7 != null ? v7.getContainingFunctionDescription() : null, var6_9 != false, var1_1));
lbl73:
                // 2 sources

                return var5_27;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        TextRange textRange = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getTextRange();
        if (!Intrinsics.areEqual((Object)textRange, (Object)TextRange.EMPTY_RANGE)) {
            return textRange;
        }
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new DotNetBreakpointFiltersPanel();
    }

    public int getPriority() {
        return -1;
    }

    @NotNull
    public String getDisplayText(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            return "";
        }
        String string = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getContainingFunctionPresentation();
        Object object = (Object[])string;
        if (object == null || object.length() == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = breakpoint.getLine() + 1;
            String string2 = breakpoint.getPresentableFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableFilePath(...)");
            char[] cArray = new char[]{'/', '\\'};
            String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) {
                string3 = "";
            }
            objectArray[1] = string3;
            object = XDebuggerBundle.message((String)"xbreakpoint.default.display.text", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message(...)");
            return object;
        }
        object = new Object[]{breakpoint.getLine() + 1, string};
        return RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.line.in.function", object);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RiderBreakpointCompoundPanel(project);
    }

    @NotNull
    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @Nullable XDebugSession currentSession) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        Iterable iterable = new ArrayList();
        List list2 = iterable;
        boolean bl = false;
        List list3 = super.getAdditionalPopupMenuActions(breakpoint, currentSession);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getAdditionalPopupMenuActions(...)");
        list2.addAll(list3);
        List list4 = iterable;
        iterable = IDotNetLineBreakpointPopupActionsProvider.Companion.getEP().getExtensionList();
        boolean bl2 = false;
        for (Object e : iterable) {
            IDotNetLineBreakpointPopupActionsProvider iDotNetLineBreakpointPopupActionsProvider = (IDotNetLineBreakpointPopupActionsProvider)e;
            boolean bl3 = false;
            list4.addAll((Collection)iDotNetLineBreakpointPopupActionsProvider.getCustomPopupMenuActions(breakpoint, currentSession));
        }
        return list4;
    }

    public static final /* synthetic */ Object access$computeVariantsInternal(DotNetLineBreakpointType $this, Project project, XSourcePosition position, Continuation $completion) {
        return $this.j(project, position, (Continuation<? super List<? extends DotNetBreakpointVariant>>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetLineBreakpointType.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$Companion;", "", "()V", "ID", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u00100\u0007R\b\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u0006\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\tH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\u0012\u0012\u00100\u0007R\b\u0012\u0004\u0012\u00020\t0\bj\u0002`\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "variantsList", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetBreakpointVariant;", "containingFunctionDescription", "", "isMultiMethodBreakpoint", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;Lcom/intellij/xdebugger/XSourcePosition;Ljava/util/List;Ljava/lang/String;ZLcom/intellij/openapi/project/Project;)V", "createProperties", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getIcon", "Ljavax/swing/Icon;", "isMultiVariant", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1549#2:298\n1620#2,3:299\n1549#2:302\n1620#2,3:303\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetAllBreakpointsVariant\n*L\n285#1:298\n285#1:299,3\n286#1:302\n286#1:303,3\n*E\n"})
    public final class DotNetAllBreakpointsVariant
    extends DotNetBreakpointVariant {
        @NotNull
        private final XSourcePosition position;
        @NotNull
        private final List<XLineBreakpointType.XLineBreakpointVariant> variantsList;

        public DotNetAllBreakpointsVariant(@NotNull XSourcePosition position, @Nls @Nullable List<? extends XLineBreakpointType.XLineBreakpointVariant> variantsList, String containingFunctionDescription, @NotNull boolean isMultiMethodBreakpoint, Project project) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter(variantsList, (String)"variantsList");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.all.breakpoints.message", new Object[0]);
            VirtualFile virtualFile2 = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            super(string, containingFunctionDescription, null, virtualFile2, position.getLine(), null, isMultiMethodBreakpoint, project);
            this.position = position;
            this.variantsList = variantsList;
        }

        @Override
        @NotNull
        public DotNetLineBreakpointProperties createProperties() {
            Collection<Integer> collection;
            boolean bl;
            Collection<Integer> collection2;
            XLineBreakpointType.XLineBreakpointVariant xLineBreakpointVariant;
            VirtualFile virtualFile2 = this.position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            VirtualFile virtualFile3 = virtualFile2;
            String string = virtualFile3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Iterable iterable = this.variantsList;
            String string2 = this.getContainingFunctionDescription();
            String string3 = string;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl3 = false;
            for (Object t : iterable2) {
                xLineBreakpointVariant = (XLineBreakpointType.XLineBreakpointVariant)t;
                collection2 = collection3;
                bl = false;
                TextRange textRange = xLineBreakpointVariant.getHighlightRange();
                collection2.add(textRange != null ? textRange.getStartOffset() : -1);
            }
            collection2 = (List)collection3;
            iterable = this.variantsList;
            bl2 = false;
            iterable2 = iterable;
            collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            bl3 = false;
            for (Object t : iterable2) {
                xLineBreakpointVariant = (XLineBreakpointType.XLineBreakpointVariant)t;
                collection = collection3;
                bl = false;
                TextRange textRange = xLineBreakpointVariant.getHighlightRange();
                collection.add(textRange != null ? textRange.getEndOffset() : -1);
            }
            collection = (List)collection3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 112;
            BreakpointHitCountMode breakpointHitCountMode = null;
            int n2 = 0;
            boolean bl4 = false;
            Collection<Integer> collection4 = collection;
            Collection<Integer> collection5 = collection2;
            String string4 = string2;
            String string5 = string3;
            return new DotNetLineBreakpointProperties(string5, string4, (List)collection5, (List)collection4, bl4, n2, breakpointHitCountMode, n, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = AllIcons.Debugger.MultipleBreakpoints;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"MultipleBreakpoints");
            return icon2;
        }

        @Override
        @Nullable
        public TextRange getHighlightRange() {
            return null;
        }

        public boolean isMultiVariant() {
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002BO\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\bH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "breakpointText", "", "containingFunctionDescription", "initialTextRange", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "version", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "isMultiMethodBreakpoint", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/vfs/VirtualFile;ILcom/jetbrains/rd/ide/model/AbstractDocumentVersion;ZLcom/intellij/openapi/project/Project;)V", "getContainingFunctionDescription", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "getLine", "()I", "getVersion", "()Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "j", "textRange", "createProperties", "getHighlightRange", "getIcon", "Ljavax/swing/Icon;", "getText", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointType.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
    public class DotNetBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointVariant {
        @NotNull
        private final String breakpointText;
        @Nullable
        private final String containingFunctionDescription;
        @Nullable
        private final TextRange initialTextRange;
        @NotNull
        private final VirtualFile file;
        private final int line;
        @Nullable
        private final AbstractDocumentVersion version;
        private final boolean isMultiMethodBreakpoint;
        @NotNull
        private final Project project;

        public DotNetBreakpointVariant(@Nls @Nullable String breakpointText, @Nullable String containingFunctionDescription, @NotNull TextRange initialTextRange, VirtualFile file2, @Nullable int line, AbstractDocumentVersion version, @NotNull boolean isMultiMethodBreakpoint, Project project) {
            Intrinsics.checkNotNullParameter((Object)breakpointText, (String)"breakpointText");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super((XLineBreakpointType)DotNetLineBreakpointType.this);
            this.breakpointText = breakpointText;
            this.containingFunctionDescription = containingFunctionDescription;
            this.initialTextRange = initialTextRange;
            this.file = file2;
            this.line = line;
            this.version = version;
            this.isMultiMethodBreakpoint = isMultiMethodBreakpoint;
            this.project = project;
        }

        @Nullable
        public final String getContainingFunctionDescription() {
            return this.containingFunctionDescription;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final int getLine() {
            return this.line;
        }

        @Nullable
        public final AbstractDocumentVersion getVersion() {
            return this.version;
        }

        public final boolean isMultiMethodBreakpoint() {
            return this.isMultiMethodBreakpoint;
        }

        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        @Nullable
        public TextRange getHighlightRange() {
            TextRange textRange;
            TextRange textRange2 = this.initialTextRange;
            if (textRange2 != null) {
                TextRange textRange3 = textRange2;
                boolean bl = false;
                textRange = this.j(textRange3);
            } else {
                textRange = null;
            }
            return textRange;
        }

        @NotNull
        public DotNetLineBreakpointProperties createProperties() {
            if (this.initialTextRange == null) {
                return new DotNetLineBreakpointProperties(false, 0, null, false, 15, null);
            }
            TextRange textRange = this.j(this.initialTextRange);
            String string = this.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return DotNetLineBreakpointProperties.Companion.create$default(DotNetLineBreakpointProperties.Companion, string, this.containingFunctionDescription, textRange.getStartOffset(), textRange.getEndOffset(), false, 0, null, this.isMultiMethodBreakpoint, 112, null);
        }

        @NotNull
        public String getText() {
            return this.breakpointText;
        }

        private final TextRange j(TextRange textRange) {
            AbstractDocumentVersion abstractDocumentVersion = this.version;
            if (abstractDocumentVersion == null) {
                return textRange;
            }
            AbstractDocumentVersion abstractDocumentVersion2 = abstractDocumentVersion;
            IDocumentRangeShifter iDocumentRangeShifter = RiderBreakpointDocumentRangeShifters.Companion.getInstance(this.project).getShifter(this.file);
            if (iDocumentRangeShifter == null || (iDocumentRangeShifter = iDocumentRangeShifter.shiftRange(abstractDocumentVersion2, textRange, false, false, false)) == null) {
                iDocumentRangeShifter = textRange;
            }
            return iDocumentRangeShifter;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$Util;", "", "()V", "Title", "", "getTitle", "()Ljava/lang/String;", "WAIT_FOR_VARIANTS_DURATION", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getWAIT_FOR_VARIANTS_DURATION$intellij_rider", "()Ljava/time/Duration;", "intellij.rider"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @Nls
        @NotNull
        private static final String Title = RiderDebuggerBundle.Companion.message("DotNetLineBreakpointType.net.line.breakpoints", new Object[0]);
        private static final Duration WAIT_FOR_VARIANTS_DURATION = Duration.ofSeconds(5L);

        private Util() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        public final Duration getWAIT_FOR_VARIANTS_DURATION$intellij_rider() {
            return WAIT_FOR_VARIANTS_DURATION;
        }
    }
}

