/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import com.jetbrains.rider.model.debuggerWorker.BreakpointElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001;BU\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB-\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\b\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00062\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.J\b\u0010/\u001a\u00020\u0000H\u0016J\b\u00100\u001a\u0004\u0018\u000101J\u0010\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u0000H\u0016J\u0012\u00104\u001a\u00020*2\n\u00105\u001a\u000606R\u000207J\b\u00108\u001a\u00020\u0003H\u0016J\b\u00109\u001a\u00020*H\u0002J\b\u0010:\u001a\u00020*H\u0002R \u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00168GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0012\"\u0004\b!\u0010\u0014R\u001e\u0010\"\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetBreakpointProperties;", "canonicalDocumentPath", "", "containingFunctionPresentation", "initStartOffsets", "", "", "initEndOffsets", "hitCountFilterEnabled", "", "hitCount", "hitCountMode", "Lcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZILcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;)V", "multiMethodBreakpoint", "(ZILcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;Z)V", "getContainingFunctionPresentation", "()Ljava/lang/String;", "setContainingFunctionPresentation", "(Ljava/lang/String;)V", "debugProcessToThreadIdToStopMap", "", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "", "getDebugProcessToThreadIdToStopMap", "()Ljava/util/Map;", "setDebugProcessToThreadIdToStopMap", "(Ljava/util/Map;)V", "endOffsets", "", "filename", "getFilename", "setFilename", "isMultiMethodBreakpoint", "()Z", "setMultiMethodBreakpoint", "(Z)V", "rangeMarkers", "Lcom/intellij/openapi/editor/RangeMarker;", "startOffsets", "j", "", "getBreakpointElements", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointElement;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getState", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "loadState", "state", "setVariant", "variant", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointType;", "toString", "N", "w", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,227:1\n65#2,4:228\n65#2,4:232\n13#2:245\n1549#3:236\n1620#3,3:237\n1549#3:240\n1620#3,3:241\n13#4:244\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties\n*L\n115#1:228,4\n120#1:232,4\n28#1:245\n125#1:236\n125#1:237,3\n126#1:240\n126#1:241,3\n28#1:244\n*E\n"})
public class DotNetLineBreakpointProperties
extends DotNetBreakpointProperties<DotNetLineBreakpointProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Transient
    @NotNull
    private List<RangeMarker> rangeMarkers;
    @Tag(value="startOffsets")
    @XCollection
    @NotNull
    private List<Integer> startOffsets;
    @Tag(value="endOffsets")
    @XCollection
    @NotNull
    private List<Integer> endOffsets;
    @Attribute(value="documentPath")
    @NotNull
    private String filename;
    @Attribute(value="containingFunctionPresentation")
    @Nls
    @Nullable
    private String containingFunctionPresentation;
    @Attribute(value="isMultiMethodBreakpoint")
    private boolean isMultiMethodBreakpoint;
    @NotNull
    private Map<DotNetDebugProcess, Long> debugProcessToThreadIdToStopMap;
    @NotNull
    private static final Logger logger;

    public DotNetLineBreakpointProperties(boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode, boolean multiMethodBreakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
        super(hitCountFilterEnabled, hitCount, hitCountMode);
        this.rangeMarkers = new ArrayList();
        this.startOffsets = new ArrayList();
        this.endOffsets = new ArrayList();
        this.filename = "";
        this.isMultiMethodBreakpoint = multiMethodBreakpoint;
        this.debugProcessToThreadIdToStopMap = new LinkedHashMap();
    }

    public /* synthetic */ DotNetLineBreakpointProperties(boolean bl, int n, BreakpointHitCountMode breakpointHitCountMode, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        this(bl, n, breakpointHitCountMode, bl2);
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    public final void setFilename(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filename = string;
    }

    @Nullable
    public final String getContainingFunctionPresentation() {
        return this.containingFunctionPresentation;
    }

    public final void setContainingFunctionPresentation(@Nullable String string) {
        this.containingFunctionPresentation = string;
    }

    public final boolean isMultiMethodBreakpoint() {
        return this.isMultiMethodBreakpoint;
    }

    public final void setMultiMethodBreakpoint(boolean bl) {
        this.isMultiMethodBreakpoint = bl;
    }

    @Transient
    @NotNull
    public final Map<DotNetDebugProcess, Long> getDebugProcessToThreadIdToStopMap() {
        return this.debugProcessToThreadIdToStopMap;
    }

    public final void setDebugProcessToThreadIdToStopMap(@NotNull Map<DotNetDebugProcess, Long> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.debugProcessToThreadIdToStopMap = map2;
    }

    public DotNetLineBreakpointProperties(@NotNull String canonicalDocumentPath, @Nls @Nullable String containingFunctionPresentation, @NotNull List<Integer> initStartOffsets, @NotNull List<Integer> initEndOffsets, boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode) {
        Intrinsics.checkNotNullParameter((Object)canonicalDocumentPath, (String)"canonicalDocumentPath");
        Intrinsics.checkNotNullParameter(initStartOffsets, (String)"initStartOffsets");
        Intrinsics.checkNotNullParameter(initEndOffsets, (String)"initEndOffsets");
        Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
        this(hitCountFilterEnabled, hitCount, hitCountMode, false, 8, null);
        this.startOffsets = CollectionsKt.toMutableList((Collection)initStartOffsets);
        this.endOffsets = CollectionsKt.toMutableList((Collection)initEndOffsets);
        this.filename = DotNetLineBreakpointProperties.Companion.j(canonicalDocumentPath);
        this.containingFunctionPresentation = containingFunctionPresentation;
        this.w();
    }

    public /* synthetic */ DotNetLineBreakpointProperties(String string, String string2, List list2, List list3, boolean bl, int n, BreakpointHitCountMode breakpointHitCountMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        if ((n2 & 0x40) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        this(string, string2, list2, list3, bl, n, breakpointHitCountMode);
    }

    @Override
    public void loadState(@NotNull DotNetLineBreakpointProperties state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.loadState((XBreakpointProperties)state);
        this.startOffsets = state.startOffsets;
        this.endOffsets = state.endOffsets;
        this.filename = state.filename;
        this.containingFunctionPresentation = state.containingFunctionPresentation;
        this.isMultiMethodBreakpoint = state.isMultiMethodBreakpoint;
        this.w();
        Logger logger2 = logger;
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            Logger logger3 = logger2;
            boolean bl2 = false;
            logger3.trace("Deserialize line breakpoint: " + this);
        }
    }

    @Override
    @NotNull
    public DotNetLineBreakpointProperties getState() {
        this.N();
        Logger logger2 = logger;
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            Logger logger3 = logger2;
            boolean bl2 = false;
            logger3.trace("Serialize line breakpoint: " + this);
        }
        return this;
    }

    private final void N() {
        boolean bl;
        Collection collection;
        RangeMarker rangeMarker;
        Iterable iterable = this.rangeMarkers;
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = this;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object t : iterable2) {
            rangeMarker = (RangeMarker)t;
            collection = collection2;
            bl = false;
            RangeMarker rangeMarker2 = rangeMarker;
            collection.add(rangeMarker2 != null ? rangeMarker2.getStartOffset() : -1);
        }
        dotNetLineBreakpointProperties.startOffsets = CollectionsKt.toMutableList((Collection)((List)collection2));
        iterable = this.rangeMarkers;
        dotNetLineBreakpointProperties = this;
        bl2 = false;
        iterable2 = iterable;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            rangeMarker = (RangeMarker)t;
            collection = collection2;
            bl = false;
            RangeMarker rangeMarker3 = rangeMarker;
            collection.add(rangeMarker3 != null ? rangeMarker3.getEndOffset() : -1);
        }
        dotNetLineBreakpointProperties.endOffsets = CollectionsKt.toMutableList((Collection)((List)collection2));
    }

    private final void w() {
        int n = this.startOffsets.size();
        if (this.endOffsets.size() != n) {
            logger.error("Breakpoint " + this + " has mismatching offsets arrays: start offsets size is " + n + ", end offsets size is " + this.endOffsets.size());
            n = Math.min(n, this.endOffsets.size());
        }
        List list2 = new ArrayList();
        int n2 = n;
        for (int k = 0; k < n2; ++k) {
            Document document2;
            VirtualFile virtualFile2;
            int n3 = ((Number)this.startOffsets.get(k)).intValue();
            int n4 = ((Number)this.endOffsets.get(k)).intValue();
            if (VfsUtil.findFileByIoFile((File)new File(this.filename), (boolean)true) == null) {
                return;
            }
            if (FileDocumentManager.getInstance().getDocument(virtualFile2) == null) {
                return;
            }
            list2.add((0 <= n3 ? n3 < n4 : false) && n4 <= document2.getTextLength() ? document2.createRangeMarker(n3, n4) : null);
        }
        this.rangeMarkers = list2;
    }

    @Nullable
    public final TextRange getTextRange() {
        if (this.rangeMarkers.size() != 1) {
            return null;
        }
        RangeMarker rangeMarker = (RangeMarker)CollectionsKt.first(this.rangeMarkers);
        if (rangeMarker == null) {
            return null;
        }
        RangeMarker rangeMarker2 = rangeMarker;
        return new TextRange(rangeMarker2.getStartOffset(), rangeMarker2.getEndOffset());
    }

    @NotNull
    public final List<BreakpointElement> getBreakpointElements(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends BreakpointElement>>(this, breakpoint){
            final /* synthetic */ DotNetLineBreakpointProperties this$0;
            final /* synthetic */ XLineBreakpoint<?> $breakpoint;
            {
                this.this$0 = $receiver;
                this.$breakpoint = $breakpoint;
                super(0);
            }

            @NotNull
            public final List<BreakpointElement> invoke() {
                int n = DotNetLineBreakpointProperties.access$getStartOffsets$p(this.this$0).size();
                if (DotNetLineBreakpointProperties.access$getEndOffsets$p(this.this$0).size() != n) {
                    DotNetLineBreakpointProperties.access$getLogger$cp().error("Breakpoint " + this.this$0 + " has mismatching offsets arrays: start offsets size is " + n + ", end offsets size is " + DotNetLineBreakpointProperties.access$getEndOffsets$p(this.this$0).size());
                    n = Math.min(n, DotNetLineBreakpointProperties.access$getEndOffsets$p(this.this$0).size());
                }
                if (DotNetLineBreakpointProperties.access$getRangeMarkers$p(this.this$0).size() != n) {
                    DotNetLineBreakpointProperties.access$getLogger$cp().error("Breakpoint " + this.this$0 + " has mismatching sizes: start offsets size is " + n + ", range markers size is " + DotNetLineBreakpointProperties.access$getEndOffsets$p(this.this$0).size());
                    n = Math.min(n, DotNetLineBreakpointProperties.access$getRangeMarkers$p(this.this$0).size());
                }
                if (n == 0) {
                    XSourcePosition xSourcePosition = this.$breakpoint.getSourcePosition();
                    if (xSourcePosition == null) {
                        return CollectionsKt.emptyList();
                    }
                    XSourcePosition xSourcePosition2 = xSourcePosition;
                    String string = xSourcePosition2.getFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String string2 = string;
                    if (((CharSequence)string2).length() == 0) {
                        return CollectionsKt.emptyList();
                    }
                    return CollectionsKt.listOf((Object)new BreakpointElement(string2, this.$breakpoint.getLine(), 0, this.this$0.isMultiMethodBreakpoint()));
                }
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)n);
                DotNetLineBreakpointProperties dotNetLineBreakpointProperties = this.this$0;
                XLineBreakpoint<?> xLineBreakpoint = this.$breakpoint;
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList<E>();
                boolean bl2 = false;
                Iterable iterable3 = iterable2;
                boolean bl3 = false;
                Iterator<T> iterator2 = iterable3.iterator();
                while (iterator2.hasNext()) {
                    BreakpointElement breakpointElement;
                    int n2;
                    int n3 = n2 = ((IntIterator)iterator2).nextInt();
                    boolean bl4 = false;
                    int n4 = n3;
                    boolean bl5 = false;
                    RangeMarker rangeMarker = (RangeMarker)DotNetLineBreakpointProperties.access$getRangeMarkers$p(dotNetLineBreakpointProperties).get(n4);
                    if (rangeMarker == null || !rangeMarker.isValid()) {
                        breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.getFilename(), xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint());
                    } else {
                        int n5 = rangeMarker.getStartOffset();
                        if (VfsUtil.findFileByIoFile((File)new File(dotNetLineBreakpointProperties.getFilename()), (boolean)true) == null) {
                            breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.getFilename(), xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint());
                        } else {
                            VirtualFile virtualFile2;
                            Intrinsics.checkNotNull((Object)virtualFile2);
                            VirtualFile virtualFile3 = virtualFile2;
                            if (FileDocumentManager.getInstance().getDocument(virtualFile3) == null) {
                                breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.getFilename(), xLineBreakpoint.getLine(), 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint());
                            } else {
                                Document document2;
                                Intrinsics.checkNotNull((Object)document2);
                                virtualFile2 = document2;
                                if (virtualFile2.getLineCount() <= xLineBreakpoint.getLine()) {
                                    breakpointElement = null;
                                } else {
                                    int n6 = virtualFile2.getLineStartOffset(xLineBreakpoint.getLine());
                                    int n7 = n5 - n6;
                                    breakpointElement = new BreakpointElement(dotNetLineBreakpointProperties.getFilename(), xLineBreakpoint.getLine(), n7 > 0 ? n7 : 0, dotNetLineBreakpointProperties.isMultiMethodBreakpoint());
                                }
                            }
                        }
                    }
                    if (breakpointElement == null) continue;
                    BreakpointElement breakpointElement2 = breakpointElement;
                    boolean bl6 = false;
                    collection.add(breakpointElement2);
                }
                return CollectionsKt.distinct((Iterable)((List)collection));
            }
        }));
    }

    @NotNull
    public String toString() {
        return "(" + this.filename + ": - " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)this.rangeMarkers), (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + ")";
    }

    private final void j() {
        this.startOffsets.clear();
        this.endOffsets.clear();
        this.rangeMarkers.clear();
    }

    public final void setVariant(@NotNull DotNetLineBreakpointType.DotNetBreakpointVariant variant) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
            this.j();
            TextRange textRange = variant.getHighlightRange();
            if (textRange == null) break block0;
            TextRange textRange2 = textRange;
            boolean bl = false;
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(variant, textRange2, this){
                final /* synthetic */ DotNetLineBreakpointType.DotNetBreakpointVariant $variant;
                final /* synthetic */ TextRange $it;
                final /* synthetic */ DotNetLineBreakpointProperties this$0;
                {
                    this.$variant = $variant;
                    this.$it = $it;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Document document2 = FileDocumentManager.getInstance().getDocument(this.$variant.getFile());
                    if (document2 == null) {
                        return;
                    }
                    Document document3 = document2;
                    int n = this.$it.getEndOffset();
                    int n2 = this.$it.getStartOffset();
                    if (!(0 <= n2 ? n2 < n : false) || this.$it.getEndOffset() > document3.getTextLength()) {
                        return;
                    }
                    RangeMarker rangeMarker = document3.createRangeMarker(this.$it.getStartOffset(), this.$it.getEndOffset());
                    Intrinsics.checkNotNull((Object)rangeMarker);
                    RangeMarker rangeMarker2 = rangeMarker;
                    DotNetLineBreakpointProperties.access$getStartOffsets$p(this.this$0).add(this.$it.getStartOffset());
                    DotNetLineBreakpointProperties.access$getEndOffsets$p(this.this$0).add(this.$it.getEndOffset());
                    DotNetLineBreakpointProperties.access$getRangeMarkers$p(this.this$0).add(rangeMarker2);
                }
            }));
        }
    }

    public DotNetLineBreakpointProperties() {
        this(false, 0, null, false, 15, null);
    }

    public static final /* synthetic */ void access$setStartOffsets$p(DotNetLineBreakpointProperties $this, List list2) {
        $this.startOffsets = list2;
    }

    public static final /* synthetic */ void access$setEndOffsets$p(DotNetLineBreakpointProperties $this, List list2) {
        $this.endOffsets = list2;
    }

    public static final /* synthetic */ void access$setRangeMarkers$p(DotNetLineBreakpointProperties $this, List list2) {
        $this.rangeMarkers = list2;
    }

    public static final /* synthetic */ List access$getStartOffsets$p(DotNetLineBreakpointProperties $this) {
        return $this.startOffsets;
    }

    public static final /* synthetic */ List access$getEndOffsets$p(DotNetLineBreakpointProperties $this) {
        return $this.endOffsets;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ List access$getRangeMarkers$p(DotNetLineBreakpointProperties $this) {
        return $this.rangeMarkers;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(DotNetLineBreakpointProperties.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "canonicalDocumentPath", "", "containingFunctionPresentation", "startOffset", "", "endOffset", "hitCountFilterEnabled", "", "hitCount", "hitCountMode", "Lcom/jetbrains/rider/debugger/breakpoint/BreakpointHitCountMode;", "multiMethodBreakpoint", "j", "fileName", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nDotNetLineBreakpointProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n13#2:228\n13#3:229\n86#3,2:230\n88#3:233\n1#4:232\n*S KotlinDebug\n*F\n+ 1 DotNetLineBreakpointProperties.kt\ncom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties$Companion\n*L\n57#1:228\n57#1:229\n57#1:230,2\n57#1:233\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DotNetLineBreakpointProperties create(@NotNull String canonicalDocumentPath, @Nls @Nullable String containingFunctionPresentation, int startOffset, int endOffset, boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode, boolean multiMethodBreakpoint) {
            Intrinsics.checkNotNullParameter((Object)canonicalDocumentPath, (String)"canonicalDocumentPath");
            Intrinsics.checkNotNullParameter((Object)((Object)hitCountMode), (String)"hitCountMode");
            return (DotNetLineBreakpointProperties)((Object)ActionsKt.runReadAction((Function0)((Function0)new Function0<DotNetLineBreakpointProperties>(hitCountFilterEnabled, hitCount, hitCountMode, multiMethodBreakpoint, startOffset, endOffset, canonicalDocumentPath, containingFunctionPresentation){
                final /* synthetic */ boolean $hitCountFilterEnabled;
                final /* synthetic */ int $hitCount;
                final /* synthetic */ BreakpointHitCountMode $hitCountMode;
                final /* synthetic */ boolean $multiMethodBreakpoint;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ String $canonicalDocumentPath;
                final /* synthetic */ String $containingFunctionPresentation;
                {
                    this.$hitCountFilterEnabled = $hitCountFilterEnabled;
                    this.$hitCount = $hitCount;
                    this.$hitCountMode = $hitCountMode;
                    this.$multiMethodBreakpoint = $multiMethodBreakpoint;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$canonicalDocumentPath = $canonicalDocumentPath;
                    this.$containingFunctionPresentation = $containingFunctionPresentation;
                    super(0);
                }

                @NotNull
                public final DotNetLineBreakpointProperties invoke() {
                    DotNetLineBreakpointProperties dotNetLineBreakpointProperties = new DotNetLineBreakpointProperties(this.$hitCountFilterEnabled, this.$hitCount, this.$hitCountMode, this.$multiMethodBreakpoint);
                    Integer[] integerArray = new Integer[]{this.$startOffset};
                    DotNetLineBreakpointProperties.access$setStartOffsets$p(dotNetLineBreakpointProperties, CollectionsKt.mutableListOf((Object[])integerArray));
                    integerArray = new Integer[]{this.$endOffset};
                    DotNetLineBreakpointProperties.access$setEndOffsets$p(dotNetLineBreakpointProperties, CollectionsKt.mutableListOf((Object[])integerArray));
                    dotNetLineBreakpointProperties.setFilename(com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties$Companion.access$getAbsoluteFileName(DotNetLineBreakpointProperties.Companion, this.$canonicalDocumentPath));
                    dotNetLineBreakpointProperties.setContainingFunctionPresentation(this.$containingFunctionPresentation);
                    Integer[] integerArray2 = VfsUtil.findFileByIoFile((File)new File(this.$canonicalDocumentPath), (boolean)true);
                    if (integerArray2 == null) {
                        return dotNetLineBreakpointProperties;
                    }
                    integerArray = integerArray2;
                    Document document2 = FileDocumentManager.getInstance().getDocument((VirtualFile)integerArray);
                    if (document2 == null) {
                        return dotNetLineBreakpointProperties;
                    }
                    Document document3 = document2;
                    RangeMarker rangeMarker = (0 <= this.$startOffset ? this.$startOffset < this.$endOffset : false) && this.$endOffset <= document3.getTextLength() ? document3.createRangeMarker(this.$startOffset, this.$endOffset) : null;
                    Object[] objectArray = new RangeMarker[]{rangeMarker};
                    DotNetLineBreakpointProperties.access$setRangeMarkers$p(dotNetLineBreakpointProperties, CollectionsKt.mutableListOf((Object[])objectArray));
                    return dotNetLineBreakpointProperties;
                }
            })));
        }

        public static /* synthetic */ DotNetLineBreakpointProperties create$default(Companion companion, String string, String string2, int n, int n2, boolean bl, int n3, BreakpointHitCountMode breakpointHitCountMode, boolean bl2, int n4, Object object) {
            if ((n4 & 0x10) != 0) {
                bl = false;
            }
            if ((n4 & 0x20) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x40) != 0) {
                breakpointHitCountMode = BreakpointHitCountMode.LessThan;
            }
            if ((n4 & 0x80) != 0) {
                bl2 = false;
            }
            return companion.create(string, string2, n, n2, bl, n3, breakpointHitCountMode, bl2);
        }

        private final String j(String string) {
            boolean bl = false;
            boolean bl2 = false;
            Logger logger2 = Logger.getInstance(DotNetBreakpointProperties.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Logger logger3 = logger2;
            bl2 = false;
            Logger logger4 = logger3;
            try {
                String string2;
                Logger logger5 = logger4;
                boolean bl3 = false;
                boolean bl4 = false;
                File file2 = DocumentUtilKt.toIOFile((String)string);
                boolean bl5 = false;
                String string3 = file2.isAbsolute() ? file2.getAbsolutePath() : file2.getPath();
                String string4 = string3;
                CharSequence charSequence = string4;
                if (charSequence == null || charSequence.length() == 0) {
                    string2 = string;
                } else {
                    Intrinsics.checkNotNull((Object)string4);
                    string2 = string4;
                }
                return string2;
            }
            catch (Throwable throwable) {
                String string5 = (String)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)logger3);
                if (string5 == null) {
                    string5 = string;
                }
                return string5;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

