/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.breakpoint;

import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.rider.debugger.DebugKind;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.rider.debugger.breakpoint.DotNetLineBreakpointType;
import icons.RiderIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J \u0010\f\u001a\u00020\n2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetLineBreakpointProperties;", "debugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "(Lcom/jetbrains/rider/debugger/DotNetDebugProcess;)V", "getDebugProcess", "()Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "registerBreakpoint", "", "breakpoint", "unregisterBreakpoint", "temporary", "", "intellij.rider"})
public final class DotNetLineBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<DotNetLineBreakpointProperties>> {
    @NotNull
    private final DotNetDebugProcess debugProcess;

    public DotNetLineBreakpointHandler(@NotNull DotNetDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugProcess), (String)"debugProcess");
        super(DotNetLineBreakpointType.class);
        this.debugProcess = debugProcess;
    }

    @NotNull
    public final DotNetDebugProcess getDebugProcess() {
        return this.debugProcess;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (this.debugProcess.getDebugKind() == DebugKind.Dump) {
            this.debugProcess.getSession().updateBreakpointPresentation(breakpoint, RiderIcons.Debugger.Db_cant_add_breakpoint, "Breakpoints can not be set while debugging a dump");
            return;
        }
        this.debugProcess.getBreakpointsManager().registerLineBreakpoint(breakpoint);
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.debugProcess.getBreakpointsManager().unregisterLineBreakpoint(breakpoint);
    }
}

