/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.attach.remoting.JetBrainsUnarchiver;
import com.jetbrains.rider.debugger.attach.remoting.RemoteDebuggerToolsDownloadHelper;
import com.jetbrains.rider.debugger.attach.remoting.RemoteDebuggerUtils;
import com.jetbrains.rider.debugger.attach.remoting.RiderArtifactBuildVersion;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsDownload;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsRelease;
import com.jetbrains.rider.debugger.attach.remoting.RiderRemoteToolsVersionsKt;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.ProtocolComponent;
import com.jetbrains.rider.protocol.components.ShellHost;
import com.jetbrains.rider.util.OSKind;
import com.jetbrains.rider.utils.DownloadHelperKt;
import com.jetbrains.rider.utils.DownloadStatusHandlerSus;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J.\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001b\u001a\u00020\u0011H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u001f\u001a\u00020\u001aJ\b\u0010 \u001a\u00020\u0004H\u0002J\b\u0010!\u001a\u00020\u0004H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020\u0004H\u0002J \u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0002J\f\u0010-\u001a\u00020\u001a*\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsDownloadHelper;", "", "()V", "ARCHIVE_NAME", "", "CPU_PATTERN", "DEFAULT_REMOTE_TOOLS_LINK", "FALLBACK_RELEASE_VERSION", "LATEST_RELEASE_VERSION", "RIDER_REMOTE_TOOLS_CUSTOM_URL_KEY", "RIDER_REMOTE_TOOLS_CUSTOM_VERSION_KEY", "RIDER_VERSION_PATTERN", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "j", "", "debuggerDir", "Ljava/io/File;", "downloadDebuggerToolsAndUnarchive", "cpu", "Lcom/jetbrains/rider/CPUKind;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rider/CPUKind;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadDebuggerToolsLocally", "Lkotlin/Pair;", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderArtifactBuildVersion;", "j", "N", "currentRiderVersion", "j", "getExpectedBuildArtifactVersionForIde", "w", "j", "getRemoteDebuggerToolsDownloadUrl", "Lcom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsDownloadHelper$VersionAndDownloadUrl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "j", "N", "j", "baseUrl", "j", "", "fullVersion", "j", "Lcom/intellij/openapi/application/ApplicationInfo;", "VersionAndDownloadUrl", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRemoteDebuggerToolsDownloadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDebuggerToolsDownloadHelper.kt\ncom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsDownloadHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 EnvironmentSetupUtils.kt\ncom/jetbrains/rider/environmentSetup/impl/EnvironmentSetupUtils\n+ 6 IProtocolHost.kt\ncom/jetbrains/rider/protocol/IProtocolHostKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 8 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 9 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,406:1\n1#2:407\n3792#3:408\n4307#3,2:409\n1549#4:411\n1620#4,3:412\n1054#4:415\n766#4:416\n857#4,2:417\n766#4:419\n857#4,2:420\n661#4,11:429\n800#4,11:464\n66#5,7:422\n73#5,9:440\n98#5,14:449\n24#6:463\n643#7,5:475\n13#8:480\n13#9:481\n*S KotlinDebug\n*F\n+ 1 RemoteDebuggerToolsDownloadHelper.kt\ncom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsDownloadHelper\n*L\n172#1:408\n172#1:409,2\n181#1:411\n181#1:412,3\n181#1:415\n194#1:416\n194#1:417,2\n211#1:419\n211#1:420,2\n254#1:429,11\n329#1:464,11\n254#1:422,7\n254#1:440,9\n254#1:449,14\n329#1:463\n352#1:475,5\n44#1:480\n44#1:481\n*E\n"})
public final class RemoteDebuggerToolsDownloadHelper {
    @NotNull
    public static final RemoteDebuggerToolsDownloadHelper INSTANCE = new RemoteDebuggerToolsDownloadHelper();
    @NotNull
    private static final String CPU_PATTERN = "%CPU_VERSION%";
    @NotNull
    private static final String RIDER_VERSION_PATTERN = "%RIDER_VERSION%";
    @NotNull
    private static final String LATEST_RELEASE_VERSION = "2022.3";
    @NotNull
    private static final String FALLBACK_RELEASE_VERSION = "2022.2.3";
    @NotNull
    private static final String DEFAULT_REMOTE_TOOLS_LINK = "https://download.jetbrains.com/resharper/dotUltimate.%RIDER_VERSION%/JetBrains.Rider.RemoteDebuggerUploads.%CPU_VERSION%.%RIDER_VERSION%.zip";
    @NotNull
    private static final String RIDER_REMOTE_TOOLS_CUSTOM_URL_KEY = "RIDER_REMOTE_TOOLS_CUSTOM_URL";
    @NotNull
    private static final String RIDER_REMOTE_TOOLS_CUSTOM_VERSION_KEY = "RIDER_REMOTE_TOOLS_CUSTOM_VERSION";
    @NotNull
    private static final String ARCHIVE_NAME = "DebuggerTools.zip";
    @NotNull
    private static final Logger logger;

    private RemoteDebuggerToolsDownloadHelper() {
    }

    private final String j(String string, CPUKind cPUKind, String string2) {
        logger.trace("Substituting arguments for url " + string + ", cpu = " + cPUKind + ", Rider version = " + string2);
        String string3 = cPUKind.getDirectoryName();
        String string4 = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)RIDER_VERSION_PATTERN, (String)string2, (boolean)false, (int)4, null), (String)CPU_PATTERN, (String)string3, (boolean)false, (int)4, null);
        logger.trace("Result url: " + string4);
        return string4;
    }

    private final String N(CPUKind cPUKind, String string) {
        String string2;
        String string3 = System.getenv(RIDER_REMOTE_TOOLS_CUSTOM_URL_KEY);
        logger.trace("Trying to get custom debugger tools url, url = " + string3);
        String string4 = string3;
        if (string4 != null) {
            String string5 = string4;
            boolean bl = false;
            string2 = INSTANCE.j(string5, cPUKind, string);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final String j(CPUKind cPUKind, String string) {
        String string2 = DEFAULT_REMOTE_TOOLS_LINK;
        logger.trace("Trying to get fallback debugger tools url, url = " + string2);
        return this.j(string2, cPUKind, string);
    }

    private final String j() {
        return LATEST_RELEASE_VERSION;
    }

    private final String w() {
        return FALLBACK_RELEASE_VERSION;
    }

    @Nullable
    public final VersionAndDownloadUrl getRemoteDebuggerToolsDownloadUrl(@NotNull CPUKind cpu, @Nullable ProgressIndicator indicator) {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
        logger.info("Trying to obtain remote tools url, cpu kind = " + cpu);
        String string = System.getenv(RIDER_REMOTE_TOOLS_CUSTOM_VERSION_KEY);
        logger.trace("Custom version: " + string);
        String string2 = string;
        if (string2 == null) {
            string2 = this.N();
        }
        String string3 = string2;
        logger.trace("Rider version: " + string3);
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            objectArray2 = new Object[]{1};
            progressIndicator.setText(RiderDebuggerBundle.Companion.message("RemoteDebuggerUtils.progress.text.retrieve.tools", objectArray2));
        }
        objectArray2 = this.N(cpu, string3);
        if (objectArray2 != null && RemoteDebuggerToolsDownloadHelper.j((String)objectArray2)) {
            logger.info("Find custom debugger tools url: " + (String)objectArray2);
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"getInstance(...)");
            return new VersionAndDownloadUrl(this.j(applicationInfo), (String)objectArray2);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            objectArray = new Object[]{2};
            progressIndicator2.setText(RiderDebuggerBundle.Companion.message("RemoteDebuggerUtils.progress.text.retrieve.tools", objectArray));
        }
        objectArray = this.j(cpu);
        if (objectArray != null) {
            return objectArray;
        }
        logger.error("Unable to get remote tools link for cpu " + cpu.getDirectoryName() + " using data services");
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            object = new Object[]{3};
            progressIndicator3.setText(RiderDebuggerBundle.Companion.message("RemoteDebuggerUtils.progress.text.retrieve.tools", object));
        }
        object = (Object[])string;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            Intrinsics.checkNotNull((Object)string);
            object = RemoteDebuggerToolsDownloadHelper.j(cpu, string);
            if (object != null) {
                return object;
            }
        }
        if ((object = RemoteDebuggerToolsDownloadHelper.j(cpu, this.j())) != null) {
            return object;
        }
        VersionAndDownloadUrl versionAndDownloadUrl = RemoteDebuggerToolsDownloadHelper.j(cpu, this.w());
        if (versionAndDownloadUrl != null) {
            return versionAndDownloadUrl;
        }
        return null;
    }

    public static /* synthetic */ VersionAndDownloadUrl getRemoteDebuggerToolsDownloadUrl$default(RemoteDebuggerToolsDownloadHelper remoteDebuggerToolsDownloadHelper, CPUKind cPUKind, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return remoteDebuggerToolsDownloadHelper.getRemoteDebuggerToolsDownloadUrl(cPUKind, progressIndicator);
    }

    private final String N() {
        String string = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        String string2 = StringsKt.replace$default((String)string, (String)" ", (String)"", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)string2, (String)"EAP", (String)".EAP", (boolean)false, (int)4, null);
    }

    private final VersionAndDownloadUrl j(CPUKind cPUKind) {
        Object object;
        Object object2;
        boolean bl;
        RiderRemoteToolsRelease riderRemoteToolsRelease;
        int n;
        RiderRemoteToolsRelease[] riderRemoteToolsReleaseArray;
        logger.info("Trying to obtain remote tools url using data services");
        Object object3 = riderRemoteToolsReleaseArray = RiderRemoteToolsVersionsKt.getRemoteToolsReleases();
        boolean bl2 = false;
        RiderRemoteToolsRelease[] riderRemoteToolsReleaseArray2 = object3;
        Iterable iterable2 = new ArrayList();
        boolean bl3 = false;
        int n2 = riderRemoteToolsReleaseArray2.length;
        for (n = 0; n < n2; ++n) {
            RiderRemoteToolsRelease iterable3;
            riderRemoteToolsRelease = iterable3 = riderRemoteToolsReleaseArray2[n];
            bl = false;
            if (!riderRemoteToolsRelease.getDownloads().containsKey(cPUKind.getDownloadKey())) continue;
            iterable2.add(iterable3);
        }
        List list2 = (List)iterable2;
        Iterable iterable = list2;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        logger.trace("Applicable releases for cpu kind " + cPUKind + ": [" + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null) + "]");
        if (list2.isEmpty()) {
            logger.warn("No applicable releases for CPU " + cPUKind.getDirectoryName() + " on data services");
            return null;
        }
        Iterable iterable5 = list2;
        boolean bl4 = false;
        iterable2 = iterable5;
        Iterable iterable6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable5, (int)10));
        n = 0;
        for (Object e : iterable2) {
            riderRemoteToolsRelease = (RiderRemoteToolsRelease)e;
            Collection collection = iterable6;
            bl = false;
            collection.add(new Pair((Object)riderRemoteToolsRelease, (Object)RiderArtifactBuildVersion.Companion.parse(riderRemoteToolsRelease.getBuild())));
        }
        iterable5 = (List)iterable6;
        bl4 = false;
        object3 = CollectionsKt.sortedWith((Iterable)iterable5, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                Comparable comparable = (RiderArtifactBuildVersion)pair.getSecond();
                pair = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((RiderArtifactBuildVersion)pair.getSecond()));
            }
        });
        iterable5 = ApplicationInfo.getInstance();
        logger.info("Application version: major = " + iterable5.getMajorVersion() + ", minor = " + iterable5.getMinorVersion() + ", micro = " + iterable5.getMicroVersion() + ", patch = " + iterable5.getPatchVersion());
        Intrinsics.checkNotNull((Object)iterable5);
        RiderArtifactBuildVersion riderArtifactBuildVersion = this.j((ApplicationInfo)iterable5);
        logger.info("Parsed build number: " + riderArtifactBuildVersion);
        iterable6 = (Iterable)object3;
        n = 0;
        Iterable iterable7 = iterable6;
        Collection collection = new ArrayList();
        boolean bl5 = false;
        Iterator iterator2 = iterable7.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = (Pair)object2;
            boolean bl6 = false;
            if (!(((RiderArtifactBuildVersion)object.getSecond()).getMajor() == riderArtifactBuildVersion.getMajor() && ((RiderArtifactBuildVersion)object.getSecond()).getMinor() == riderArtifactBuildVersion.getMinor())) continue;
            collection.add(object2);
        }
        iterable2 = (List)collection;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        logger.trace("Current wave releases: [" + CollectionsKt.joinToString$default(iterable2, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null) + "]");
        if (iterable2.isEmpty()) {
            iterable6 = (Pair)CollectionsKt.first((List)object3);
            logger.warn("Can't find any releases for current wave (" + riderArtifactBuildVersion.getMajor() + "." + riderArtifactBuildVersion.getMinor() + "), trying to get the last one (" + iterable6.getFirst() + ")");
            return RemoteDebuggerToolsDownloadHelper.j(cPUKind, (Pair<RiderRemoteToolsRelease, RiderArtifactBuildVersion>)iterable6);
        }
        Pair pair = iterable2;
        boolean bl7 = false;
        Iterable iterable3 = pair;
        Collection collection2 = new ArrayList();
        boolean bl8 = false;
        object2 = iterable3.iterator();
        while (object2.hasNext()) {
            Object object4 = object = object2.next();
            boolean bl9 = false;
            if (!(((RiderArtifactBuildVersion)object4.getSecond()).getBugfix() == riderArtifactBuildVersion.getBugfix())) continue;
            collection2.add(object);
        }
        iterable6 = (List)collection2;
        Iterable iterable4 = iterable6;
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator(...)");
        logger.trace("Current bugfix releases: [" + CollectionsKt.joinToString$default((Iterable)iterable4, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null) + "]");
        if (iterable6.isEmpty()) {
            pair = (Pair)CollectionsKt.first(iterable2);
            logger.warn("Can't find any releases for current bugfix (" + riderArtifactBuildVersion.getMajor() + "." + riderArtifactBuildVersion.getMinor() + "." + riderArtifactBuildVersion.getBugfix() + "),trying to get the last one (" + pair.getFirst() + ")");
            return RemoteDebuggerToolsDownloadHelper.j(cPUKind, (Pair<RiderRemoteToolsRelease, RiderArtifactBuildVersion>)pair);
        }
        pair = (Pair)CollectionsKt.first(iterable6);
        logger.info("Selected release: " + pair.getFirst());
        return RemoteDebuggerToolsDownloadHelper.j(cPUKind, (Pair<RiderRemoteToolsRelease, RiderArtifactBuildVersion>)pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object downloadDebuggerToolsLocally(@NotNull CPUKind var1_1, @NotNull Project var2_2, @NotNull Continuation<? super Pair<? extends File, RiderArtifactBuildVersion>> var3_3) {
        if (!(var3_3 instanceof downloadDebuggerToolsLocally.1)) ** GOTO lbl-1000
        var26_4 = var3_3;
        if ((var26_4.label & -2147483648) != 0) {
            var26_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var26_4 = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteDebuggerToolsDownloadHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadDebuggerToolsLocally(null, null, (Continuation<? super Pair<? extends File, RiderArtifactBuildVersion>>)((Continuation)this));
                }
            };
        }
        var25_5 = var26_4.result;
        var27_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var26_4.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var25_5);
                RemoteDebuggerToolsDownloadHelper.logger.info("Downloading debugger tools");
                var4_7 = new File(this.j((Project)project), cpu.name());
                var5_8 = new File(var4_7, "DebuggerTools.zip");
                RemoteDebuggerToolsDownloadHelper.logger.trace("Debugger tools directory: " + var4_7.getCanonicalPath());
                if (var5_8.exists()) {
                    RemoteDebuggerToolsDownloadHelper.logger.info("Debugger tools already exists");
                    return TuplesKt.to((Object)var5_8, null);
                }
                v0 = RemoteDebuggerToolsDownloadHelper.getRemoteDebuggerToolsDownloadUrl$default(this, (CPUKind)cpu, null, 2, null);
                if (v0 == null) {
                    return null;
                }
                var6_9 = v0;
                RemoteDebuggerToolsDownloadHelper.logger.trace("Debugger download url: " + var6_9.getDownloadUrl());
                var8_10 = var6_9.getDownloadUrl();
                var9_11 = 1;
                var10_12 = false;
                ThreadingAssertions.assertBackgroundThread();
                var11_17 /* !! */  = new String[]{"/", "\\"};
                var12_18 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)var8_10, (String[])var11_17 /* !! */ , (boolean)false, (int)0, (int)6, null));
                var13_19 /* !! */  = new String[]{"exe", "zip", "pkg", "tar.gz", "json"};
                var11_17 /* !! */  = CollectionsKt.listOf((Object[])var13_19 /* !! */ );
                var14_20 = (Iterable)var11_17 /* !! */ ;
                var15_21 = false;
                var16_23 /* !! */  = null;
                var17_25 = false;
                var18_28 = var14_20.iterator();
                while (var18_28.hasNext()) {
                    var19_30 = var18_28.next();
                    var20_31 = (String)var19_30;
                    var21_32 = false;
                    if (!StringsKt.endsWith((String)var12_18, (String)("." + var20_31), (boolean)true)) continue;
                    if (!var17_25) ** GOTO lbl48
                    v1 = null;
                    ** GOTO lbl52
lbl48:
                    // 1 sources

                    var16_23 /* !! */  = var19_30;
                    var17_25 = true;
                }
                v1 = var17_25 == false ? null : var16_23 /* !! */ ;
lbl52:
                // 2 sources

                if ((v2 = (String)v1) == null) {
                    v2 = StringsKt.substringAfterLast$default((String)var12_18, (char)'.', null, (int)2, null);
                }
                var22_33 = ((CharSequence)(var13_19 /* !! */  = v2)).length() > 0 != false ? "." + (String)var13_19 /* !! */  : "";
                var26_4.L$0 = var4_7;
                var26_4.L$1 = var5_8;
                var26_4.L$2 = var6_9;
                var26_4.L$3 = var8_10;
                var26_4.I$0 = var9_11;
                var26_4.label = 1;
                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(var12_18, (String)var22_33, null){
                    int label;
                    final /* synthetic */ String $tempFileName;
                    final /* synthetic */ String $extensionWithDot;
                    {
                        this.$tempFileName = $tempFileName;
                        this.$extensionWithDot = $extensionWithDot;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return FileUtil.createTempFile((String)StringsKt.removeSuffix((String)this.$tempFileName, (CharSequence)this.$extensionWithDot), (String)this.$extensionWithDot);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)var26_4);
                ** if (v3 != var27_6) goto lbl64
lbl63:
                // 1 sources

                return var27_6;
lbl64:
                // 1 sources

                ** GOTO lbl76
            }
            case 1: {
                var10_13 = false;
                var9_11 = var26_4.I$0;
                var8_10 = (String)var26_4.L$3;
                var6_9 = (VersionAndDownloadUrl)var26_4.L$2;
                var5_8 = (File)var26_4.L$1;
                var4_7 = (File)var26_4.L$0;
                ResultKt.throwOnFailure((Object)var25_5);
                v3 = var25_5;
lbl76:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"withContext(...)");
                var14_20 = (File)v3;
                var14_20.delete();
                var15_22 = new DownloadStatusHandlerSus(){

                    @Nullable
                    public Object getProgressText(long totalSize, long currentSize, @NotNull Continuation<? super String> $completion) {
                        Object[] objectArray = new Object[]{Boxing.boxInt((int)MathKt.roundToInt((double)((double)currentSize / 1024.0 / 1024.0))), Boxing.boxInt((int)MathKt.roundToInt((double)((double)totalSize / 1024.0 / 1024.0)))};
                        return RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupUtils.progress.details.downloading.mb", objectArray);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public Object isCancelled(@NotNull Continuation<? super Boolean> var1_1) {
                        if (!(var1_1 instanceof EnvironmentSetupUtils.download.downloadHandler.isCancelled.1)) ** GOTO lbl-1000
                        var4_2 = var1_1;
                        if ((var4_2.label & -2147483648) != 0) {
                            var4_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var4_2 = new ContinuationImpl(this, var1_1){
                                /* synthetic */ Object result;
                                final /* synthetic */ EnvironmentSetupUtils.download.downloadHandler.1<T> this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.isCancelled((Continuation<? super Boolean>)((Continuation)this));
                                }
                            };
                        }
                        var3_3 = var4_2.result;
                        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (var4_2.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var3_3);
                                var4_2.label = 1;
                                v0 = CoroutinesKt.checkCanceled((Continuation)var4_2);
                                ** if (v0 != var5_4) goto lbl18
lbl17:
                                // 1 sources

                                return var5_4;
lbl18:
                                // 1 sources

                                ** GOTO lbl27
                            }
                            case 1: {
                                try {
                                    ResultKt.throwOnFailure((Object)var3_3);
                                    v0 = var3_3;
                                }
                                catch (CancellationException var2_5) {
                                    return Boxing.boxBoolean((boolean)true);
                                }
lbl27:
                                // 2 sources

                                return Boxing.boxBoolean((boolean)false);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                };
                var26_4.L$0 = var4_7;
                var26_4.L$1 = var5_8;
                var26_4.L$2 = var6_9;
                var26_4.L$3 = var14_20;
                var26_4.I$0 = var9_11;
                var26_4.label = 2;
                v4 = DownloadHelperKt.downloadUrlToFileSus((String)var8_10, (File)var14_20, (DownloadStatusHandlerSus)var15_22, null, (int)3, (Continuation)var26_4);
                ** if (v4 != var27_6) goto lbl92
lbl91:
                // 1 sources

                return var27_6;
lbl92:
                // 1 sources

                ** GOTO lbl104
            }
            case 2: {
                var10_14 = false;
                var9_11 = var26_4.I$0;
                var14_20 = (File)var26_4.L$3;
                var6_9 = (VersionAndDownloadUrl)var26_4.L$2;
                var5_8 = (File)var26_4.L$1;
                var4_7 = (File)var26_4.L$0;
                ResultKt.throwOnFailure((Object)var25_5);
                v4 = var25_5;
lbl104:
                // 2 sources

                var26_4.L$0 = var4_7;
                var26_4.L$1 = var5_8;
                var26_4.L$2 = var6_9;
                var26_4.L$3 = var14_20;
                var26_4.I$0 = var9_11;
                var26_4.label = 3;
                v5 = CoroutinesKt.checkCanceled((Continuation)var26_4);
                ** if (v5 != var27_6) goto lbl113
lbl112:
                // 1 sources

                return var27_6;
lbl113:
                // 1 sources

                ** GOTO lbl125
            }
            case 3: {
                var10_15 = false;
                var9_11 = var26_4.I$0;
                var14_20 = (File)var26_4.L$3;
                var6_9 = (VersionAndDownloadUrl)var26_4.L$2;
                var5_8 = (File)var26_4.L$1;
                var4_7 = (File)var26_4.L$0;
                ResultKt.throwOnFailure((Object)var25_5);
                v5 = var25_5;
lbl125:
                // 2 sources

                var23_34 = var14_20;
                var24_35 = false;
                var4_7.mkdirs();
                var16_23 /* !! */  = FilesKt.copyTo$default((File)var23_34, (File)var5_8, (boolean)true, (int)0, (int)4, null);
                var26_4.L$0 = var5_8;
                var26_4.L$1 = var6_9;
                var26_4.L$2 = var14_20;
                var26_4.L$3 = var16_23 /* !! */ ;
                var26_4.I$0 = var9_11;
                var26_4.label = 4;
                v6 = CoroutinesKt.checkCanceled((Continuation)var26_4);
                ** if (v6 != var27_6) goto lbl139
lbl138:
                // 1 sources

                return var27_6;
lbl139:
                // 1 sources

                ** GOTO lbl152
            }
            case 4: {
                var10_16 = false;
                var9_11 = var26_4.I$0;
                var16_23 /* !! */  = (File)var26_4.L$3;
                var14_20 = (File)var26_4.L$2;
                var6_9 = (VersionAndDownloadUrl)var26_4.L$1;
                var5_8 = (File)var26_4.L$0;
                try {
                    ResultKt.throwOnFailure((Object)var25_5);
                    v6 = var25_5;
lbl152:
                    // 2 sources

                    var17_26 = var16_23 /* !! */ ;
                    ** GOTO lbl165
                    {
                        catch (Throwable var16_24) {
                            throw var16_24;
                        }
                    }
                    finally {
                        if (var9_11 != 0) {
                            try {
                                var14_20.delete();
                            }
                            catch (Throwable var18_29) {}
                        }
                    }
lbl165:
                    // 1 sources

                    return TuplesKt.to((Object)var5_8, (Object)var6_9.getVersion());
                }
                catch (CancellationException var7_36) {
                    RemoteDebuggerToolsDownloadHelper.logger.trace("Operation was cancelled");
                    throw var7_36;
                }
                catch (Throwable var7_37) {
                    RemoteDebuggerToolsDownloadHelper.logger.error(var7_37);
                    return null;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadDebuggerToolsAndUnarchive(@NotNull CPUKind var1_1, @NotNull Project var2_2, @NotNull Continuation<? super File> var3_3) {
        if (!(var3_3 instanceof downloadDebuggerToolsAndUnarchive.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var14_4 = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteDebuggerToolsDownloadHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadDebuggerToolsAndUnarchive(null, null, (Continuation<? super File>)((Continuation)this));
                }
            };
        }
        var13_5 = var14_4.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var14_4.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var13_5);
                RemoteDebuggerToolsDownloadHelper.logger.info("Downloading debugger tools");
                var4_7 = new File(this.j(project), cpu.name());
                if (this.j(var4_7)) {
                    RemoteDebuggerToolsDownloadHelper.logger.info("Debugger directory (" + var4_7 + ") exists, no need in downloading");
                    return var4_7;
                }
                var4_7.mkdirs();
                var14_4.L$0 = this;
                var14_4.L$1 = cpu;
                var14_4.L$2 = project;
                var14_4.L$3 = var4_7;
                var14_4.label = 1;
                v0 = this.downloadDebuggerToolsLocally(cpu, project, (Continuation<? super Pair<? extends File, RiderArtifactBuildVersion>>)var14_4);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl35
            }
            case 1: {
                var4_7 = (File)var14_4.L$3;
                project = (Project)var14_4.L$2;
                cpu = (CPUKind)var14_4.L$1;
                this = (RemoteDebuggerToolsDownloadHelper)var14_4.L$0;
                ResultKt.throwOnFailure((Object)var13_5);
                v0 = var13_5;
lbl35:
                // 2 sources

                v1 = (Pair)v0;
                if (v1 == null) {
                    return null;
                }
                var5_8 = v1;
                var6_9 = (File)var5_8.component1();
                var7_10 = (RiderArtifactBuildVersion)var5_8.component2();
                var8_11 = JetBrainsUnarchiver.INSTANCE.getUnarchiver(CPUKind.Companion.getSYSTEM_CPU_KIND());
                if (var8_11 != null) {
                    var10_12 = new String[]{var8_11.getAbsolutePath(), "-src", var6_9.getAbsolutePath(), "-dst", var4_7.getAbsolutePath()};
                    var9_13 = new GeneralCommandLine(var10_12);
                    v2 = new CapturingProcessHandler((GeneralCommandLine)var9_13).runProcess();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"runProcess(...)");
                    var10_12 = v2;
                    if (!var10_12.checkSuccess(RemoteDebuggerToolsDownloadHelper.logger)) {
                        return null;
                    }
                } else {
                    RemoteDebuggerToolsDownloadHelper.logger.error("JB unarchiver is not expected to be null");
                    ZipUtil.extract((Path)var6_9.toPath(), (Path)var4_7.toPath(), null, (boolean)true);
                }
                if (SystemInfo.isUnix) {
                    var9_13 = cpu.getOsKind() == OSKind.Windows ? "dotnet.exe" : "dotnet";
                    var11_14 = new String[]{cpu.getDirectoryName(), "dotnet", var9_13};
                    var10_12 = Path.of(var4_7.getAbsolutePath(), var11_14);
                    Intrinsics.checkNotNull((Object)var10_12);
                    var11_14 = var10_12;
                    var12_15 = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.setPosixFilePermissions((Path)var11_14, SetsKt.setOf((Object[])var12_15)), (String)"setPosixFilePermissions(...)");
                }
                var9_13 = this.getExpectedBuildArtifactVersionForIde();
                if (var7_10 != null && !Intrinsics.areEqual((Object)var7_10, (Object)var9_13)) {
                    RemoteDebuggerToolsDownloadHelper.logger.warn("Downloaded tools version (" + var7_10 + ") and IDE version (" + (RiderArtifactBuildVersion)var9_13 + ") are not equal, copying extra files");
                    var14_4.L$0 = var4_7;
                    var14_4.L$1 = null;
                    var14_4.L$2 = null;
                    var14_4.L$3 = null;
                    var14_4.label = 2;
                    v3 = RemoteDebuggerUtils.INSTANCE.copyActualEnumeratorAndDebuggerWorker(project, var4_7, (Continuation<? super Unit>)var14_4);
                    if (v3 == var15_6) {
                        return var15_6;
                    }
                }
                ** GOTO lbl78
            }
            case 2: {
                var4_7 = (File)var14_4.L$0;
                ResultKt.throwOnFailure((Object)var13_5);
                v3 = var13_5;
lbl78:
                // 2 sources

                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final File j(Project project) {
        Object object = ApplicationProtocolKt.getProtocolHost((Project)project);
        boolean bl = false;
        Iterable iterable = object.getComponents();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            if (!(t instanceof ShellHost)) continue;
            collection.add(t);
        }
        RdShellModel rdShellModel = ((ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)collection)))).getModel();
        object = InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)rdShellModel.getWaveMarketingName())) + (RemoteDebuggerUtils.INSTANCE.getUploadDebugSymbols() ? "_Debug" : "");
        File file2 = this.j();
        return new File(new File(new File(file2, "JetBrains"), "RiderRemoteDebugger"), (String)object);
    }

    private final File j() {
        return SystemInfo.isWindows ? new File(System.getenv("LOCALAPPDATA")) : new File(new File(new File(System.getProperty("user.home")), ".local"), "share");
    }

    private final int j(String string) {
        String string2;
        block2: {
            int n = StringsKt.indexOf$default((CharSequence)string, (String)"eap", (int)0, (boolean)true, (int)2, null);
            if (n == -1) {
                logger.warn("Unable to find eap marker inside full version " + string);
                return -1;
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)string, (int)(n + 3)))).toString();
            logger.info("IDE version: " + string + ", eap suffix: " + string3);
            String string4 = string3;
            boolean bl = false;
            int n2 = string4.length();
            for (int k = 0; k < n2; ++k) {
                char c = string4.charAt(k);
                int n3 = 0;
                if (Character.isDigit(c)) continue;
                String string5 = string4;
                n3 = 0;
                String string6 = string5.substring(n3, k);
                string2 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                break block2;
            }
            string2 = string4;
        }
        String string7 = string2;
        Integer n = StringsKt.toIntOrNull((String)string7);
        int n4 = n != null ? n : -1;
        logger.info("EAP version: " + n4);
        return n4;
    }

    @NotNull
    public final RiderArtifactBuildVersion getExpectedBuildArtifactVersionForIde() {
        int n;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkNotNull((Object)applicationInfoEx);
        RiderArtifactBuildVersion riderArtifactBuildVersion = this.j((ApplicationInfo)applicationInfoEx);
        if (PluginManagerCore.isRunningFromSources()) {
            n = -1;
        } else if (applicationInfoEx.isEAP()) {
            String string = applicationInfoEx.getFullVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
            n = this.j(string);
        } else {
            n = 65536;
        }
        int n2 = n;
        return new RiderArtifactBuildVersion(riderArtifactBuildVersion.getMajor(), riderArtifactBuildVersion.getMinor(), riderArtifactBuildVersion.getBugfix(), n2);
    }

    private final boolean j(File file2) {
        return file2.isDirectory() && new File(file2, RemoteDebuggerUtils.INSTANCE.getENUMERATOR_RUNTIME_CONFIG_FILE_NAME()).isFile() && new File(file2, RemoteDebuggerUtils.INSTANCE.getENUMERATOR_DEPS_FILE_NAME()).isFile() && new File(file2, RemoteDebuggerUtils.INSTANCE.getDEBUGGER_RUNTIME_CONFIG_FILE_NAME()).isFile() && new File(file2, RemoteDebuggerUtils.INSTANCE.getDEBUGGER_DEPS_FILE_NAME()).isFile();
    }

    private final RiderArtifactBuildVersion j(ApplicationInfo applicationInfo) {
        Object object;
        Object object2;
        char[] cArray;
        Object object3 = applicationInfo.getMajorVersion();
        int n = object3 != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object object4 = applicationInfo.getMinorVersion();
        if (object4 == null || (object4 = StringsKt.split$default((CharSequence)((CharSequence)object4), (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null)) == null) {
            object4 = CollectionsKt.emptyList();
        }
        if (CollectionsKt.any((Iterable)((Iterable)(object2 = object4)))) {
            Integer n5 = StringsKt.toIntOrNull((String)((String)object2.get(0)));
            int n6 = n2 = n5 != null ? n5 : 0;
            if (object2.size() > 1) {
                Integer n7 = StringsKt.toIntOrNull((String)((String)object2.get(1)));
                int n8 = n3 = n7 != null ? n7 : 0;
                if (object2.size() > 2) {
                    Integer n9 = StringsKt.toIntOrNull((String)((String)object2.get(2)));
                    n4 = n9 != null ? n9 : 0;
                    return new RiderArtifactBuildVersion(n, n2, n3, n4);
                }
                Object object5 = applicationInfo.getMicroVersion();
                n4 = object5 != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null ? (Integer)object5 : 0;
                return new RiderArtifactBuildVersion(n, n2, n3, n4);
            }
        } else {
            n2 = 0;
        }
        n3 = (object = applicationInfo.getMicroVersion()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        Object object6 = applicationInfo.getPatchVersion();
        n4 = object6 != null && (object6 = StringsKt.toIntOrNull((String)object6)) != null ? (Integer)object6 : 0;
        return new RiderArtifactBuildVersion(n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean j(String string) {
        URLConnection uRLConnection;
        boolean bl;
        URLConnection uRLConnection2;
        block5: {
            uRLConnection2 = null;
            uRLConnection2 = new URL(string).openConnection();
            uRLConnection2.setConnectTimeout(30000);
            uRLConnection2.setReadTimeout(30000);
            if (!(uRLConnection2 instanceof HttpURLConnection)) break block5;
            ((HttpURLConnection)uRLConnection2).setRequestMethod("HEAD");
            int n = ((HttpURLConnection)uRLConnection2).getResponseCode();
            boolean bl2 = n == 200;
            URLConnection uRLConnection3 = uRLConnection2;
            HttpURLConnection httpURLConnection = uRLConnection3 instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection3 : null;
            if (httpURLConnection == null) return bl2;
            httpURLConnection.disconnect();
            return bl2;
        }
        try {
            uRLConnection2.connect();
            bl = true;
            uRLConnection = uRLConnection2;
        }
        catch (Throwable throwable) {
            URLConnection uRLConnection4;
            try {
                logger.warn(throwable);
                uRLConnection4 = uRLConnection2;
            }
            catch (Throwable throwable2) {
                URLConnection uRLConnection5 = uRLConnection2;
                HttpURLConnection httpURLConnection = uRLConnection5 instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection5 : null;
                if (httpURLConnection == null) throw throwable2;
                httpURLConnection.disconnect();
                throw throwable2;
            }
            if (!(uRLConnection4 instanceof HttpURLConnection)) return false;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection4;
            if (httpURLConnection == null) return false;
            httpURLConnection.disconnect();
            return false;
        }
        HttpURLConnection httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
        if (httpURLConnection == null) return bl;
        httpURLConnection.disconnect();
        return bl;
    }

    private static final VersionAndDownloadUrl j(CPUKind cPUKind, String string) {
        logger.info("Trying to find remote debugger tools of version " + string + " (CPU kind " + cPUKind + ")");
        RiderArtifactBuildVersion riderArtifactBuildVersion = RiderArtifactBuildVersion.Companion.parse(string);
        String string2 = INSTANCE.j(cPUKind, string);
        if (RemoteDebuggerToolsDownloadHelper.j(string2)) {
            return new VersionAndDownloadUrl(riderArtifactBuildVersion, string2);
        }
        logger.warn("Download url for cpu " + cPUKind + " and version " + riderArtifactBuildVersion + " is invalid (" + string2 + ")");
        return null;
    }

    private static final VersionAndDownloadUrl j(CPUKind cPUKind, Pair<RiderRemoteToolsRelease, RiderArtifactBuildVersion> pair) {
        RiderRemoteToolsDownload riderRemoteToolsDownload = ((RiderRemoteToolsRelease)pair.getFirst()).getDownloads().get(cPUKind.getDownloadKey());
        if (riderRemoteToolsDownload == null) {
            throw new IllegalStateException("Artifacts for cpu " + cPUKind.getDirectoryName() + " should exist at this point");
        }
        RiderRemoteToolsDownload riderRemoteToolsDownload2 = riderRemoteToolsDownload;
        return new VersionAndDownloadUrl((RiderArtifactBuildVersion)pair.getSecond(), riderRemoteToolsDownload2.getLink());
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(RemoteDebuggerUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/RemoteDebuggerToolsDownloadHelper$VersionAndDownloadUrl;", "", "version", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderArtifactBuildVersion;", "downloadUrl", "", "(Lcom/jetbrains/rider/debugger/attach/remoting/RiderArtifactBuildVersion;Ljava/lang/String;)V", "getDownloadUrl", "()Ljava/lang/String;", "getVersion", "()Lcom/jetbrains/rider/debugger/attach/remoting/RiderArtifactBuildVersion;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class VersionAndDownloadUrl {
        @NotNull
        private final RiderArtifactBuildVersion version;
        @NotNull
        private final String downloadUrl;

        public VersionAndDownloadUrl(@NotNull RiderArtifactBuildVersion version, @NotNull String downloadUrl) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            this.version = version;
            this.downloadUrl = downloadUrl;
        }

        @NotNull
        public final RiderArtifactBuildVersion getVersion() {
            return this.version;
        }

        @NotNull
        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @NotNull
        public final RiderArtifactBuildVersion component1() {
            return this.version;
        }

        @NotNull
        public final String component2() {
            return this.downloadUrl;
        }

        @NotNull
        public final VersionAndDownloadUrl copy(@NotNull RiderArtifactBuildVersion version, @NotNull String downloadUrl) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)downloadUrl, (String)"downloadUrl");
            return new VersionAndDownloadUrl(version, downloadUrl);
        }

        public static /* synthetic */ VersionAndDownloadUrl copy$default(VersionAndDownloadUrl versionAndDownloadUrl, RiderArtifactBuildVersion riderArtifactBuildVersion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                riderArtifactBuildVersion = versionAndDownloadUrl.version;
            }
            if ((n & 2) != 0) {
                string = versionAndDownloadUrl.downloadUrl;
            }
            return versionAndDownloadUrl.copy(riderArtifactBuildVersion, string);
        }

        @NotNull
        public String toString() {
            return "VersionAndDownloadUrl(version=" + this.version + ", downloadUrl=" + this.downloadUrl + ")";
        }

        public int hashCode() {
            int n = this.version.hashCode();
            n = n * 31 + this.downloadUrl.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionAndDownloadUrl)) {
                return false;
            }
            VersionAndDownloadUrl versionAndDownloadUrl = (VersionAndDownloadUrl)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)versionAndDownloadUrl.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.downloadUrl, (Object)versionAndDownloadUrl.downloadUrl);
        }
    }
}

