/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.remoting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.channels.SftpChannel;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.attach.remoting.JetBrainsUnarchiver;
import com.jetbrains.rider.debugger.attach.remoting.RemoteOSUtil;
import com.jetbrains.rider.util.OSKind;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/debugger/attach/remoting/JetBrainsUnarchiver;", "", "()V", "UNARCHIVER_NAME", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "deploy", "sftpChannel", "Lcom/intellij/ssh/channels/SftpChannel;", "remoteDir", "Lcom/jetbrains/rider/PathInfo;", "unarchiverFile", "Ljava/io/File;", "j", "cpu", "Lcom/jetbrains/rider/CPUKind;", "getRemoteLocation", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "localUnarchiverFile", "(Lcom/jetbrains/rider/PathInfo;Lcom/intellij/remote/RemoteCredentials;Lcom/jetbrains/rider/CPUKind;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUnarchiver", "j", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nJetBrainsUnarchiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsUnarchiver.kt\ncom/jetbrains/rider/debugger/attach/remoting/JetBrainsUnarchiver\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n13#3:81\n*S KotlinDebug\n*F\n+ 1 JetBrainsUnarchiver.kt\ncom/jetbrains/rider/debugger/attach/remoting/JetBrainsUnarchiver\n*L\n16#1:80\n16#1:81\n*E\n"})
public final class JetBrainsUnarchiver {
    @NotNull
    public static final JetBrainsUnarchiver INSTANCE = new JetBrainsUnarchiver();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String UNARCHIVER_NAME = "jb_zip_unarchiver";

    private JetBrainsUnarchiver() {
    }

    @NotNull
    public final String deploy(@NotNull SftpChannel sftpChannel, @NotNull PathInfo remoteDir2, @NotNull File unarchiverFile) {
        Intrinsics.checkNotNullParameter((Object)sftpChannel, (String)"sftpChannel");
        Intrinsics.checkNotNullParameter((Object)remoteDir2, (String)"remoteDir");
        Intrinsics.checkNotNullParameter((Object)unarchiverFile, (String)"unarchiverFile");
        Object object = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)unarchiverFile.getName(), (String)"getName(...)");
        String string = remoteDir2.appendPath(object).getSftpPath();
        String string2 = string.substring(string.length() - unarchiverFile.getName().length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        object = string2;
        sftpChannel.uploadFileOrDir(unarchiverFile, remoteDir2.getSftpPath(), (String)object);
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)unarchiverFile.getName(), (String)"getName(...)");
        return remoteDir2.appendPath(stringArray).getPath();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getRemoteLocation(@NotNull PathInfo var1_1, @NotNull RemoteCredentials var2_2, @NotNull CPUKind var3_3, @NotNull File var4_4, @NotNull Continuation<? super String> var5_5) {
        if (!(var5_5 instanceof getRemoteLocation.1)) ** GOTO lbl-1000
        var10_6 = var5_5;
        if ((var10_6.label & -2147483648) != 0) {
            var10_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var10_6 = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JetBrainsUnarchiver this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getRemoteLocation(null, null, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        var9_7 = var10_6.result;
        var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var10_6.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var9_7);
                var7_9 = new PathInfo[2];
                var8_10 = new String[]{this.j((File)localUnarchiverFile)};
                var7_9[0] = remoteDir.appendPath(var8_10);
                var8_10 = new String[]{this.j((CPUKind)cpu)};
                var7_9[1] = remoteDir.appendPath(var8_10);
                var6_11 = CollectionsKt.listOf((Object[])var7_9);
                var7_9 = var6_11.iterator();
lbl19:
                // 2 sources

                while (var7_9.hasNext()) {
                    var8_10 = (String[])var7_9.next();
                    var10_6.L$0 = credentials;
                    var10_6.L$1 = var7_9;
                    var10_6.L$2 = var8_10;
                    var10_6.label = 1;
                    v0 = RemoteOSUtil.fileExists$default(RemoteOSUtil.INSTANCE, credentials, (PathInfo)var8_10, 0L, (Continuation)var10_6, 2, null);
                    if (v0 == var11_8) {
                        return var11_8;
                    }
                    ** GOTO lbl36
                }
                break;
            }
            case 1: {
                var8_10 = (String[])var10_6.L$2;
                var7_9 = (Iterator)var10_6.L$1;
                credentials = (RemoteCredentials)var10_6.L$0;
                ResultKt.throwOnFailure((Object)var9_7);
                v0 = var9_7;
lbl36:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) ** GOTO lbl19
                return var8_10.getPath();
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final File getUnarchiver(@NotNull CPUKind cpu) {
        Intrinsics.checkNotNullParameter((Object)cpu, (String)"cpu");
        File file2 = RiderEnvironment.INSTANCE.getBundledBinDir();
        if (!file2.isDirectory()) {
            logger.error("Bin directory " + file2 + " does not exist, can't find unarchiver");
            return null;
        }
        File file3 = new File(file2, cpu.getDirectoryName());
        if (!file2.isDirectory()) {
            logger.error("Cpu-specific directory " + file3 + " does not exist, can't find unarchiver");
            return null;
        }
        Object[] objectArray = file3.listFiles(JetBrainsUnarchiver::j);
        if (objectArray == null || objectArray.length == 0) {
            logger.error("There's no unarchiver available in the directory " + file3);
            return null;
        }
        if (objectArray.length > 1) {
            logger.warn("More than one unarchiver are available: [" + ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]");
        }
        File file4 = (File)ArraysKt.first((Object[])objectArray);
        if (SystemInfo.isUnix && !file4.canExecute()) {
            file4.setExecutable(true);
        }
        return file4;
    }

    private final String j(File file2) {
        return file2.getParentFile().getName() + "/" + file2.getName();
    }

    private final String j(CPUKind cPUKind) {
        return "jb_zip_unarchiver_" + cPUKind.getDirectoryName() + (cPUKind.getOsKind() == OSKind.Windows ? ".exe" : "");
    }

    private static final boolean j(File file2, String string) {
        return StringsKt.equals((String)FilesKt.getNameWithoutExtension((File)new File(string)), (String)UNARCHIVER_NAME, (boolean)true);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(JetBrainsUnarchiver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

