/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.mono;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.jetbrains.rider.debugger.attach.RiderAttachUtilKt;
import com.jetbrains.rider.debugger.attach.mono.MonoAttachDebugger;
import com.jetbrains.rider.debugger.attach.mono.MonoAttachGroup;
import com.jetbrains.rider.debugger.attach.remoting.RiderSshAttachHost;
import com.jetbrains.rider.runtime.mono.MonoRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/debugger/attach/mono/MonoAttachProvider;", "Lcom/intellij/xdebugger/attach/XAttachDebuggerProvider;", "()V", "getAvailableDebuggers", "", "Lcom/intellij/xdebugger/attach/XAttachDebugger;", "project", "Lcom/intellij/openapi/project/Project;", "hostInfo", "Lcom/intellij/xdebugger/attach/XAttachHost;", "process", "Lcom/intellij/execution/process/ProcessInfo;", "contextHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getPresentationGroup", "Lcom/intellij/xdebugger/attach/XAttachPresentationGroup;", "isAttachHostApplicable", "", "attachHost", "Util", "intellij.rider"})
public final class MonoAttachProvider
implements XAttachDebuggerProvider {
    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        Intrinsics.checkNotNullParameter((Object)attachHost, (String)"attachHost");
        return attachHost instanceof LocalAttachHost || attachHost instanceof RiderSshAttachHost;
    }

    @NotNull
    public List<XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost hostInfo2, @NotNull ProcessInfo process2, @NotNull UserDataHolder contextHolder) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hostInfo2, (String)"hostInfo");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)contextHolder, (String)"contextHolder");
        if (hostInfo2 instanceof LocalAttachHost && RiderAttachUtilKt.shouldExcludeProcessFromAttachDialog(process2)) {
            return new ArrayList();
        }
        if (!MonoRuntime.Companion.getPossibleMonoExecutables().contains(process2.getExecutableName())) {
            return new ArrayList();
        }
        Regex regex = Util.INSTANCE.getAddressMatcher$intellij_rider();
        String string = process2.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            return new ArrayList();
        }
        MatchResult matchResult2 = matchResult;
        if (((Collection)matchResult2.getGroupValues()).size() < 3) {
            return new ArrayList();
        }
        String string2 = (String)matchResult2.getGroupValues().get(1);
        String string3 = (String)matchResult2.getGroupValues().get(2);
        try {
            int n = Integer.parseInt(string3);
            Object[] objectArray = new XAttachDebugger[]{new MonoAttachDebugger(string2, n, hostInfo2)};
            list2 = CollectionsKt.arrayListOf((Object[])objectArray);
        }
        catch (NumberFormatException numberFormatException) {
            list2 = new ArrayList();
        }
        return list2;
    }

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        return MonoAttachGroup.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/attach/mono/MonoAttachProvider$Util;", "", "()V", "addressMatcher", "Lkotlin/text/Regex;", "getAddressMatcher$intellij_rider", "()Lkotlin/text/Regex;", "intellij.rider"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        @NotNull
        private static final Regex addressMatcher = new Regex("address=([.\\w]+):(\\d+)", RegexOption.IGNORE_CASE);

        private Util() {
        }

        @NotNull
        public final Regex getAddressMatcher$intellij_rider() {
            return addressMatcher;
        }
    }
}

