/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.mono;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.impl.ui.attach.dialog.extensions.XAttachTreeDebuggersPresentationProvider;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.attach.RiderAttachGroupBase;
import com.jetbrains.rider.debugger.attach.RiderRecentItemMatchingRuleProvider;
import com.jetbrains.rider.debugger.attach.RiderStringAlwaysAllowMatchingRule;
import com.jetbrains.rider.debugger.attach.RiderStringMatchingRule;
import com.jetbrains.rider.debugger.attach.RiderStringStrictMatchingRule;
import com.jetbrains.rider.debugger.attach.util.PlatformType;
import com.jetbrains.rider.debugger.attach.util.PresentationUtilKt;
import com.jetbrains.rider.runtime.mono.MonoRuntime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/debugger/attach/mono/MonoAttachGroup;", "Lcom/jetbrains/rider/debugger/attach/RiderAttachGroupBase;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/extensions/XAttachTreeDebuggersPresentationProvider;", "Lcom/jetbrains/rider/debugger/attach/RiderRecentItemMatchingRuleProvider;", "()V", "compare", "", "o1", "Lcom/intellij/execution/process/ProcessInfo;", "o2", "getDebuggersShortName", "", "getGroupName", "getItemDisplayText", "project", "Lcom/intellij/openapi/project/Project;", "info", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getOrder", "getRules", "", "Lcom/jetbrains/rider/debugger/attach/RiderStringMatchingRule;", "commandLine", "intellij.rider"})
public final class MonoAttachGroup
extends RiderAttachGroupBase
implements XAttachTreeDebuggersPresentationProvider,
RiderRecentItemMatchingRuleProvider {
    @NotNull
    public static final MonoAttachGroup INSTANCE = new MonoAttachGroup();

    private MonoAttachGroup() {
    }

    @Override
    public int compare(@NotNull ProcessInfo o1, @NotNull ProcessInfo o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return Intrinsics.compare((int)o1.getPid(), (int)o2.getPid());
    }

    public int getOrder() {
        return 1;
    }

    @NotNull
    public String getGroupName() {
        return RiderDebuggerBundle.Companion.message("MonoAttachGroup.group.name.mono.processes", new Object[0]);
    }

    @NlsSafe
    @NotNull
    public String getItemDisplayText(@NotNull Project project, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        String string = info.getCommandLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLine(...)");
        return PresentationUtilKt.shortProcessPresentation(string, PlatformType.Mono);
    }

    @NotNull
    public String getDebuggersShortName() {
        return RiderDebuggerBundle.Companion.message("MonoAttachDebugger.display.short.name.mono.debugger", new Object[0]);
    }

    @Override
    @NotNull
    public List<RiderStringMatchingRule> getRules(@NotNull List<String> commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
        List list2 = new ArrayList();
        for (int k = 0; k < commandLine.size(); ++k) {
            String string = commandLine.get(k);
            if (MonoRuntime.Companion.isMonoExecutable(string)) {
                list2.add(new RiderStringStrictMatchingRule(string));
                continue;
            }
            if (StringsKt.endsWith((String)string, (String)".dll", (boolean)true) || StringsKt.endsWith((String)string, (String)".exe", (boolean)true)) {
                list2.add(new RiderStringStrictMatchingRule(string));
                continue;
            }
            list2.add(RiderStringAlwaysAllowMatchingRule.INSTANCE);
        }
        return list2;
    }
}

