/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.dotnet;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.attach.RiderAttachDebuggerBase;
import com.jetbrains.rider.debugger.attach.RiderJitDebuggerKeyProvider;
import com.jetbrains.rider.debugger.attach.remoting.RiderSshAttachHost;
import com.jetbrains.rider.model.DesktopClrRuntime;
import com.jetbrains.rider.model.GenericCoreClrRuntime;
import com.jetbrains.rider.model.GenericProcessInfoBase;
import com.jetbrains.rider.model.ProcessRuntimeInformation;
import com.jetbrains.rider.model.RdProcessInfoBase;
import com.jetbrains.rider.model.UwpCoreClrRuntime;
import com.jetbrains.rider.model.WindowsProcessInfo;
import com.jetbrains.rider.model.debuggerHelper.PlatformArchitecture;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreAttachProfile;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreRemoteAttachProfile;
import com.jetbrains.rider.run.dotNetCore.PlatformUtilKt;
import com.jetbrains.rider.run.msNet.MsNetAttachRunProfile;
import com.jetbrains.rider.run.msNet.MsNetRemoteAttachRunProfile;
import com.jetbrains.rider.run.uwp.UwpAttachRunProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/debugger/attach/dotnet/MsNetAttachDebugger;", "Lcom/jetbrains/rider/debugger/attach/RiderAttachDebuggerBase;", "Lcom/jetbrains/rider/model/RdProcessInfoBase;", "Lcom/jetbrains/rider/debugger/attach/RiderJitDebuggerKeyProvider;", "processInfo", "runtime", "Lcom/jetbrains/rider/model/ProcessRuntimeInformation;", "(Lcom/jetbrains/rider/model/RdProcessInfoBase;Lcom/jetbrains/rider/model/ProcessRuntimeInformation;)V", "getRuntime", "()Lcom/jetbrains/rider/model/ProcessRuntimeInformation;", "createLocalAttachProfile", "Lcom/intellij/execution/configurations/RunProfile;", "Lcom/intellij/execution/process/ProcessInfo;", "rdProcessInfo", "localAttachHost", "Lcom/intellij/xdebugger/attach/LocalAttachHost;", "createRemoteAttachProfile", "remoteAttachHost", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshAttachHost;", "getDebuggerDisplayName", "", "getDebuggerKey", "intellij.rider"})
public final class MsNetAttachDebugger
extends RiderAttachDebuggerBase<RdProcessInfoBase>
implements RiderJitDebuggerKeyProvider {
    @NotNull
    private final ProcessRuntimeInformation runtime;

    public MsNetAttachDebugger(@NotNull RdProcessInfoBase processInfo, @NotNull ProcessRuntimeInformation runtime) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        super(processInfo);
        this.runtime = runtime;
    }

    @NotNull
    public final ProcessRuntimeInformation getRuntime() {
        return this.runtime;
    }

    @Override
    @NotNull
    public RunProfile createLocalAttachProfile(@NotNull ProcessInfo processInfo, @NotNull RdProcessInfoBase rdProcessInfo, @NotNull LocalAttachHost localAttachHost) {
        RunProfile runProfile2;
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)rdProcessInfo, (String)"rdProcessInfo");
        Intrinsics.checkNotNullParameter((Object)localAttachHost, (String)"localAttachHost");
        if ((rdProcessInfo instanceof GenericProcessInfoBase ? (GenericProcessInfoBase)rdProcessInfo : null) == null) {
            throw new IllegalStateException("Process info is expected to be " + GenericProcessInfoBase.class.getSimpleName());
        }
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            runProfile2 = new MsNetAttachRunProfile(processInfo, PlatformUtilKt.toWindowsCPUKind(((GenericProcessInfoBase)rdProcessInfo).getPlatform()), (DesktopClrRuntime)this.runtime, this.getDebuggerDisplayName());
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            runProfile2 = new UwpAttachRunProfile(processInfo, PlatformUtilKt.toWindowsCPUKind(((GenericProcessInfoBase)rdProcessInfo).getPlatform()), null, this.getDebuggerDisplayName());
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            runProfile2 = new DotNetCoreAttachProfile(processInfo, ((GenericProcessInfoBase)rdProcessInfo).getPlatform(), this.getDebuggerDisplayName());
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.runtime.getClass().getSimpleName(), (String)"getSimpleName(...)");
            throw new CantRunException(RiderDebuggerBundle.Companion.message("rider.debug.attach.unknown.runtime.message", objectArray));
        }
        return runProfile2;
    }

    @Override
    @NotNull
    public RunProfile createRemoteAttachProfile(@NotNull ProcessInfo processInfo, @NotNull RdProcessInfoBase rdProcessInfo, @NotNull RiderSshAttachHost remoteAttachHost) {
        RunProfile runProfile2;
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter((Object)rdProcessInfo, (String)"rdProcessInfo");
        Intrinsics.checkNotNullParameter((Object)remoteAttachHost, (String)"remoteAttachHost");
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            if ((rdProcessInfo instanceof WindowsProcessInfo ? (WindowsProcessInfo)rdProcessInfo : null) == null) {
                throw new IllegalStateException("Process info is expected to be " + WindowsProcessInfo.class.getSimpleName());
            }
            runProfile2 = new MsNetRemoteAttachRunProfile(processInfo, ((WindowsProcessInfo)rdProcessInfo).getPlatform(), (DesktopClrRuntime)this.runtime, remoteAttachHost);
        } else {
            if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
                throw new CantRunException(RiderDebuggerBundle.Companion.message("dialog.message.remote.debugging.uwp.not.supported", new Object[0]));
            }
            if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
                GenericProcessInfoBase genericProcessInfoBase = rdProcessInfo instanceof GenericProcessInfoBase ? (GenericProcessInfoBase)rdProcessInfo : null;
                if (genericProcessInfoBase == null || (genericProcessInfoBase = genericProcessInfoBase.getPlatform()) == null) {
                    genericProcessInfoBase = PlatformArchitecture.Unknown;
                }
                runProfile2 = new DotNetCoreRemoteAttachProfile(processInfo, (PlatformArchitecture)genericProcessInfoBase, remoteAttachHost);
            } else {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)this.runtime.getClass().getSimpleName(), (String)"getSimpleName(...)");
                throw new CantRunException(RiderDebuggerBundle.Companion.message("rider.debug.attach.unknown.runtime.message", objectArray));
            }
        }
        return runProfile2;
    }

    @NotNull
    public String getDebuggerDisplayName() {
        String string;
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            string = RiderDebuggerBundle.Companion.message("MsNetAttachProvider.display.name", new Object[0]);
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            string = RiderDebuggerBundle.Companion.message("MsNetAttachProvider.display.name", new Object[0]);
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            string = RiderDebuggerBundle.Companion.message("MsNetUwpAttachDebugger.display.name", new Object[0]);
        } else {
            throw new IllegalStateException("Unexpected type of runtime: " + this.runtime.getClass().getSimpleName());
        }
        return string;
    }

    @Override
    @NotNull
    public String getDebuggerKey() {
        String string;
        ProcessRuntimeInformation processRuntimeInformation = this.runtime;
        if (processRuntimeInformation instanceof DesktopClrRuntime) {
            string = "netframework";
        } else if (processRuntimeInformation instanceof GenericCoreClrRuntime) {
            string = "netcore";
        } else if (processRuntimeInformation instanceof UwpCoreClrRuntime) {
            string = "netcore";
        } else {
            throw new IllegalStateException("Unexpected type of runtime: " + this.runtime.getClass().getSimpleName());
        }
        return string;
    }
}

