/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach.dotnet;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.impl.ui.attach.dialog.extensions.XAttachTreeDebuggersPresentationProvider;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.attach.CollectedProcessesAttachProviderBase;
import com.jetbrains.rider.debugger.attach.RiderAttachGroupBase;
import com.jetbrains.rider.debugger.attach.RiderRecentItemMatchingRuleProvider;
import com.jetbrains.rider.debugger.attach.RiderRemoteProcessInfo;
import com.jetbrains.rider.debugger.attach.RiderStringAlwaysAllowMatchingRule;
import com.jetbrains.rider.debugger.attach.RiderStringMatchingRule;
import com.jetbrains.rider.debugger.attach.RiderStringStrictMatchingRule;
import com.jetbrains.rider.debugger.attach.util.PresentationUtilKt;
import com.jetbrains.rider.model.DesktopClrRuntime;
import com.jetbrains.rider.model.GenericProcessInfoBase;
import com.jetbrains.rider.model.ProcessRuntimeInformation;
import com.jetbrains.rider.model.RdProcessInfoBase;
import com.jetbrains.rider.model.WindowsProcessInfo;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/debugger/attach/dotnet/MsClrAttachGroup;", "Lcom/jetbrains/rider/debugger/attach/RiderAttachGroupBase;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/extensions/XAttachTreeDebuggersPresentationProvider;", "Lcom/jetbrains/rider/debugger/attach/RiderRecentItemMatchingRuleProvider;", "()V", "dotnetMarkers", "", "", "getDebuggersShortName", "getGroupName", "getItemDisplayText", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/execution/process/ProcessInfo;", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getOrder", "", "getRules", "", "Lcom/jetbrains/rider/debugger/attach/RiderStringMatchingRule;", "commandLine", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nMsClrAttachGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsClrAttachGroup.kt\ncom/jetbrains/rider/debugger/attach/dotnet/MsClrAttachGroup\n+ 2 RdProcessUtil.kt\ncom/jetbrains/rider/debugger/attach/util/RdProcessUtilKt\n+ 3 PresentationUtil.kt\ncom/jetbrains/rider/debugger/attach/util/PresentationUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n10#2,4:64\n38#3:68\n16#3:69\n18#3,4:81\n39#3:85\n800#4,11:70\n*S KotlinDebug\n*F\n+ 1 MsClrAttachGroup.kt\ncom/jetbrains/rider/debugger/attach/dotnet/MsClrAttachGroup\n*L\n22#1:64,4\n25#1:68\n25#1:69\n25#1:81,4\n25#1:85\n25#1:70,11\n*E\n"})
public final class MsClrAttachGroup
extends RiderAttachGroupBase
implements XAttachTreeDebuggersPresentationProvider,
RiderRecentItemMatchingRuleProvider {
    @NotNull
    public static final MsClrAttachGroup INSTANCE = new MsClrAttachGroup();
    @NotNull
    private static final Set<String> dotnetMarkers;

    private MsClrAttachGroup() {
    }

    @NlsSafe
    @NotNull
    public String getItemDisplayText(@NotNull Project project, @NotNull ProcessInfo info, @NotNull UserDataHolder dataHolder) {
        WindowsProcessInfo windowsProcessInfo;
        RdProcessInfoBase rdProcessInfoBase;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        ProcessInfo processInfo = info;
        boolean bl = false;
        if (processInfo instanceof RiderRemoteProcessInfo) {
            RdProcessInfoBase rdProcessInfoBase2 = ((RiderRemoteProcessInfo)processInfo).getRdProcessInfo();
            if (!(rdProcessInfoBase2 instanceof WindowsProcessInfo)) {
                rdProcessInfoBase2 = null;
            }
            rdProcessInfoBase = (RdProcessInfoBase)((WindowsProcessInfo)rdProcessInfoBase2);
        } else {
            Map map2 = (Map)dataHolder.getUserData(CollectedProcessesAttachProviderBase.Companion.getClrProcessesKey());
            RdProcessInfoBase rdProcessInfoBase3 = map2 != null ? (RdProcessInfoBase)map2.get(processInfo.getPid()) : null;
            if (!(rdProcessInfoBase3 instanceof WindowsProcessInfo)) {
                rdProcessInfoBase3 = null;
            }
            rdProcessInfoBase = (RdProcessInfoBase)((WindowsProcessInfo)rdProcessInfoBase3);
        }
        WindowsProcessInfo windowsProcessInfo2 = (WindowsProcessInfo)rdProcessInfoBase;
        if (windowsProcessInfo2 == null) {
            String string = info.getExecutableDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
            return string;
        }
        WindowsProcessInfo windowsProcessInfo3 = windowsProcessInfo = windowsProcessInfo2;
        boolean bl2 = false;
        GenericProcessInfoBase genericProcessInfoBase = (GenericProcessInfoBase)windowsProcessInfo3;
        boolean bl3 = false;
        Object object = genericProcessInfoBase.getRuntimes();
        boolean bl4 = false;
        Iterable iterable = object;
        Collection collection = new ArrayList();
        boolean bl5 = false;
        for (Object t : iterable) {
            if (!(t instanceof DesktopClrRuntime)) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        object = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<DesktopClrRuntime, CharSequence>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @NotNull
            public final CharSequence invoke(@NotNull ProcessRuntimeInformation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DesktopClrRuntime desktopClrRuntime = (DesktopClrRuntime)it;
                boolean bl = false;
                return desktopClrRuntime.getVersion();
            }
        }), (int)30, null);
        Object object2 = !StringsKt.isBlank((CharSequence)((CharSequence)object)) ? " [" + (String)object + "]" : "";
        return PresentationUtilKt.presentWindowsProcess(windowsProcessInfo3, (String)object2);
    }

    public int getOrder() {
        return 0;
    }

    @NotNull
    public String getGroupName() {
        return RiderDebuggerBundle.Companion.message("MsClrAttachGroup.group.name.net.processes", new Object[0]);
    }

    @NotNull
    public String getDebuggersShortName() {
        return RiderDebuggerBundle.Companion.message("MsNetAttachDebugger.display.short.name", new Object[0]);
    }

    @Override
    @NotNull
    public List<RiderStringMatchingRule> getRules(@NotNull List<String> commandLine) {
        Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
        List list2 = new ArrayList();
        for (int k = 0; k < commandLine.size(); ++k) {
            String string = commandLine.get(k);
            if (DotNetCoreRuntime.Companion.isPossiblyDotNetCliPath(string)) {
                list2.add(new RiderStringStrictMatchingRule(string));
                continue;
            }
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (dotnetMarkers.contains(string2)) {
                list2.add(new RiderStringStrictMatchingRule(string));
                if (k >= commandLine.size() - 1) continue;
                list2.add(new RiderStringStrictMatchingRule(commandLine.get(k + 1)));
                ++k;
                continue;
            }
            if (StringsKt.endsWith((String)string, (String)".dll", (boolean)true) || StringsKt.endsWith((String)string, (String)".exe", (boolean)true)) {
                list2.add(new RiderStringStrictMatchingRule(string));
                continue;
            }
            list2.add(RiderStringAlwaysAllowMatchingRule.INSTANCE);
        }
        return list2;
    }

    static {
        Object[] objectArray = new String[]{"--runtimeconfig", "exec"};
        dotnetMarkers = SetsKt.setOf((Object[])objectArray);
    }
}

