/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.attach;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachHost;
import com.jetbrains.rider.debugger.attach.RiderAttachConfiguration;
import com.jetbrains.rider.debugger.attach.RiderAttachConfigurationType;
import com.jetbrains.rider.debugger.attach.remoting.RiderSshAttachHost;
import com.jetbrains.rider.model.RdProcessInfoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010\u0017R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/debugger/attach/RiderAttachDebuggerBase;", "TProcessInfo", "Lcom/jetbrains/rider/model/RdProcessInfoBase;", "Lcom/intellij/xdebugger/attach/XAttachDebugger;", "rdProcessInfo", "(Lcom/jetbrains/rider/model/RdProcessInfoBase;)V", "Lcom/jetbrains/rider/model/RdProcessInfoBase;", "attachDebugSession", "", "project", "Lcom/intellij/openapi/project/Project;", "hostInfo", "Lcom/intellij/xdebugger/attach/XAttachHost;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "createLocalAttachProfile", "Lcom/intellij/execution/configurations/RunProfile;", "localAttachHost", "Lcom/intellij/xdebugger/attach/LocalAttachHost;", "(Lcom/intellij/execution/process/ProcessInfo;Lcom/jetbrains/rider/model/RdProcessInfoBase;Lcom/intellij/xdebugger/attach/LocalAttachHost;)Lcom/intellij/execution/configurations/RunProfile;", "createRemoteAttachProfile", "remoteAttachHost", "Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshAttachHost;", "(Lcom/intellij/execution/process/ProcessInfo;Lcom/jetbrains/rider/model/RdProcessInfoBase;Lcom/jetbrains/rider/debugger/attach/remoting/RiderSshAttachHost;)Lcom/intellij/execution/configurations/RunProfile;", "intellij.rider"})
public abstract class RiderAttachDebuggerBase<TProcessInfo extends RdProcessInfoBase>
implements XAttachDebugger {
    @NotNull
    private final TProcessInfo rdProcessInfo;

    public RiderAttachDebuggerBase(@NotNull TProcessInfo rdProcessInfo) {
        Intrinsics.checkNotNullParameter(rdProcessInfo, (String)"rdProcessInfo");
        this.rdProcessInfo = rdProcessInfo;
    }

    public void attachDebugSession(@NotNull Project project, @NotNull XAttachHost hostInfo2, @NotNull ProcessInfo processInfo) {
        RunProfile runProfile2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)hostInfo2, (String)"hostInfo");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        XAttachHost xAttachHost = hostInfo2;
        if (xAttachHost instanceof LocalAttachHost) {
            runProfile2 = this.createLocalAttachProfile(processInfo, this.rdProcessInfo, (LocalAttachHost)hostInfo2);
        } else if (xAttachHost instanceof RiderSshAttachHost) {
            runProfile2 = this.createRemoteAttachProfile(processInfo, this.rdProcessInfo, (RiderSshAttachHost)hostInfo2);
        } else {
            throw new IllegalArgumentException("Unsupported attach host " + hostInfo2);
        }
        RunProfile runProfile3 = runProfile2;
        xAttachHost = DefaultDebugExecutor.getDebugExecutorInstance();
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            RiderAttachDebuggerBase.N(project, runProfile3, (Executor)xAttachHost);
        } else {
            ToolWindowManager.Companion.getInstance(project).invokeLater(() -> RiderAttachDebuggerBase.j(project, runProfile3, (Executor)xAttachHost));
        }
    }

    @NotNull
    public abstract RunProfile createLocalAttachProfile(@NotNull ProcessInfo var1, @NotNull TProcessInfo var2, @NotNull LocalAttachHost var3);

    @NotNull
    public abstract RunProfile createRemoteAttachProfile(@NotNull ProcessInfo var1, @NotNull TProcessInfo var2, @NotNull RiderSshAttachHost var3);

    private static final void N(Project project, RunProfile runProfile2, Executor executor2) {
        RunManager runManager2 = RunManager.Companion.getInstance(project);
        String string = runProfile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runManager2.createConfiguration(string, RiderAttachConfigurationType.Companion.getFACTORY());
        RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
        RiderAttachConfiguration riderAttachConfiguration = runConfiguration instanceof RiderAttachConfiguration ? (RiderAttachConfiguration)runConfiguration : null;
        if (riderAttachConfiguration == null) {
            throw new IllegalArgumentException("Created synthetic configuration is not " + RiderAttachConfiguration.class.getSimpleName());
        }
        RiderAttachConfiguration riderAttachConfiguration2 = riderAttachConfiguration;
        riderAttachConfiguration2.setAttachProfile(runProfile2);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (Executor)executor2);
    }

    private static final void j(Project project, RunProfile runProfile2, Executor executor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)runProfile2, (String)"$attachProfile");
        RiderAttachDebuggerBase.N(project, runProfile2, executor2);
    }
}

