/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.debugger.util.JumpToStatementUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/actions/handlers/RiderJumpToStatementHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "()V", "isEnabled", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHidden", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "intellij.rider"})
public final class RiderJumpToStatementHandler
extends XDebuggerSuspendedActionHandler
implements IRiderActionEnabledChecker {
    protected boolean isEnabled(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!XDebuggerSuspendedActionHandler.isEnabled((XDebugSession)session) || !super.isEnabled(session, dataContext)) {
            return false;
        }
        XDebugProcess xDebugProcess = session.getDebugProcess();
        DotNetDebugProcess dotNetDebugProcess = xDebugProcess instanceof DotNetDebugProcess ? (DotNetDebugProcess)xDebugProcess : null;
        if (!(dotNetDebugProcess != null ? DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess) : false)) {
            return false;
        }
        XDebugSessionImpl xDebugSessionImpl = session instanceof XDebugSessionImpl ? (XDebugSessionImpl)session : null;
        XExecutionStack xExecutionStack = xDebugSessionImpl != null ? xDebugSessionImpl.getCurrentExecutionStack() : null;
        DotNetExecutionStack dotNetExecutionStack = xExecutionStack instanceof DotNetExecutionStack ? (DotNetExecutionStack)xExecutionStack : null;
        if (dotNetExecutionStack == null) {
            return false;
        }
        DotNetExecutionStack dotNetExecutionStack2 = dotNetExecutionStack;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)((XDebugSessionImpl)session).getProject(), (DataContext)dataContext);
        if (xSourcePosition == null) {
            return false;
        }
        xDebugProcess = xSourcePosition;
        return JumpToStatementUtilKt.canJumpToStatement((XSourcePosition)xDebugProcess, dotNetExecutionStack2);
    }

    public boolean isHidden(@NotNull Project project, @Nullable AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (!((xDebugSession != null ? xDebugSession.getDebugProcess() : null) instanceof DotNetDebugProcess)) {
            return true;
        }
        return super.isHidden(project, event);
    }

    protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        XDebugProcess xDebugProcess = session.getDebugProcess();
        DotNetDebugProcess dotNetDebugProcess = xDebugProcess instanceof DotNetDebugProcess ? (DotNetDebugProcess)xDebugProcess : null;
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess dotNetDebugProcess2 = dotNetDebugProcess;
        XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext);
        if (xSourcePosition != null) {
            dotNetDebugProcess2.setNextStatement$intellij_rider(xSourcePosition);
        }
    }
}

