/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.actions.StepOverAction;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.debugger.actions.handlers.IRiderActionEnabledChecker;
import com.jetbrains.rider.debugger.actions.handlers.IRiderNoCurrentSessionActionEnabledChecker;
import com.jetbrains.rider.run.startupActivities.BreakAtMethodPostStartupActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderStepOverAction;", "Lcom/intellij/xdebugger/impl/actions/StepOverAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderActionEnabledChecker;", "Lcom/jetbrains/rider/debugger/actions/handlers/IRiderNoCurrentSessionActionEnabledChecker;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "update", "event", "intellij.rider"})
public final class RiderStepOverAction
extends StepOverAction
implements ActionRemoteBehaviorSpecification.Frontend,
IRiderActionEnabledChecker,
IRiderNoCurrentSessionActionEnabledChecker {
    protected boolean isEnabled(@Nullable AnActionEvent e) {
        return this.isEnabledAction(e) && super.isEnabled(e) || this.isEnabledActionWithPostStartupActivityCheck(e, BreakAtMethodPostStartupActivity.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.isSessionInProgress(project2)) {
            super.actionPerformed(e);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.runAndBreakAtEntryPoint(project2, dataContext);
    }

    public void update(@NotNull AnActionEvent event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        String string2 = RiderActionsBundle.Companion.message("RiderStepOverAction.action.step.over.text", new Object[0]);
        if (!this.isEnabled(event)) {
            event.getPresentation().setText(string2);
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        boolean bl = this.isSessionInProgress(project2);
        Presentation presentation2 = event.getPresentation();
        if (bl) {
            string = string2;
        } else {
            Object[] objectArray = new Object[]{string2};
            string = RiderActionsBundle.Companion.message("action.start.debugging.and.0.text", objectArray);
        }
        presentation2.setText(string);
    }
}

