/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderRefreshStackFrameAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "j", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "update", "intellij.rider"})
public final class RiderRefreshStackFrameAction
extends AnAction
implements DumbAware {
    public RiderRefreshStackFrameAction() {
        super(RiderDebuggerBundle.Companion.message("rider.refresh.stack.frame.action.name", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!(e.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT) instanceof XDebuggerFramesList)) {
                return;
            }
            DotNetStackFrame dotNetStackFrame = this.j(e);
            if (dotNetStackFrame == null) break block1;
            dotNetStackFrame.refreshAsync();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DotNetStackFrame dotNetStackFrame = this.j(e);
        e.getPresentation().setEnabledAndVisible(dotNetStackFrame != null && e.getDataContext().getData(PlatformDataKeys.CONTEXT_COMPONENT) instanceof XDebuggerFramesList);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final DotNetStackFrame j(AnActionEvent anActionEvent) {
        Project project = anActionEvent.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project2);
        XDebugSession xDebugSession = xDebuggerManager.getCurrentSession();
        XStackFrame xStackFrame = xDebugSession != null ? xDebugSession.getCurrentStackFrame() : null;
        return xStackFrame instanceof DotNetStackFrame ? (DotNetStackFrame)xStackFrame : null;
    }
}

