/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.actions;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.actions.RiderDebuggerActionEnabledUtilsKt;
import icons.RiderIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/debugger/actions/RiderDetachDebuggerAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
public final class RiderDetachDebuggerAction
extends AnAction
implements DumbAware {
    public RiderDetachDebuggerAction() {
        super(RiderDebuggerBundle.Companion.message("RiderDetachDebuggerAction.action.detach.text", new Object[0]), RiderDebuggerBundle.Companion.message("RiderDetachDebuggerAction.action.detach.description", new Object[0]), RiderIcons.Debugger.Detach);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerWorkerProcessHandler debuggerWorkerProcessHandler;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
        ProcessHandler processHandler2 = runContentDescriptor != null ? runContentDescriptor.getProcessHandler() : null;
        DebuggerWorkerProcessHandler debuggerWorkerProcessHandler2 = debuggerWorkerProcessHandler = processHandler2 instanceof DebuggerWorkerProcessHandler ? (DebuggerWorkerProcessHandler)processHandler2 : null;
        if (debuggerWorkerProcessHandler == null) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            processHandler2 = project;
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)processHandler2).getCurrentSession();
            ProcessHandler processHandler3 = xDebugSession != null && (xDebugSession = xDebugSession.getDebugProcess()) != null ? xDebugSession.getProcessHandler() : null;
            DebuggerWorkerProcessHandler debuggerWorkerProcessHandler3 = debuggerWorkerProcessHandler = processHandler3 instanceof DebuggerWorkerProcessHandler ? (DebuggerWorkerProcessHandler)processHandler3 : null;
        }
        if (debuggerWorkerProcessHandler == null) {
            return;
        }
        debuggerWorkerProcessHandler.detachProcess();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (RiderDebuggerActionEnabledUtilsKt.isWasmClientProfile(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            Project project = e.getProject();
            if (project == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            e.getPresentation().setEnabled(xDebugSession != null);
            if (xDebugSession != null) {
                RunContentDescriptor runContentDescriptor = xDebugSession.getRunContentDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"getRunContentDescriptor(...)");
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
                Presentation presentation2 = e.getPresentation();
                Object object = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor2.getDisplayName(), (String)"getDisplayName(...)");
                presentation2.setText(RiderDebuggerBundle.Companion.message("RiderDetachDebuggerAction.action.detach.0.text", object));
                ProcessHandler processHandler2 = runContentDescriptor2.getProcessHandler();
                Object object2 = object = processHandler2 instanceof DebuggerWorkerProcessHandler ? (DebuggerWorkerProcessHandler)processHandler2 : null;
                if (object == null) {
                    e.getPresentation().setEnabledAndVisible(false);
                }
            }
        } else {
            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            if (runContentDescriptor == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Presentation presentation3 = e.getPresentation();
            Object object = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor.getDisplayName(), (String)"getDisplayName(...)");
            presentation3.setText(RiderDebuggerBundle.Companion.message("RiderDetachDebuggerAction.action.detach.0.text", object));
            ProcessHandler processHandler3 = runContentDescriptor.getProcessHandler();
            Object object3 = object = processHandler3 instanceof DebuggerWorkerProcessHandler ? (DebuggerWorkerProcessHandler)processHandler3 : null;
            if (object == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (object.isProcessTerminated() || object.isProcessTerminating()) {
                e.getPresentation().setEnabled(false);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

