/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.debugger.Builder;
import com.jetbrains.rider.debugger.ContentTypeConverter;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/debugger/UrlEncodedBuilder;", "Lcom/jetbrains/rider/debugger/Builder;", "project", "Lcom/intellij/openapi/project/Project;", "value", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "kotlin.jvm.PlatformType", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "key", "getKey", "()Ljava/lang/String;", "prettified", "getPrettified", "prettyTabName", "getPrettyTabName", "visualizerContentType", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "getVisualizerContentType", "()Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "intellij.rider"})
final class UrlEncodedBuilder
extends Builder {
    @NotNull
    private final VisualizerContentType visualizerContentType;
    private final LanguageFileType fileType;
    @NotNull
    private final String prettyTabName;
    @NotNull
    private final String prettified;

    public UrlEncodedBuilder(@NotNull Project project, @NlsSafe @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(project, value);
        this.visualizerContentType = VisualizerContentType.URLEncoded;
        this.fileType = FileTypes.PLAIN_TEXT;
        this.prettyTabName = "URL-decoded";
        this.prettified = new ContentTypeConverter().decodeUrl(value);
    }

    @Override
    @NotNull
    public VisualizerContentType getVisualizerContentType() {
        return this.visualizerContentType;
    }

    public LanguageFileType getFileType() {
        return this.fileType;
    }

    @Override
    @NotNull
    public String getPrettyTabName() {
        return this.prettyTabName;
    }

    @Override
    @NotNull
    public String getKey() {
        return "Rider.Visualizers.UrlEncodedBuilder";
    }

    @Override
    @NotNull
    public String getPrettified() {
        return this.prettified;
    }
}

