/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import icons.RiderIcons;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/RiderThreadData;", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "stack", "Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "isActiveThread", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/debugger/DotNetExecutionStack;Z)V", "getStack", "()Lcom/jetbrains/rider/debugger/DotNetExecutionStack;", "getElement", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.rider"})
public final class RiderThreadData
extends PresentableNodeDescriptor<Unit> {
    @NotNull
    private final DotNetExecutionStack stack;

    public RiderThreadData(@NotNull Project project, @NotNull DotNetExecutionStack stack, boolean isActiveThread) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)stack), (String)"stack");
        super(project, null);
        this.stack = stack;
        this.getPresentation().getColoredText().add(new PresentableNodeDescriptor.ColoredFragment(this.stack.getThreadProxy().getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES));
        this.getPresentation().getColoredText().add(new PresentableNodeDescriptor.ColoredFragment(" @" + this.stack.getThreadProxy().getThreadId(), SimpleTextAttributes.GRAYED_ATTRIBUTES));
        this.setIcon(isActiveThread ? AllIcons.Debugger.ThreadCurrent : RiderIcons.Debugger.SingleThread);
    }

    @NotNull
    public final DotNetExecutionStack getStack() {
        return this.stack;
    }

    public void getElement() {
    }

    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
    }
}

